unit Scmain;
{
 Copier-Utility: CompuCopier
 This program demonstrate the use of the eztwain.dll (eztwain.pas).
 If you have a flatbed scanner and a graphics printer, you can use
 'Compu-Copier' to make copies of a sheet of paper in an easy way.

 known bugs:
 - if the scanner doesn't deliver resolution information, the copy
   may not have the same size as the original (at 100% user scale)

 history:
 1.0a:  first release
 1.0b:  Divison by zero removed, if the TWAIN-Scanner doesn't deliver
        resolution information
 1.0c:  Better handling of errors, if the TWAIN-Scanner doesn't deliver
        resolution information
 1.0d:  try to close TWAIN, if it's already open
 1.0e:  DebugBox temporary added
 1.0f:  Errorhandling improved (div by zero)
 1.0g:  DebugBox removed
 1.0h:  DebugBox added again
 1.0i:  Save Setting in IniFile,
        CheckBox added to switch off automatic zoom,
        CheckBox added to show/hide DebugBox

 2.0:   major enhancements:
        faster copy: the TWAIN dialog will stay open after a scan,
                     the print is started after pressing the Scan-button in the
                     TWAIN dialog
        save all settings in Ini-file
        two language version, more languages are possible
        automatic functions can switched off:
                     -'Auto scale' the automatic calculation of the size of the
                       copy depending on the resolution of the scanner and the printer
                     -'Fast copy' the print driver creates the multiple copies and
                       not CCopier

 2.1:   documentation bugfix, ( the about box shows V1.1 in the english version :-(

- to compile it, install the 'DebugBox' and 'DTrans' components before

Copyright Matthias Weingart 1996, Freeware, Comments and bugreports to
matthias@penthouse.boerde.de

}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, EzTwain, Printers, ExtCtrls, DebugBox, Spin,
  Menus, IniFiles, scinfo, Buttons, Dtrans;

const
  CM_PRINTBMP    = WM_USER+1211;

type
  TPositions = (poTopLeft,poBottomLeft,poTopRight,poBottomRight,poCenter);
  TCenterState=(tctNone, tctTopCenter, tctCenter, tctBottomCenter);

  PGlobalSettings = ^TGlobalSettings;
  TGlobalSettings = record
     Version: Integer;
     BitmapHandle: THandle;
     ZoomX, ZoomY: Single;
     CenterState: TCenterState;
     NoOfCopies:  Integer;
     AutoScale:   Boolean;
     PrinterCopies: Boolean;
     PrintDevice,PrintDriver,PrintPort: array[0..255] of char;
     PrintDeviceMode: THandle;
  end;

  TForm1 = class(TForm)
    PrinterSetupDialog1: TPrinterSetupDialog;
    Dbg1: TDebugBox;
    ZoomEdit: TSpinEdit;
    Label1: TLabel;
    MainMenu1: TMainMenu;
    Datei: TMenuItem;
    Druckereinstellen1: TMenuItem;
    Beenden1: TMenuItem;
    Label2: TLabel;
    NoOfCopiesEdit: TSpinEdit;
    Scannerauswahl1: TMenuItem;
    CopyButton: TButton;
    Label3: TLabel;
    Debugfenster1: TMenuItem;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Bevel1: TBevel;
    BtnPosLeftTop: TSpeedButton;
    BtnPosTop: TSpeedButton;
    BtnPosCenter: TSpeedButton;
    BtnPosBottom: TSpeedButton;
    AutoScaleCb: TCheckBox;
    ber1: TMenuItem;
    LanguageSwitcher1: TLanguageSwitcher;
    PrinterCopiesCb: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure Druckereinstellen1Click(Sender: TObject);
    procedure Beenden1Click(Sender: TObject);
    procedure Scannerauswahl1Click(Sender: TObject);
    procedure CopyButtonClick(Sender: TObject);
    procedure Debugfenster1Click(Sender: TObject);
    procedure Ueber1Click(Sender: TObject);
    procedure SpeedButtonClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private-Deklarationen }
    TwainIsOpen: Boolean;
    procedure InitDebug;
    procedure PrintFree(s: string);

    procedure UpDateInfo;
    procedure UpDateButtons;

    procedure SetPosition(A: TPositions);
    procedure PrintBitmap(b: HBitmap);
  protected
    function  GetPosBtn: TCenterState;
    procedure SetPosBtn( v: TCenterState);
    function  GetWndBtn: integer;
    procedure SetWndBtn( v: integer);
  public
    { Public-Deklarationen }
    Ini: TIniFile;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
    TwainIsOpen:=False;
    Ini := TIniFile.Create( ChangeFileExt(Application.ExeName,'.ini' ));

    ZoomEdit.Value:=Ini.ReadInteger( 'Params', 'Zoom', 100 );
    NoOfCopiesEdit.Value:=Ini.ReadInteger( 'Params', 'NoOfCopies', 1 );
    AutoScaleCb.Checked:=Ini.ReadBool( 'Params', 'AutoScale', True );
    PrinterCopiesCb.Checked:=Ini.ReadBool( 'Params', 'PrinterCopies', True );
    SetWndBtn( Ini.ReadInteger( 'Params', 'WindowPosition', 2 ) );
    SetPosBtn( TCenterState(Ini.ReadInteger( 'Params', 'CopyCenterState',0 )));

    Dbg1.Add('Start');
    UpDateInfo;
    UpDateButtons;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     Ini.WriteInteger( 'Params', 'Zoom', ZoomEdit.Value );
     Ini.WriteInteger( 'Params', 'NoOfCopies', NoOfCopiesEdit.Value );
     Ini.WriteBool(    'Params', 'AutoScale', AutoScaleCb.Checked );
     Ini.WriteBool(    'Params', 'PrinterCopies', PrinterCopiesCb.Checked );
     Ini.WriteInteger( 'Params', 'WindowPosition', GetWndBtn );
     Ini.WriteInteger( 'Params', 'CopyCenterState', ord(GetPosBtn)  );

     If TwainIsOpen then TWAIN_Close;
     CanClose:=True;
end;

procedure TForm1.InitDebug;
begin
  Dbg1.Add( '----------------------' );
end;

procedure TForm1.PrintFree(s: string);
begin
    Dbg1.Add( s );
end;


procedure TForm1.Druckereinstellen1Click(Sender: TObject);
begin
     PrinterSetupDialog1.Execute;
     UpDateInfo;
end;

procedure TForm1.Beenden1Click(Sender: TObject);
begin
     Close;
end;

procedure TForm1.Scannerauswahl1Click(Sender: TObject);
begin
  TWAIN_SelectImageSource(Handle);
  Dbg1.Add( 'EzTwain Version: '+ FloatToStr(round(TWAIN_EasyVersion)/100));
  UpDateInfo;
end;

procedure TForm1.PrintBitmap(b: HBitmap);
var
    i,r, max: integer;
    s: string;
    c: array[0..256] of char;
    PSettings: PGlobalSettings;
    Settings: THandle;
begin
  if b<>0 then begin
          {save printerinformation global}
          Settings := GlobalAlloc( HeapAllocFlags or GMEM_ZEROINIT, sizeof(TGlobalSettings));
          if Settings<>0 then
          begin
           PSettings:=GlobalLock( Settings );
           if PSettings<>nil then
           begin
             with PSettings^ do
             begin
              BitmapHandle:=b;
              ZoomX:=ZoomEdit.Value/100;
              ZoomY:=ZoomEdit.Value/100;
              CenterState:=GetPosBtn;
              NoOfCopies:=NoOfCopiesEdit.Value;
              AutoScale:=AutoScaleCb.Checked;
              PrinterCopies:=PrinterCopiesCb.Checked;
              Printer.GetPrinter(PrintDevice,PrintDriver,PrintPort,PrintDeviceMode);
             end;
           end;
           GlobalUnlock( Settings );
           s:='scprn.exe'+' ';
           s:=s+IntToStr( Settings )+' ';

           Dbg1.Add('Start : '+s);
           r:=WinExec( StrPCopy(c, s), SW_HIDE );
           Dbg1.Add('WinExec: '+IntToStr(r) );
          end;
  end;
end;

procedure TForm1.CopyButtonClick(Sender: TObject);
var
    han: HBitmap;
begin
 TwainIsOpen:=True;
 CopyButton.Enabled:=False;
 InitDebug; PrintFree('Start');
 Screen.Cursor := crHourGlass;
 TWAIN_Open(Handle, TWAIN_ANYTYPE); PrintFree('TwainOpen');
 Screen.Cursor := crDefault;
 repeat
                        PrintFree('BeforeTwainAquire');
    han:=TWAIN_Acquire; PrintFree('TwainAquire');
    Screen.Cursor := crHourGlass;
    if han<>0 then
    begin
      PrintBitmap( han );
    end;
    Screen.Cursor := crDefault;
    if TWAIN_LastMessage<>0 then Dbg1.Add('TwainMsg: '+IntToStr(TWAIN_LastMessage));
 until (TWAIN_State<4) or (TWAIN_LastMessage=$102);
 TWAIN_Close;
 CopyButton.Enabled:=True;
end;

procedure TForm1.UpDateInfo;
begin
     Label3.Caption:=Printer.Printers.Strings[Printer.PrinterIndex];
end;

procedure TForm1.Debugfenster1Click(Sender: TObject);
begin
     Dbg1.Visible := NOT Dbg1.Visible;
end;

procedure TForm1.Ueber1Click(Sender: TObject);
begin
     InfoBox.Show;
end;


procedure TForm1.SetPosition(A: TPositions);
begin
  if not (csDesigning in ComponentState) then
    case A of
      poTopLeft     : SetBounds(0,0,Width,Height);
      poBottomLeft  : SetBounds(0,Screen.Height-Height,Width,Height);
      poTopRight    : SetBounds(Screen.Width-Width,0,Width,Height);
      poBottomRight :
                 SetBounds(Screen.Width-Width,Screen.Height-Height,Width,Height);
      poCenter:
                 SetBounds((Screen.Width-Width) div 2,(Screen.Height-Height) div 2,Width,Height);
    end;
end;


procedure TForm1.UpdateButtons;
begin
    if SpeedButton1.Down then SetPosition(poTopLeft)
     else if SpeedButton2.Down then SetPosition(poTopRight)
      else if SpeedButton3.Down then SetPosition(poBottomLeft)
       else if SpeedButton4.Down then SetPosition(poBottomRight)
        else SetPosition(poCenter);
end;

procedure TForm1.SpeedButtonClick(Sender: TObject);
begin
     UpdateButtons;
end;

function TForm1.GetWndBtn: integer;
begin
     Result:=0;
     if SpeedButton1.Down then Result:=1;
     if SpeedButton2.Down then Result:=2;
     if SpeedButton3.Down then Result:=3;
     if SpeedButton4.Down then Result:=4;
end;

procedure TForm1.SetWndBtn( v: integer);
begin
     SpeedButton1.Down:= v=1;
     SpeedButton2.Down:= v=2;
     SpeedButton3.Down:= v=3;
     SpeedButton4.Down:= v=4;
end;

function TForm1.GetPosBtn: TCenterState;
begin
  Result:=tctNone;
  if BtnPosLeftTop.Down then Result:=tctNone;
  if BtnPosTop.Down then Result:=tctTopCenter;
  if BtnPosCenter.Down then Result:=tctCenter;
  if BtnPosBottom.Down then Result:=tctBottomCenter;
end;

procedure TForm1.SetPosBtn( v: TCenterState);
begin
  BtnPosLeftTop.Down:= v=tctNone;
  BtnPosTop.Down:= v=tctTopCenter;
  BtnPosCenter.Down:= v=tctCenter;
  BtnPosBottom.Down:= v=tctBottomCenter;
end;


end.
