//// (c) gRayman 1996 ///////////////////////////////////////////////////////
// Project:        Screen Saver Quiz
// Author:         Gregor Rayman - Gregor.Rayman@anasoft.ana.sk
// Created:        21. 4. 1996
// Description:    Quite simple screen saver.
// Note:           This program is not freeware. You may freely use and
//                 distribute it, you may even freely use this source code.
//                 But all this only if you are not member of these Slovak
//                 political parties: HZDS, SNS and ZRS. There is nothing
//                 like registration, but I'd be glad to receive an e-mail,
//                 if you improve it.
// History:        21. 4. 1996 - first version
/////////////////////////////////////////////////////////////////////////////


#include <windows.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "quiz.h"

unsigned short random(unsigned short);

/////////////////////////////////////////////////////////////////////////////
// Quiz - constructor - reads in the file (max 0xFFF0 chars) and creates
// the descriptors

Quiz::Quiz(char const * iFileName)
{
    FILE *in;
    left = 0;
    sign = 0;
    lines = 0;
    repeating = 0;
    in = fopen(iFileName, "rt");
    if (!in)
    {
        hBuffer = NULL;
        return;
    }
    hBuffer = GlobalAlloc(GHND, 0xFFF0);
    if (!hBuffer)
        return;
    LPSTR buffer = (LPSTR) GlobalLock(hBuffer);
    if (!buffer)
    {
        GlobalFree(hBuffer);
        hBuffer = 0;
        return;
    }
    size_t characters = fread(buffer, 1, 0xFFEF, in);
    fclose(in);
    GlobalUnlock(hBuffer);
    hBuffer = GlobalReAlloc(hBuffer, characters + 1, GMEM_MODIFY);
    buffer = (LPSTR) GlobalLock(hBuffer);
    buffer[characters]='\0';
    WORD actualMax = 200;
    hDescBuffer = GlobalAlloc(GHND, actualMax * sizeof(Desc));
    if (!hDescBuffer)
    {
        GlobalUnlock(hBuffer);
        GlobalFree(hBuffer);
        hBuffer = 0;
        return;
    }
    Desc *descBuffer = (Desc *) GlobalLock(hDescBuffer);
    WORD i;
    BOOL mode = 2;
    WORD header = 0;
    for (i = 0; buffer[i]; i++)
    {
        if (buffer[i] == '=')
        {
            if (mode)
            {
                descBuffer[lines++].answer = i + 1;
                buffer[i] = 0;
                mode = 0;
                if (lines >= actualMax)
                {
                    actualMax += 100;
                    GlobalUnlock(hDescBuffer);
                    HANDLE hDescBuffer1 = GlobalReAlloc(hDescBuffer,
                                           actualMax * sizeof(Desc),
                                                     GMEM_ZEROINIT);
                    if (!hDescBuffer1)
                    {
                        GlobalUnlock(hBuffer);
                        GlobalFree(hBuffer);
                        hBuffer = 0;
                        GlobalFree(hDescBuffer);
                        hDescBuffer = 0;
                    }
                    descBuffer = (Desc *) GlobalLock(hDescBuffer = hDescBuffer1);
                }
            }
        }
        else if (buffer[i] == '\n')
        {
            if (!mode)
            {
                descBuffer[lines].question = i + 1;
                descBuffer[lines].answer = i;
                descBuffer[lines].header = header;
                buffer[i] = 0;
                mode = 2;
            }
        }
        else if (buffer[i] == '|' || buffer[i] == '\r')
            buffer[i] = '\n';
        else if (buffer[i] == '\t')
            buffer[i] = ' ';
        else if (mode == 2)
        {
            mode = 1;
            if (buffer[i] == '.')
            {
                header = i + 1;
                buffer[i] = 0;
                mode = 0;
            }
        }
    }

    GlobalUnlock(hBuffer);
    GlobalUnlock(hDescBuffer);
    hDescBuffer = GlobalReAlloc(hDescBuffer, lines * sizeof(Desc), GMEM_ZEROINIT);
    left = lines;
}

/////////////////////////////////////////////////////////////////////////////
// Quiz - destructor - frees allocated space

Quiz::~Quiz(void)
{
    if (hBuffer)
        GlobalFree(hBuffer);
    if (hDescBuffer)
        GlobalFree(hDescBuffer);
}

/////////////////////////////////////////////////////////////////////////////
// Quiz::getQuestion - picks a random question and returns it's text as
// strdup()ed string. Must be called before getAnswer of getHeader


LPSTR Quiz::getQuestion(void)
{
    if (!lines)
        return NULL;

    Desc *descBuffer = (Desc *) GlobalLock(hDescBuffer);
    WORD take = random(lines);
    if (lines > 1)
    {
        if (!left--)
        {
            sign = !sign;
            left = lines - 1;
            if (!++repeating)
                repeating = 0xFFFF;
        }

        while (descBuffer[take].was != sign)
            if (++take >= lines)
                take = 0;
    }
    else
    {
        left = 0;
        if (!++repeating)
            repeating = 0xFFFF;
        take = 0;
    }

    descBuffer[take].was = !sign;

    LPSTR buffer = (LPSTR) GlobalLock(hBuffer);

    LPSTR result = _fstrdup(buffer + descBuffer[take].question);
    
    GlobalUnlock(hBuffer);
    GlobalUnlock(hDescBuffer);
    taken = take;
    return result;
}

LPSTR Quiz::getAnswer(void)
{
    if (!lines)
        return NULL;

    Desc *descBuffer = (Desc *) GlobalLock(hDescBuffer);
    LPSTR buffer = (LPSTR) GlobalLock(hBuffer);

    LPSTR result = _fstrdup(buffer + descBuffer[taken].answer);

    GlobalUnlock(hBuffer);
    GlobalUnlock(hDescBuffer);
    return result;
}

LPSTR Quiz::getHeader(void)
{
    if (!lines)
        return NULL;

    Desc *descBuffer = (Desc *) GlobalLock(hDescBuffer);
    LPSTR buffer = (LPSTR) GlobalLock(hBuffer);

    LPSTR result;
    if (!descBuffer[taken].header)
        result = NULL;
    else
        result = _fstrdup(buffer + descBuffer[taken].header);

    GlobalUnlock(hBuffer);
    GlobalUnlock(hDescBuffer);
    return result;
}
