/* Sample C Drill Using Drill Designer For DOS/Windows */
/* Copyright 1993 The University Of Iowa               */

#include "dd.h" 	/* Drill Designer Header File */

char *path_Name = ""; /* not 'relocatable', but Recycle C Appl is */
global_ptr		dp=NULL;

#define total_Questions		80
#define initial_queue_Length	10


/*************  List of questions *******************/

struct quest_Rec
{	char *	question_Str;
	char		correct_Ans;
}	
	question_Data [total_Questions+1] = 
	{"",'\0',			/* dummy 0th question */
	
	
/****************************** Garbage, recycling *******************************/

"How many tons of garbage are produced annually by \n\
 American households?\n\
 \tA. 94 million tons \n\tB. 124 million tons\n\
 \tC. 154 million tons",									'C',

"How many pounds of garbage will Americans generate today?\n\
\tA. 8.4 million\n\tB. 84.4 million\n\tC. 844 million",		'C',

"What percentage of the trash produced by Americans is \n\
 recyclable?\n\
 \tA. 30%\n\tB. 50%\n\tC. 70%",								'B',

"The U.S. recycles what percentage of its trash?\n\
 \tA. less than 10%\n\tB. 35%\n\tC. 60%",					'A',

"European countries recycle what percentage of their trash?\n\
 \tA. less than 10%\n\tB. 35%\n\tC. 60%",					'C',		/* 5 */

"How long does it take for a citizen of an advanced,\n\
industrialized country to consume the energy and raw materials\n\
that have to last a citizen of a developing country an entire\n\
lifetime?\n\
\tA. 6 months\n\tB. 3 years\n\tC. 12 years",				'A',

"According to recent research, approximately how many newspapers\n\
will be printed in America today?\n\
\tA. 62,500,000\n\tB. 75,000,000\n\tC. 123,000,000",		'A',	

"In 1988 how much of the paper used by Americans was recycled?\n\
\tA. 15%\n\tB. 29%\n\tC. 38%",								'B',		

"According to recent research, about how many glass containers\n\
 will Americans use today?\n\
 \tA. 53 million\n\tB. 107 million\n\tC. 126 million",		'C',
 
"How much of the glass used by Americans in 1988 was recycled?\n\
 \tA. 27%\n\tB. 34%\n\tC. 42%",								'A',	/* 10 */	

"How much plastic is used by each American per year?\n\
\tA.  60 pounds\n\tB. 190 pounds\n\tC. 340 pounds",			'B',

"How many plastic soda bottles are discarded by Americans \n\
every HOUR?\n\
\tA. 250,000\n\tB. 2.5 million\n\tC. 5 million",			'B',
 
"How many pounds of plastic could be saved from landfills each year\n\
if 10% of Americans purchase products with less packaging just\n\
10% of the time?\n\
\tA. 110 million pounds\n\tB. 144 million pounds\n\
\tC. 163 million pounds",									'B',	

"How long does it take Americans to throw away enough aluminum \n\
to rebuild our entire commercial airfleet?\n\
\tA. 3 months\n\tB. 1 year\n\tC. 2 years",					'A',	

"How many million tons of aluminum have been recycled and \n\
therefore saved from the landfills since 1972?\n\
\tA. 1 million tons\n\tB. 5 million tons\n\
\tC. 10 million tons",							 			'B',	/* 15 */
 
"How many years have we had the technology to recycle the 30 billion\n\
steel and tin cans that are disposed of in landfills each year?\n\
\tA. 20 years\n\tB. 40 years\n\tC. 60 years",				'C',
 
"According to recent research, about how much advertising\n\
mail will be delivered to American homes TODAY?\n\
\tA. 1,100 tons\n\tB. 3,300 tons\n\tC. 5,500 tons",			'C',
 
"On the average, how much third class mail does each American\n\
receive each year?\n\
\tA. 179 pieces\n\tB. 248 pieces\n\tC. 354 pieces",			'B',

"By conservative estimates, how much mail will pass through \n\
American post offices today?\n\
\tA. At least 100 million pieces\n\tB. At least 200 million pieces\n\
\tC. At least 350 million pieces",							'C',	
 
"According to recent research, about how many catalogs will \n\
Americans receive in the mail today?\n\
\tA. 1 million\n\tB. 20 million\n\tC. 300 million",			'B',	/* 20 */



/***************** cars, driving, etc *********************************/
"How many gallons of gasoline will American cars consume today?\n\
\tA. 30 million\n\tB. 200 million\n\tC. 1 billion",			'B',

"In 1987, how much gas did the average car use compared to 1978?\n\
\tA. 43% less\n\tB. 14% less\n\tC. 21% more",				'A',
 
"How many cars are registered in the U.S.?\n\
\tA. 25 million\n\tB. 82 million\n\tC. 140 million",		'C',		
 
"In the U. S. how many miles is the average car driven per year?\n\
\tA. 2,000 miles\n\tB. 12,000 miles\n\tC. 22,000 miles", 	'B',

"How many miles do Americans drive every year total?\n\
\tA. 1 billion\n\tB. 100 billion\n\tC. more than 1 trillion",  'C',		/* 25 */

"According to recent research, how many miles will Americans\n\
drive today?\n\
\tA. 1 million\n\tB. 100 million\n\tC. 4 billion",			'C',	
 
"What percentage of all miles traveled by Americans is by car?\n\
\tA. 55%\n\tB. 68%\n\tC. 80%",								'C',	
 
"Americans own what percentage of the 400 million cars found \n\
worldwide?\n\
\tA. 22%\n\tB. 35%\n\tC. 51%",								'B',
 
"If all cars were this fuel efficient, the U.S. would not\n\
have to import any oil:\n\
\tA. 42 mpg\n\tB. 54 mpg\n\tC. 78 mpg",						'A',

"In 1990, the highest-rated commercially available car got how \n\
many mpg in the city?\n\
\tA. 37 mpg\n\tB. 42 mpg\n\tC. 53 mpg",						'C',		/* 30 
*/


 

/**************************** Auto-related stuff ********************************/
 
 
"How many gallons of oil did the supertanker EXXON VALDEZ\n\
spill when it ran aground in Alaska on 3/24/89?\n\
\tA. 1.6 million\n\tB. 10.8 million\n\tC. 50.3 million",	'B',
 
"About how many automobile tires will be manufactured in \n\
American factories today?\n\
\tA. 260,000\n\tB. 480,000\n\tC. 680,000",					'C',

"How much motor oil is used by Americans every year?\n\
\tA. 1 billion gallons\n\tB. 5 billion gallons\n\
\tC. 10 billion gallons",									'A',

"According to recent research, about how many auto batteries will \n\
Americans replace today?\n\
\tA. 150,000\n\tB. 500,000\n\tC. 1 million",				'A',		
 

/*********************** carbon dioxide, etc ****************************/

"How much carbon dioxide is released into the atmosphere\n\
for every gallon of gas burned by a car?\n\
\tA. 2 ounces\n\tB. 2 pounds\n\tC. 20 pounds",				'C',		/* 35 */

"How much more carbon dioxide is in the atmosphere now than a \n\
century ago from constant burning of fossil fuels?\n\
\tA. 10% more\n\tB. 18% more\n\tC. 25% more",				'C',

"How many pounds of carbon dioxide is consumed by a mature tree\n\
in a year?\n\
\tA. 6 pounds\n\tB. 13 pounds\n\tC. 21 pounds",				'B',
 
/***************************** refrigerators *********************************/
 
"If you live in a city your refrigerator can account for how much \n\
of the energy that you use?\n\
\tA. 7%\n\tB. 18%\n\tC. 25%",								'C',
 
"It is more energy efficient to keep your refrigerator or freezer:\n\
\tA. empty\n\tB. full\n\tC. upside-down",					'B',

"About how many new refrigerators will Americans buy today?\n\
\tA. 10,000\n\tB. 12,000\n\tC. 15,000",  					'B',	/* 40 */

/************************** Lighting ******************************************/
 
"When you are leaving a room for just a few minutes, you should\n\
 \tA. turn the light off to save energy\n\tB. leave the light on;\n\
 \tit uses more energy to turn it off and on again",		'A',
 
 "A LONG-LIFE incandescent bulb is more energy-efficient than a \n\
 standard bulb.\n\
 \tA. True\n\tB. False; it is less energy-efficient\n\
 \tC. They use about the same amount of energy.",			'B',	
 
"Lighting and air conditioning consume what percentage of the \n\
electricity used in a commercial building?\n\
\tA. 20%\n\tB. 40%\n\tC. 60%",								'C',

"Which will give you the most light in a multi-bulb fixture?\n\
\tA A. single 100-watt bulb\n\tB. Four 25-watt bulbs\n\
\tC. A candle",												'A',

/*********************** Household stuff *******************************/

"According to recent research, about how many tons of BOXES, BAGS,\n\
and WRAPPERS will Americans discard today?\n\
\tA. 150,000\n\tB. 500,000\n\tC. 1 million",				'A',		/* 45 */

"According to recent research, about how many disposable diapers\n\
will Americans throw out today?\n\
\tA. 490,000\n\tB. 4.9 million\n\tC. 49 million",			'C',	

"How many gallons of paint do Americans use every day?\n\
\tA. 3 million\n\tB. 7 million\n\tC. 11 million",			'A',
 
"Which type of paint is considered better for the environment?\n\
\tA. latex\n\tB. oil-based\n\tC. stain",					'A',

"The amount of energy that escapes through American windows and\n\
doors every winter is equivalent to what percentage of the oil\n\
that flows through the Alaska pipeline each year?\n\
\tA. 40%\n\tB. 75%\n\tC. 100%",								'C',

"In the average American house, all of the gaps around windows\n\
and doors could combine to form a hole in the wall of what area?\n\
\tA. 3 inches x 3 inches\n\tB. 3 feet x 3 feet\n\
\tC. 3 yards x 3 yards",									'B',		/* 50 
*/
 

"What is the proper length for grass when cutting?\n\
\tA. 1-2 inches\n\tB. 2-3 inches\n\tC. 3-4 inches",			'B',		




 
/********************** water conservations etc *****************************/
 
 
"How many gallons of water a week can you save by watering \n\
grass, plants and trees in the early morning?\n\
\tA. 12 gallons\n\tB. 25 gallons\n\tC. 50 gallons",			'C',	

"How much of the water used in our homes is consumed in the bathroom?\n\
\tA. 35%\n\tB. 55%\n\tC. 75%",								'C',
 
"How much of the water used in homes is used in taking showers?\n\
\tA. 30%\n\tB. 50%\n\tC. 70%",								'A',
 
"When taking a bath as opposed to a shower, how much water is used?\n\
\tA. 5 times the amount\n\tB. 3 times the amount\n\
\tC. about the same amount",								'B',
 
"Which method of washing dishes uses the least amount of water?\n\
\tA. Washing dishes by hand with the water running\n\
\tB. Washing dishes by hand using wash and rinse basins only\n\
\tC. Washing dishes in a dishwasher",						'B',	

"If a leak fills a coffee cup in 10 minutes how much water\n\
will it waste in a year?\n\
\tA. 365 gallons\n\tB. 1,000 gallons\n\
\tC. 3,000 gallons",										'C',

"According to recent research, approximately how many gallons\n\
of pure water will Americans flush down their toilets today?\n\
\tA. 1.5 billion\n\tB. 3.5 billion\n\tC. 6.5 billion",		'C',		



"How many of the houses in Cyprus have solar hot water systems?\n\
\tA. 35%\n\tB. 65%\n\tC. 90%",								'C',		
 
"How much of the Israelis' hot water is produced by solar energy?\n\
\tA. 35%\n\tB. 65%\n\tC. 90%",								'B',		/* 60 
*/
	
/******************* Toxic pollution, etc., ************************/ 
 
 
"What amount of toxic chemicals per acre of land are used by\n\
the average homeowner in comparison to farmers?\n\
\tA. homeowners use 10 times more chemicals\n\
\tB. they use about the same amount\n\
\tC. farmers use 10 times more chemicals",					'A',

"Most Americans have styrene in their fat tissue from using\n\
polystyrene plates and cups.\n\
\tA. True\n\tB. False",										'A',		
 
"Name a common preservative of non-organic fresh mushrooms:\n\
\tA. nitrates\n\tB. monosodium glutamate\n\tC. formaldahyde",  'C',
 
"According to the EPA, how much hazardous waste is produced every\n\
year, for every man, woman and child, in the U.S.?\n\
\tA. 12 pounds\n\tB. about 150 pounds\n\tC. over 1 ton",	'C',
 

 
"April 28 is the anniversary of the accident at Chernobyl which \n\
demonstrated the environmental threat of nuclear power plants.\n\
The radiation released into the atmosphere was:\n\
\tA. About equal to the amount released when the A-bomb was\n\
\t   dropped on Hiroshima\n\tB. Twice as great as Hiroshima\n\
\tC. About 90 times greater than Hiroshima",				'C',
 
"Many pesticides are banned in our country but are still produced here to be\n\
shipped to other countries.  What percentage of imported coffee beans tested\n\
had illegally high residues of these pesticides?\n\
\tA. 12%\n\tB. 33%\n\tC. 45%",								'C',		
 
"According to recent research, about how much hazardous waste will\n\
be produced in America today?\n\
\tA. 1.5 million pounds\n\tB. 1.5 billion pounds\n\
\tC. 1.5 trillion pounds",									'B',
 
"According to recent research, about how many dogs and cats will die\n\
from pesticide poisoning today?\n\
\tA. 10\n\tB. 50\n\tC. 80",									'C',		
 
"When a detergent label reads 8% phosphorous what is the actual\n\
percentage of phosphates in the product?\n\
\tA. 8%\n\tB. 16%\n\tC. 24%",								'C',

"How much toxic mercury does America produce every year?\n\
\tA. 300 gallons\n\tB. 5,000 gallons\n\tC. 100,000 gallons\n", 'C',	/* 70 */

 


 
/*************************** Conservation, wildlife *********************************/
 
"How many elephants are there today compared to 10 years ago,\n\
due to habitat loss and poaching?\n\
\tA. 10% fewer\n\tB. 25% fewer\n\tC. 50% fewer",			'C',

"About how many ivory ornamental items were Americans importing every\n\
day during the 1980's?\n\
\tA. 150 items\n\tB. 1,500 items\n\tC. 3,000 items",		'C',		
 
"How many paper grocery bags can be made from a 15-year-old tree?\n\
\tA. 700 bags\n\tB. 1,000 bags\n\tC. 1,300 bags",			'A',

"One tree is saved by recycling this amount of paper:\n\
\tA. 20 pounds\n\tB. 120 pounds\n\tC. 1,240 pounds",		'B',

"What percentage of the plants identified as being helpful in \n\
treating cancer are found only in rainforests?\n\
\tA. 26%\n\tB. 57%\n\tC. 70%",								'C',		

"According to recent research, about how much land will be paved over\n\
in America today?\n\
\tA. 200 acres\n\tB. 2,750 acres\n\tC. 1 million acres",	'B',
 
"The commercial fishing fleet loses about how many pounds of\n\
indestructible plastic fishing lines and nets every year?\n\
\tA. 300 million\n\tB. 500 million\n\tC. 1 billion",		'A',
 
"How much packaging material is DUMPED into the sea by\n\
commercial fishing fleets each year?\n\
\tA. 100,000  pounds\n\tB. 6 million pounds\n\
\tC. 52 million pounds\n",									'C',
 
"According to recent research, about how much American cropland \n\
 will be lost to soil erosion today?\n\
\tA. 150 acres\n\tB. 5,500 acres\n\tC. 11,000 acres",		'C', 

"According to DIET FOR A NEW AMERICA, how many people could be\n\
fed by the grain and soybeans eaten by U.S. livestock every year?\n\
\tA. 500 thousand\n\tB. 1 million\n\tC. 1 billion",			'C',


};
	
/******************* End of questions list *****************/

char	done = 0;
short	q_Num;
char	answer = '\0';
char *  dummy;
char    Name[256];
long	temp1, temp2;
char	hard_Items;

short	Char_OK (char test_Char)
{	char	OK_List[6] = {'A','B','C','Q','S'};
	short	test = -1, finito = 0;
	
	while (++test < 5 && !finito)
		if (test_Char == OK_List[test])
			finito = 1;
	
	return (finito);
}
	

main()
{	printf ("\t\t\tRecycling and Pollution Drill\n\n\n");
	printf  ("   Questions from Simple Things You Can Do to Save the Earth 1991 calendar\n");
	printf  ("          published by Andrews and McMeel, Universal Press Syndicate\n\n\n");
	printf ("Enter your name:");
	scanf ("%s", Name);
	while (getchar () != '\n');
	printf ("\n\nWelcome, %s.", Name);
	while (answer != 'Y' && answer != 'N')
	{	printf ("\nWould you like to restore a previous drill (Y,N) ?");
		answer = toupper (getchar ());
		while (answer!= '\n' && getchar()!= '\n');
	}
	printf ("\n\n");
	if (answer == 'Y')
	{	printf ("Restoring old drill...\n\n");
		dummy = Restore (&dp, path_Name, Name, "Recycle");
		if (strcmp (dummy, "Recflag"))
		{	printf ("Sorry, could not restore drill...creating new one.\n\n");
			answer = 'N';
		}
	}
	if (answer == 'N')
		CreateDrill(&dp,initial_queue_Length,1,total_Questions,'S',
				"EC","3 7 12",initial_queue_Length, "10000");
	 
	while (!done && (q_Num = Next (dp)))
	{	printf ("%u. %s\n\n", q_Num, question_Data[q_Num].question_Str);
		answer = '\0';
		while (!Char_OK(answer))
		{	printf ("Your answer (S=store, Q=quit without storing):");
			answer = toupper (getchar ());
			if (answer != '\n')
				while (getchar() != '\n');
		}
		printf ("\n");
		if (answer == 'Q')
			done = 1;
		else if (answer == 'S')
		{	printf ("Storing this drill...\n");
			Store (dp, path_Name, Name, "Recycle", "Recflag");
		}
		else if (answer == question_Data[q_Num].correct_Ans)
		{	Correct (dp);
			printf ("That is correct!!!!\n");
		}
		else
		{	printf ("Sorry, that is incorrect.  The correct answer is %c.\n",
					question_Data[q_Num].correct_Ans);	
			Incorrect (dp);
		}
		printf ("\n");
	
	}
	printf ("\n\n\n\n\n");
	printf ("\t\t\t\tYour cumulative results\n\n");
	temp1 = RetrieveInfo (dp, 19);
	temp2 = temp1 % 60;
	temp1 = temp1 / 60;
	printf ("\tTime spent in drill:%ld minutes %ld seconds\n\n", temp1, temp2);
	temp1 = RetrieveInfo (dp, 10);		/* Total questions answered */
	temp2 = RetrieveInfo (dp, 12);		/* Total correct */
	printf ("\tNumber of questions correct: %ld\n\n", temp2);
	printf ("\tNumber of questions missed: %ld\n\n", temp1 - temp2);
	printf ("\tPercent correct: %ld\n\n", RetrieveInfo (dp, 14));
	hard_Items = RetrieveInfo (dp, 21, 5, '%');
	if (hard_Items)
	{	printf ("\tHardest questions:\n");
		printf ("\t\t#  Question:\t\t%% of times missed\n");
		for (temp1 =1; temp1 <= hard_Items; temp1++)
		{	temp2 = RetrieveInfo (dp, 22, (short) temp1); /* must cast! "short" must be passed! */
			printf ("\t\t%ld. %2ld\t\t\t\t", temp1, temp2);
			printf ("%3ld\n", RetrieveInfo (dp, 9, (short) temp2)); /* ditto! */
		}
	}
	
	Dispose (&dp);
}
