/* (C) Copyright 1993, The University Of Iowa */
/* Drill Designer .h file, IBM C Version 1.0b */

#include <ctype.h>	/* Character class tests: isdigit, toupper, */
#include <stdarg.h>	/* Variable length argument lists. */		
		
#include <string.h>	/* String functions: strcat, strcpy, */
#include <stdlib.h>	/* rand, RAND_MAX */
#include <time.h>	/* Time utilities */
#include <stdio.h>	/* File storage & retrieval */
#include <limits.h>	/* Bounds of standard C types */

typedef struct i_node *item_ptr;

typedef struct i_node
		{	item_ptr 			prev;
			short				question_Num;
			short				times_Missed;
			short				times_Answered;
			item_ptr			next;		
		}										
		item_node;

#define value				question_Num
#define MAX_SIZE			SHRT_MAX-1
#define AT_END				SHRT_MAX	
#define NO_ERROR  			'\0'
#define MAX_ERROR_LENGTH 	256
#define MAX_AUTHOR_LENGTH	256
#define SET_TIME			1
#define DONT_SET			0
#define MEM_ERROR			"Ran out of memory\r\n"
#define INVALID_TARG_CHAR     "Invalid target list char, default set\r\n"
#define ITEM_TOO_LARGE		"Item larger than question pool size\r\n"
#define NO_INS_LIST			"No insert positions list; can't execute\r\n"

enum insert_Techniques
	{	DII = 0,
		RDII,
		RDIns,
		RDInt,
		RFII,
		EC
	};

typedef struct global_space		
		{	short	insert_technique_Code;
			char		orientation_Char;
			short	smallest_Position;
			short	fewest_Insertions;
			short	num_to_Retire;
			short	num_Retired;
			short	max_item_Num;
			item_ptr	incorrect_Head;
			item_ptr	incorrect_Tail;
			item_ptr	replenish_Head;
			item_ptr	replenish_Tail;
			item_ptr	future_queue_Head;
			item_ptr	future_queue_Tail;
			item_ptr	long_list_Head;
			item_ptr	long_list_Tail;
			item_ptr	retired_items_Head;
			item_ptr	retired_items_Tail;
			item_ptr	hard_list_Head;
			item_ptr	hard_list_Tail;
			item_ptr	resurrect_Ptr;
			time_t	start_Time;
			long		time_spent_Current;
			long		time_spent_Previous;
			short  	questions_answered_Current;
			short	questions_answered_Previous;
			short	questions_correct_Current;
			short	questions_correct_Previous;
			char  	error_Message [MAX_ERROR_LENGTH];
			char      author_Variables [MAX_AUTHOR_LENGTH];
		}										
			global_struct;
typedef struct global_space *global_ptr;

/* Prototypes for callable functions (in order of appearance) */
	void CreateDrill (global_ptr *ds_Handle, short num_of_Questions,
			  short num_of_Repeats, short question_pool_Size,
			  char orientation_Char, char *insert_Technique,
			  char *incorrect_Positions, ...);
	void Store (global_ptr ds, char *path_Name, char *student_ID,
			char *drill_ID, char *author_Variables);
	char* Restore (global_ptr *ds_Handle, char *path_Name, char *student_ID,
			char *drill_ID);
	short Next (global_ptr ds);	
	void Correct (global_ptr ds);
	void Incorrect (global_ptr ds);
	void Requeue (global_ptr ds, short item_Num, char *requeue_Positions, 
		      char target_list_Char);
	void Purge (global_ptr ds, char *item_or_Pos, char target_list_Char);
	void Retire (global_ptr ds, short item_Num);
	void Insert (global_ptr ds, short item_Num, char *insert_Positions, 
		     char target_list_Char);
	void Pad (global_ptr ds, char *pad_Str, char target_list_Char);
	long RetrieveInfo (global_ptr ds, short info_Request, ...);
	void Dispose (global_ptr *ds_Handle);
	char * GetErrorMessage (global_ptr ds);
