#ifndef MAGMA
#define MAGMA
#endif
//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1993 by Borland International
//   include\owl\editview.h
//   Defines classes TEditView
//----------------------------------------------------------------------------
#if !defined(__OWL_MAGMAEDITVIEW_H)
#define __OWL_MAGMAEDITVIEW_H

#if !defined(__OWL_DOCMANAG_H)
  #include <owl\docmanag.h>
#endif
#if !defined(__OWL_MAGMAEDITSEAR_H)
#if defined(MAGMA)
  #include <owl\medtsear.h>
#else
  #include <owl\editsear.h>
#endif
#endif

//
//  class TMagmaEditView
//  ----- ---------
//
class _OWLCLASS TMagmaEditView : public TMagmaEditSearch, public TView {
  public:
    TMagmaEditView(TDocument& doc, TWindow* parent = 0);
   ~TMagmaEditView();
#if defined(MAGMA)
    static const char far* StaticName() {return "Magma Edit View";}  // put in resource
#else
    static const char far* StaticName() {return "Edit View";}  // put in resource
#endif
    //
    // overridden virtuals from TView
    //
    const char far*   GetViewName(){return StaticName();}
    TWindow* GetWindow()  {return (TWindow*)this;}
    BOOL     SetDocTitle(const char far* docname, int index)
                          {return TMagmaEditSearch::SetDocTitle(docname, index); }
    //
    // overridden virtuals from TWindow
    //
    BOOL   Create();
    void   PerformCreate(int menuOrId);
    BOOL   CanClose()   {return TMagmaEditSearch::CanClose() && Doc->CanClose();}

  protected:
    long   Origin;
    BOOL   LoadData();
    //
    // message response functions
    //
    void   EvNCDestroy();
    BOOL   VnCommit(BOOL force);
    BOOL   VnRevert(BOOL clear);
    BOOL   VnIsWindow(HWND hWnd) {return HWindow == hWnd;}
    BOOL   VnIsDirty()  {return TMagmaEditSearch::IsModified();}
    BOOL   VnDocClosed(int omode);
        
  DECLARE_RESPONSE_TABLE(TMagmaEditView);
  DECLARE_STREAMABLE(_OWLCLASS, TMagmaEditView,1);
};

#endif  // __OWL_MAGMAEDITVIEW_H

