//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1993 by Borland International
//   include\owl\editview.cpp
//   Implements class TEditView
//----------------------------------------------------------------------------
#pragma hdrignore SECTION
#include <owl\owlpch.h>
#if defined(MAGMA)
#include <owl\medtview.h>
#else
#include <owl\editview.h>
#endif
#include <owl\docview.rh>
#include <owl\editview.rh>

DIAG_DECLARE_GROUP(OwlDocView);        // General Doc/View diagnostic group

#if !defined(SECTION) || SECTION == 1

#if defined(MAGMA)
#define MAX_EDIT_BUF (0x7FFFFFFFL)  // can't add new chars after 30,000 bytes
#else
#define MAX_EDIT_BUF (30000)  // can't add new chars after 30,000 bytes
#endif

//
//  class TMagmaEditView
//  ----- ---------
//
DEFINE_RESPONSE_TABLE1(TMagmaEditView, TMagmaEditSearch)
  EV_VN_DOCCLOSED,
  EV_VN_ISWINDOW,
  EV_VN_ISDIRTY,
  EV_VN_COMMIT,
  EV_VN_REVERT,
  EV_WM_NCDESTROY,
END_RESPONSE_TABLE;

TMagmaEditView::TMagmaEditView(TDocument& doc, TWindow* parent)
         : TMagmaEditSearch(parent, GetNextViewId()), TView(doc), Origin(0)
{
  Attr.AccelTable = IDA_EDITVIEW;
  SetViewMenu(new TMenuDescr(IDM_EDITVIEW,0,2,0,0,0,1));
}

void
TMagmaEditView::EvNCDestroy()
{
#if !defined(__WIN32__) && !defined(MAGMA)
  HGLOBAL hdl = (HGLOBAL)::GlobalHandle((UINT)GetWindowWord(GWW_HINSTANCE));
#endif
  TMagmaEditSearch::EvNCDestroy();// call TWindow::EvNCDestroy, this may be deleted
#if !defined(__WIN32__) && !defined(MAGMA)
  if (hdl) {
    ::GlobalUnlock(hdl);
    ::GlobalFree(hdl);
  }
#endif
}

TMagmaEditView::~TMagmaEditView()
{
}

BOOL
TMagmaEditView::VnDocClosed(int omode)
{
  if (VnIsDirty() || !(omode & ofWrite))  // make sure someone else's write
    return FALSE;

#if defined(MAGMA)
  LONG top = GetFirstVisibleLine();
#else
  int top = GetFirstVisibleLine();
#endif
  UINT selbeg;
  UINT selend;
  TMagmaEdit::GetSelection(selbeg, selend);
  TMagmaEdit::Clear();
  LoadData();
  Scroll(0, top);
  TMagmaEdit::SetSelection(selbeg, selend);

  return TRUE;
}

BOOL
TMagmaEditView::LoadData()
{
  istream* inStream;
  if ((inStream = Doc->InStream(ios::in | ios::binary)) == 0) {
    Doc->PostError(IDS_UNABLEOPEN, MB_OK);
    return FALSE;
  }

#if defined(MAGMAX)
  int status = HandleMessage(ME_OPENFILE, inStream->fd(), NULL);

#else
  inStream->seekg(0L, ios::end);
  unsigned long total = inStream->tellg();
  inStream->seekg(0L, ios::beg);
  UINT count = (total > MAX_EDIT_BUF) ? MAX_EDIT_BUF : (UINT)total;
  char far* buf = LockBuffer(count + 1);
  if (!buf) {
    delete inStream;
//    THROW( TXOutOfMemory() );
    Doc->PostError(IDS_NOMEMORYFORVIEW, MB_OK);
    return FALSE;
  }

  UINT len;
  inStream->read(buf, len = count);

  BOOL status = (inStream->gcount() == len);
  buf[count] = 0;    // 0 terminate buffer
  UnlockBuffer(buf, TRUE);
#endif

  delete inStream;   // close file in case process switch
  if (!status)
    Doc->PostError(IDS_READERROR, MB_OK);

  return status;
}

BOOL
TMagmaEditView::Create()
{
  TRY {
    TMagmaEditSearch::Create();   // throws exception TWindow::TXWindow
  }
  CATCH( (TXOwl& x) {
    Doc->PostError(IDS_NOMEMORYFORVIEW, MB_OK);
    NotOK();
    return TRUE;   // cannot return FALSE - throws another exception
  })
  if (Doc->GetDocPath() == 0) {  
    return TRUE;           // new file, no data to display
  }
  if (!LoadData())
    NotOK();
  return TRUE;
}

void
TMagmaEditView::PerformCreate(int menuOrId)
{
#if defined(__WIN32__) || defined(MAGMA)
  HINSTANCE hInst = *GetModule();
#else
  HGLOBAL hdl = ::GlobalAlloc(GHND, 256);  // will grow as needed
  if (!hdl) {
//  Doc->PostError(IDS_NOMEMORYFORVIEW, MB_OK);
//  return;
    THROW( TXOutOfMemory() );
  }
  WORD editDS = FP_SEG(::GlobalLock(hdl));
  ::LocalInit(editDS, 0, 0);
  ::GlobalUnlock(hdl);
  HINSTANCE hInst = (HINSTANCE)hdl;
#endif

// if (doc readonly || size too large) Attr.Style |= ES_READONLY;
  HWindow = CreateWindowEx(Attr.ExStyle,
                           GetClassName(),
                           Title,
                           Attr.Style,
                           Attr.X, Attr.Y, Attr.W, Attr.H,
                           Parent ? Parent->HWindow : 0,
                           (HMENU)menuOrId,
                           hInst,
                           Attr.Param);
}

BOOL
TMagmaEditView::VnCommit(BOOL force)
{
  if (!force && !(VnIsDirty()))
    return TRUE;

  ostream* outStream;
  if ((outStream = Doc->OutStream(ios::out | ios::binary)) == 0) {
    Doc->PostError(IDS_UNABLEOPEN, MB_OK);
    return FALSE;
  }

#if defined(MAGMAX)
  int status = HandleMessage(ME_WRITEFILE, outStream->fd, NULL);

#else
  outStream->seekp(Origin);

  BOOL status = FALSE;
  char far* buf = LockBuffer();
  if (buf) {
    UINT count = strlen(buf);
    outStream->write(buf, count);
    status = outStream->good();
    UnlockBuffer(buf);
    ClearModify();   // reset edit control
  }
#endif

  delete outStream;
  if (!status)
    Doc->PostError(IDS_WRITEERROR, MB_OK);

  return status;
}

BOOL
TMagmaEditView::VnRevert(BOOL clear)
{
  TMagmaEdit::Clear();
  ClearModify();   // reset edit control
  return clear ? TRUE : LoadData();
}

#endif
#if !defined(SECTION) || SECTION == 2

IMPLEMENT_STREAMABLE2(TMagmaEditView, TMagmaEditSearch, TView);

void*
TMagmaEditView::Streamer::Read(ipstream& is, uint32 /*version*/) const
{
  ReadBaseObject((TMagmaEditSearch*)GetObject(), is);
  ReadBaseObject((TView*)GetObject(), is);
  is >> GetObject()->Origin;
  return GetObject();
}

void
TMagmaEditView::Streamer::Write(opstream& os) const
{
  WriteBaseObject((TMagmaEditSearch*)GetObject(), os);
  WriteBaseObject((TView*)GetObject(), os);
  os << GetObject()->Origin;
}

#endif

