#ifndef MAGMA
#define MAGMA
#endif
//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1992, 1993 by Borland International
//   include\owl\editsear.h
//   Definition of class TEditSearch, an edit control that responds to
//   Find, Replace and FindNext menu commands.
//----------------------------------------------------------------------------
#if !defined(__OWL_MAGMAEDITSEAR_H)
#define __OWL_MAGMAEDITSEAR_H

#if !defined(__OWL_MAGMAEDIT_H)
#if defined(MAGMA)
  #include <owl\medt.h>
#else
  #include <owl\edit.h>
#endif
#endif
#if !defined(__OWL_FINDREPL_H)
  #include <owl\findrepl.h>
#endif
#include <owl\editsear.rh>


//
//  class TMagmaEditSearch
//  ----- -----------
//
class _OWLCLASS TMagmaEditSearch : public TMagmaEdit {
  public:
    TFindReplaceDialog::TData SearchData;
    TFindReplaceDialog*       SearchDialog;  // Find or replace dialog
    UINT                      SearchCmd;     // command set that opened dialog

    TMagmaEditSearch(TWindow*   parent = 0,
                int             id = 0,
                const char far* text = 0,
                int x = 0, int y = 0, int w = 0, int h = 0,
                TModule*        module = 0);

   ~TMagmaEditSearch();

    void          SetupWindow();
    void          DoSearch();

    //
    // menu command handlers
    //
    void          CmEditFind();               // CM_EDITFIND
    void          CmEditReplace();            // CM_EDITREPLACE
    void          CmEditFindNext();           // CM_EDITFINDNEXT

    LRESULT       EvFindMsg(WPARAM, LPARAM);  // Registered commdlg message

  private:
    //
    // hidden to prevent accidental copying or assignment
    //
    TMagmaEditSearch(const TMagmaEditSearch&);
    TMagmaEditSearch& operator=(const TMagmaEditSearch&);

  DECLARE_RESPONSE_TABLE(TMagmaEditSearch);
  DECLARE_STREAMABLE(_OWLCLASS, TMagmaEditSearch, 1);
};

#endif  // __OWL_MAGMAEDITSEAR_H
