#ifndef MAGMA
#define MAGMA
#endif
//----------------------------------------------------------------------------
// ObjectWindows - (C) Copyright 1992, 1993 by Borland International
//   include\owl\editfile.h
//   Definition of class TEditFile, a text edit which can find/replace
//   and read/write from/to a file.
//----------------------------------------------------------------------------
#if !defined(__OWL_MAGMAEDITFILE_H)
#define __OWL_MAGMAEDITFILE_H

#if !defined(__OWL_MAGMAEDITSEAR_H)
#if defined(MAGMA)
  #include <owl\medtsear.h>
#else
  #include <owl\editsear.h>
#endif
#endif
#if !defined(__OWL_OPENSAVE_H)
  #include <owl\opensave.h>
#endif
#include <owl\editfile.rh>

//
//  class TMagmaEditFile
//  ----- -----------
//
class _OWLCLASS TMagmaEditFile : public TMagmaEditSearch {
  public:
    TOpenSaveDialog::TData FileData;
    char far* FileName;

    TMagmaEditFile(TWindow*   parent = 0,
              int             id = 0,
              const char far* text = 0,
              int x = 0, int y = 0, int w = 0, int h = 0,
              const char far* fileName = 0,
              TModule*        module = 0);

   ~TMagmaEditFile();

    virtual BOOL  CanClear();
    virtual BOOL  CanClose();

    void          NewFile();
    void          Open();
    BOOL          Read(const char far* fileName=0);
    void          ReplaceWith(const char far* fileName);
    BOOL          Save();
    BOOL          SaveAs();
    void          SetFileName(const char far* fileName);
    BOOL          Write(const char far* fileName=0);

    //
    // command response functions
    //
    void          CmFileNew() {NewFile();}    // CM_FILENEW
    void          CmFileOpen() {Open();}      // CM_FILEOPEN
    void          CmFileSave() {Save();}      // CM_FILESAVE
    void          CmFileSaveAs() {SaveAs();}  // CM_FILESAVEAS

    //
    // command enabler functions
    //
    void          CmSaveEnable(TCommandEnabler& commandHandler);    

  protected:
    //
    // override virtual functions defined by TWindow
    //
    void          SetupWindow();

  private:
    //
    // hidden to prevent accidental copying or assignment
    //
    TMagmaEditFile(const TMagmaEditFile&);
    TMagmaEditFile& operator =(const TMagmaEditFile&);

  DECLARE_RESPONSE_TABLE(TMagmaEditFile);
  DECLARE_STREAMABLE(_OWLCLASS, TMagmaEditFile, 1);
};

#endif  // __OWL_MAGMAEDITFILE_H
