/*===========================================================================*/
/*                                                                           */
/* File    : MAGMAED.H                                                       */
/*                                                                           */
/* Purpose : Public header file for the Magma Editor                         */
/*                                                                           */
/* History :                                                                 */
/*                                                                           */
/* (C) Copyright 1993-1994 Marc Adler/Magma Systems     All Rights Reserved  */
/*===========================================================================*/

/*
  Typedefs for the macro interpreter
*/
typedef VOID FAR *HPROGRAM;


/*
  Window styles for the editor
*/

/*
  ES_WANTTAB
    This is used when an edit control is part of a dialog box. The editor
    examines this style when it processes the WM_GETDLGCODE message in
    order to let the Windows dialog manager know whether it want to keep
    the tabs.
*/
#define ES_WANTTAB        0x00008000L

/*
  ES_OWNERDRAW
    Used to allow the application to render a line of the edit control
*/
#define ES_OWNERDRAW      0x00004000L
#define ES_HASSTRINGS     0x00000200L
#define ODT_EDIT          99

typedef struct tagMEDRAWITEMSTRUCT
{
  UINT  CtlType;
  UINT  CtlID;
  UINT  itemID;
  UINT  itemAction;
  UINT  itemState;
  HWND  hwndItem;
  HDC   hDC;
  RECT  rcItem;
  DWORD itemData;
  LPSTR lpText;
} MEDRAWITEMSTRUCT, NEAR *PMEDRAWITEMSTRUCT, FAR *LPMEDRAWITEMSTRUCT;

typedef struct tagMEDELETEITEMSTRUCT
{
  UINT  CtlType;
  UINT  CtlID;
  UINT  itemID;
  HWND  hwndItem;
  DWORD itemData;
  LPSTR lpText;
} MEDELETEITEMSTRUCT, NEAR *PMEDELETEITEMSTRUCT, FAR *LPMEDELETEITEMSTRUCT;

typedef struct tagMEMEASUREITEMSTRUCT
{
  UINT  CtlType;
  UINT  CtlID;
  UINT  itemID;
  UINT  itemWidth;
  UINT  itemHeight;
  DWORD itemData;
  LPSTR lpText;
} MEMEASUREITEMSTRUCT, NEAR *PMEMEASUREITEMSTRUCT, FAR *LPMEMEASUREITEMSTRUCT;



/*
  ES_USEFORMATTING
*/
#define ES_USEFORMATTING  0x00002000L


/*
  Editor messages
*/
#define WM_BASE   (WM_USER + 1313)

#define ME_SELFINSERT      WM_BASE+0
#define ME_FSEARCH         WM_BASE+1
#define ME_BSEARCH         WM_BASE+2
#define ME_FREPLACE        WM_BASE+3
#define ME_BREPLACE        WM_BASE+4
#  define SEARCH_CASE_INSENSITIVE    0x0001
#  define SEARCH_NO_REGEXP           0x0002
#  define SEARCH_SELECTMATCH         0x0004
#  define SEARCH_WHOLE_WORD_ONLY     0x0008
#  define SEARCH_PROMPT_ON_REPLACE   0x0100
#  define SEARCH_BACKWARD            0x1000


#define ME_DELLINE         WM_BASE+5
#define ME_APPENDLINE      WM_BASE+6
#define ME_INSERTLINE      WM_BASE+7
#define ME_CUT             WM_BASE+8
#define ME_CUTAPPEND       WM_BASE+9
#define ME_RESETMARK       WM_BASE+10
#define ME_COPY            WM_BASE+11
#define ME_DUPLINE         WM_BASE+12
#define ME_PASTE           WM_BASE+13
#define ME_BACKSPACE       WM_BASE+14
#define ME_DELWORD         WM_BASE+15
#define ME_DELCHAR         WM_BASE+16
#define ME_DELEOL          WM_BASE+17
#define ME_TOGGLEINSERT    WM_BASE+18
# define INSERTMODE_TOGGLE  0
# define INSERTMODE_ON      1
# define INSERTMODE_OFF     2
#define ME_TAB             WM_BASE+19
#define ME_BACKTAB         WM_BASE+20
#define ME_UNDO            WM_BASE+21
#define ME_REDO            WM_BASE+22
#define ME_SEARCHAGAIN     WM_BASE+23
#define ME_REPLACEAGAIN    WM_BASE+24

#define ME_MOVEUP          WM_BASE+30
#define ME_MOVEDOWN        WM_BASE+31
#define ME_MOVELEFT        WM_BASE+32
#define ME_MOVERIGHT       WM_BASE+33
#define ME_MOVEBOL         WM_BASE+34
#define ME_MOVEEOL         WM_BASE+35
#define ME_MOVENEXTWORD    WM_BASE+36
#define ME_MOVEPREVWORD    WM_BASE+37
#define ME_MOVENEXTPARA    WM_BASE+38
#define ME_MOVEPREVPARA    WM_BASE+39
#define ME_MOVETOPOFWINDOW WM_BASE+40
#define ME_MOVEBOTOFWINDOW WM_BASE+41
#define ME_MOVENEXTPAGE    WM_BASE+42
#define ME_MOVEPREVPAGE    WM_BASE+43
#define ME_MOVETOPOFBUFFER WM_BASE+44
#define ME_MOVEBOTOFBUFFER WM_BASE+45
#define ME_MOVETOBOOKMARK  WM_BASE+46
#define ME_SETBOOKMARK     WM_BASE+47
#define ME_GOTOLINE        WM_BASE+48
#  define GOTOLINE_ABS   1
#  define GOTOLINE_LAST  2
#  define GOTOLINE_NEXT  3
#  define GOTOLINE_PREV  4
#define ME_REMOVEBOOKMARK  WM_BASE+49
#  define BOOKMARK_REMOVEALL  ((WPARAM) -1)

#define ME_MATCHBRACE      WM_BASE+50
#define ME_MARKLINE        WM_BASE+51
#define ME_MARKLINERANGE   WM_BASE+52
#define ME_INSERTCHAR      WM_BASE+53
#define ME_UNDOLINES       WM_BASE+54
#define ME_STREAMMARK      WM_BASE+55
#define ME_RECTMARK        WM_BASE+56
#define ME_CASELOWER       WM_BASE+57
#define ME_CASEUPPER       WM_BASE+58

#define ME_OPENFILE        WM_BASE+60
#define ME_WRITEFILE       WM_BASE+61
/*
  Return codes for EM_WRITEFILE
*/
#  define EN_ERRCREATING  (-1)
#  define EN_ERRWRITING   (-2)

/*
  Options and settings
*/
#define ME_SETBKCOLOR      WM_BASE+70
#define ME_SETTEXTCOLOR    WM_BASE+71
#define ME_SETOPTION       WM_BASE+72
#define ME_QUERYOPTION     WM_BASE+73
#define ME_OPTIONDLG       WM_BASE+74
#define ME_SETFONT         WM_BASE+75
#define ME_TOGGLEWORDWRAP  WM_BASE+76
# define WORDWRAP_OFF     0
# define WORDWRAP_ON      1
# define WORDWRAP_TOGGLE  2

#define ME_HELPONWORD      WM_BASE+80
#define ME_GETCURRWORD     WM_BASE+81

#define ME_KEYMACDEFINE    WM_BASE+90
#define ME_KEYMACPLAY      WM_BASE+91
#define ME_KEYMACPAUSE     WM_BASE+92
#define ME_PROGFROMKEYMAC  WM_BASE+93

/*
  Misc
*/
#define ME_QUERYSEARCHSTRING   WM_BASE+100
#define ME_QUERYSTATUS         WM_BASE+101
#define ME_INSERTSTRING        WM_BASE+102
# define ME_INSERT_MODE      0
# define ME_OVERSTRIKE_MODE  1
#define ME_GETITEMDATA         WM_BASE+103
#define ME_SETITEMDATA         WM_BASE+104
#define ME_GETITEMHEIGHT       WM_BASE+105
#define ME_SETITEMHEIGHT       WM_BASE+106
#define ME_QUERYNUMWORDS       WM_BASE+107
#define ME_TRIMTEXT            WM_BASE+108
 #define TRIM_LEADING_BLANKS   0x0001
 #define TRIM_TRAILING_BLANKS  0x0002
 #define TRIM_COMPRESS_BLANKS  0x0004
#define ME_CENTER              WM_BASE+109
#define ME_REFORMAT            WM_BASE+110
#define ME_REFORMATALL         WM_BASE+111

#define WM_BASE_LAST_MSG       WM_BASE+200


/*
  Notification messages
*/
#define MEN_UPDATE             WM_BASE+200

/*
  Test bed for messages
*/
#define WM_MSGTESTBASE         WM_BASE+900


/*
  The following messages are compatible with the Chicago RTF edit control
*/
#define  EM_CHARFROMPOS        (WM_USER + 1213)
#define  EM_EXGETSEL           (WM_USER + 1214)
#define  EM_EXLINEFROMCHAR     (WM_USER + 1215)
#define  EM_EXSETSEL           (WM_USER + 1216)
#define  EM_GETSELTEXT         (WM_USER + 1217)
#define  EM_GETTEXTRANGE       (WM_USER + 1218)
#define  EM_POSFROMCHAR        (WM_USER + 1219)
#define  EM_SELECTIONTYPE      (WM_USER + 1220)
#define  EM_SETBKGNDCOLOR      (WM_USER + 1221)
#define  EM_GETCHARFORMAT      (WM_USER + 1222)
#define  EM_SETCHARFORMAT      (WM_USER + 1223)
  #define SCF_SELECTION   0x0001
  #define SCF_WORD        0x0002


typedef struct tagCharRange
{
  DWORD dwStart;
  DWORD dwEnd;
} CHARRANGE, *PCHARRANGE, FAR *LPCHARRANGE;


#ifndef RC_INVOKED
typedef struct tagMeStatus
{
  BOOL bInsert;
  UINT column;
  LONG row;
  LONG currLineNum;
  LONG nTotalLines;
} MAGMAED_STATUS, FAR *LPMAGMAED_STATUS;
#endif


/*
  Structures related to formatting
*/
#if !defined(_DEFS_H)

typedef struct tagCharFormat
{
  DWORD    dwMask;
    #define CFM_BOLD        0x00000001L
    #define CFM_ITALIC      0x00000002L
    #define CFM_UNDERLINE   0x00000004L
    #define CFM_STRIKEOUT   0x00000008L
    #define CFM_PROTECTED   0x00000000L
    #define CFM_SIZE        0x80000000L
    #define CFM_COLOR       0x40000000L
    #define CFM_FACE        0x20000000L
    #define CFM_OFFSET      0x10000000L
    #define CFM_BITMAP      0x08000000L   /* Magma specific */
  DWORD    dwEffects;
    #define CFE_BOLD        0x00000001L
    #define CFE_ITALIC      0x00000002L
    #define CFE_UNDERLINE   0x00000004L
    #define CFE_STRIKEOUT   0x00000008L
    #define CFE_PROTECTED   0x00000010L
    #define CFE_AUTOCOLOR   0x40000000L
    #define CFE_BITMAP      0x08000000L   /* Magma specific */
  LONG     yHeight;                 /* height of line in twips (1/1440")    */
  LONG     yOffset;                 /* >0 for superscript, <0 for subscript */
  COLORREF crTextColor;             /* Text color */
  BYTE     bPitchAndFamily;         /* same as LOGFONT's chPitchAndFamily */
  BYTE     szFaceName[LF_FACESIZE]; /* same as LOGFONT's lfFacename       */

  /* These are in the Magma Editor DLL but not in Chicago */
  HANDLE   hObject;                 /* generic object - Bitmap, font, MF  */
} CHARFORMAT, *PCHARFORMAT, FAR *LPCHARFORMAT;

#endif
