#include "stdafx.h"
#include "magmaed.hpp"
#include "multipad.h"
#include "mainfrm.h"

#define USE_MAGMA

IMPLEMENT_DYNCREATE(CPadDoc, CDocument)
BEGIN_MESSAGE_MAP(CPadDoc, CDocument)
	//{{AFX_MSG_MAP(CPadDoc)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_OVR, OnUpdateIndicatorOvr)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_COL, OnUpdateIndicatorCol)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_CURRLINE, OnUpdateIndicatorCurrLine)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_NUMLINES, OnUpdateIndicatorNumLines)
        ON_COMMAND(ID_OPT_FONT, OnChooseFont)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CPadDoc::Serialize(CArchive& ar)
{
#ifdef USE_MAGMA
  ((CMagmaEditView*)m_viewList.GetHead())->SerializeRaw(ar);
#else
  ((CEditView*)m_viewList.GetHead())->SerializeRaw(ar);
#endif
}


MAGMAED_STATUS &CPadDoc::GetStatus()
{
  POSITION pos = GetFirstViewPosition();
  MAGMAED_STATUS &meStatus =
                 ((CMagmaEditView *) GetNextView(pos))->GetStatus();
  return meStatus;
}

void CPadDoc::OnUpdateIndicatorOvr(CCmdUI* pCmdUI)
{
  // TODO: Add your command update UI handler code here
  pCmdUI->Enable();

  MAGMAED_STATUS &meStatus = GetStatus();
  if (meStatus.bInsert);
    pCmdUI->SetText(meStatus.bInsert ? "INS" : "OVR");
}


void CPadDoc::OnUpdateIndicatorCol(CCmdUI* pCmdUI)
{
  // TODO: Add your command update UI handler code here
  pCmdUI->Enable();
  if (!(GetKeyState(VK_LBUTTON) & 0x8000))
  {
    MAGMAED_STATUS &meStatus = GetStatus();
    char szBuf[32];
    wsprintf(szBuf, "%3d", meStatus.column+1);
    pCmdUI->SetText(szBuf);
  }
}

void CPadDoc::OnUpdateIndicatorCurrLine(CCmdUI* pCmdUI)
{
  // TODO: Add your command update UI handler code here
  pCmdUI->Enable();
  if (!(GetKeyState(VK_LBUTTON) & 0x8000))
  {
    MAGMAED_STATUS &meStatus = GetStatus();
    char szBuf[32];
    wsprintf(szBuf, "%5d", meStatus.currLineNum);
    pCmdUI->SetText(szBuf);
  }
}

void CPadDoc::OnUpdateIndicatorNumLines(CCmdUI* pCmdUI)
{
  // TODO: Add your command update UI handler code here
  pCmdUI->Enable();
  if (!(GetKeyState(VK_LBUTTON) & 0x8000))
  {
    MAGMAED_STATUS &meStatus = GetStatus();
    char szBuf[32];
    wsprintf(szBuf, "%5d", meStatus.nTotalLines);
    pCmdUI->SetText(szBuf);
  }
}

void CPadDoc::OnChooseFont()    // placed in CPadDoc only for quick testing,
                                // to avoid creating a new view class
{
#ifdef USE_MAGMA
  CMagmaEditView* pView = (CMagmaEditView*)m_viewList.GetHead();
#else
  CEditView* pView = (CEditView*)m_viewList.GetHead();
#endif

  // get current font description
  CFont* pFont = pView->GetFont();
  LOGFONT lf;
  if (pFont != NULL)
    pFont->GetObject(sizeof(LOGFONT), &lf);
  else
    ::GetObject(GetStockObject(SYSTEM_FONT), sizeof(LOGFONT), &lf);

  CFontDialog dlg(&lf, CF_SCREENFONTS|CF_INITTOLOGFONTSTRUCT);
  if (dlg.DoModal() == IDOK)
  {
    // switch to new font.
    pFont->DeleteObject();
    if (pFont->CreateFontIndirect(&lf))
    {
      pView->SetFont(pFont);
    }
  }
}

/////////////////////////////////////////////////////////////////////////////

