#ifndef DLGPAL_H
#define DLGPAL_H
#include <windows.h>
/*-----------------------------------------------------------------

    DLGPAL.H


    Declarations for Dialog Palette Control

    (c) 1993 Simon Whiteside


-----------------------------------------------------------------*/

#define DLGPAL_CLASS "DLGPAL"
#define DLGPAL_DLL "DLGPAL.DLL"

/*-----------------------------------------------------------------

    Control Structures

-----------------------------------------------------------------*/

typedef struct _CLASSINFO{
    LPCSTR   lpszTitle;
    LPCSTR   lpszClassName;
    LPCSTR   lpszWindowName;
    HBITMAP hBitmap;
    DWORD   dwStyle;
    int     nWidth,
            nHeight;
    DWORD   dwUser;
}CLASSINFO;
typedef CLASSINFO FAR * LPCLASSINFO;
/*-----------------------------------------------------------------

    Messages for the control

-----------------------------------------------------------------*/

#define DP_ADDCLASS         WM_USER+200
#define DP_GETCLASSINFO     WM_USER+201
#define DP_SETCLASSINFO     WM_USER+202
#define DP_FINDCLASSINDEX   WM_USER+203
#define DP_REMOVECLASS      WM_USER+204
#define DP_GETCOUNT         WM_USER+205
#define DP_GETITEMSIZE      WM_USER+206

/*-----------------------------------------------------------------

    Message Macros for the control

-----------------------------------------------------------------*/

#define DpAddClass(hctl,pinfo)\
    SendMessage(hctl,DP_ADDCLASS,0,(LPARAM)(LPCLASSINFO)pinfo)

#define DpGetClassInfo(hctl,index,pinfo)\
    SendMessage(hctl,DP_GETCLASSINFO,index,(LPARAM)(LPCLASSINFO)pinfo)

#define DpSetClassInfo(hctl,index,pinfo)\
    SendMessage(hctl,DP_SETCLASSINFO,index,(LPARAM)(LPCLASSINFO)pinfo)

#define DpFindClassIndex(hctl,lpszClassName)\
    SendMessage(hctl,DP_FINDCLASSINDEX,(LPARAM)(LPCSTR)lpszTitle)

#define DpRemoveClass(hctl,index)\
    SendMessage(hctl,DP_REMOVECLASS,index,0)

#define DpGetCount(hctl)\
    SendMessage(hctl,DP_GETCOUNT,0,0)

#define DpGetItemSize(hctl)\
    SendMessage(hctl,DP_GETITEMSIZE,0,0)

/*  Used to load the DLL */

#ifdef __cplusplus
extern "C"{
#endif

void _export CALLBACK DpLoad(void);

#ifdef __cplusplus
}
#endif


/*-----------------------------------------------------------------

    WM_COMMAND Notification Codes

-----------------------------------------------------------------*/

#endif
