#ifndef DLGEDIT_H
#define DLGEDIT_H
#include <windows.h>
/*-----------------------------------------------------------------

    DLGEDIT.H


    Declarations for Dialog Editor Control

    (c) 1993 Simon Whiteside


-----------------------------------------------------------------*/

#define DLGEDIT_CLASS "DLGEDIT"
#define DLGEDIT_DLL "DLGEDIT.DLL"

/*-----------------------------------------------------------------

    Control Structures

-----------------------------------------------------------------*/

typedef struct _CONTROLINFO
{
    LPCSTR lpszClassName;   /* address of registered class name */
    LPCSTR lpszWindowName;  /* address of window text */
    DWORD dwStyle;          /* window style */
    int x;                  /* horizontal position of window */
    int y;                  /* vertical position of window */
    int nWidth;             /* window width */
    int nHeight;            /* window height */
    HWND hwndParent;        /* handle of parent window */
    int id;                 /* child-window identifier */
    HWND hwnd;              /* window handle of control */
    BOOL bSelected;         /* selection flag */
    DWORD dwUser;           /* user data for control */
}CONTROLINFO;
typedef CONTROLINFO FAR * LPCONTROLINFO;
/*-----------------------------------------------------------------

    Messages for the control

-----------------------------------------------------------------*/
#define DE_BYHWND                   0
#define DE_BYPOSITION               1

#define DE_ADDCONTROL               WM_USER+100
#define DE_SETCONTROLINFO           WM_USER+101
#define DE_GETCONTROLINFO           WM_USER+102
#define DE_FINDCONTROL              WM_USER+103
#define DE_DELETECONTROL            WM_USER+104
#define DE_GETSELCOUNT              WM_USER+105
#define DE_GETCOUNT                 WM_USER+106
#define DE_GETFOCUSINDEX            WM_USER+107
#define DE_ALIGNCONTROLS            WM_USER+108
#define DE_SIZECONTROLS             WM_USER+109
#define DE_SETTEST                  WM_USER+110
#define DE_GETSEL                   WM_USER+111
#define DE_SETGRID                  WM_USER+112
#define DE_GETGRID                  WM_USER+113
#define DE_ISGRIDON                 WM_USER+114
#define DE_SETSNAPON                WM_USER+115
#define DE_ISSNAPON                 WM_USER+116
/*-----------------------------------------------------------------

    Message Macros for the control

-----------------------------------------------------------------*/

#define DeAddControl(hctl,pinfo)\
    SendMessage(hctl,DE_ADDCONTROL,0,(LPARAM)(LPCONTROLINFO)pinfo)

#define DeSetControlInfo(hctl,index,pinfo)\
    SendMessage(hctl,DE_SETCONTROLINFO,index,(LPARAM)(LPCONTROLINFO)pinfo)

#define DeGetControlInfo(hctl,index,pinfo)\
    SendMessage(hctl,DE_GETCONTROLINFO,index,(LPARAM)(LPCONTROLINFO)pinfo)

#define DeFindControl(hctl,flag,lparam)\
    SendMessage(hctl,DE_FINDCONTROL,flag,lparam)

#define DeDeleteControl(hctl,index)\
    SendMessage(hctl,DE_DELETECONTROL,index,0)

#define DeGetSelCount(hctl)\
    SendMessage(hctl,DE_GETSELCOUNT,0,0)

#define DeGetCount(hctl)\
    SendMessage(hctl,DE_GETCOUNT,0,0)

#define DeGetFocusIndex(hctl)\
    SendMessage(hctl,DE_GETFOCUSINDEX,0,0)

#define DeAlignControls(hctl,flag)\
    SendMessage(hctl,DE_ALIGNCONTROLS,flag,0)

#define DeSizeControls(hctl,flag)\
    SendMessage(hctl,DE_SIZECONTROLS,flag,0)

#define DeSetTest(hctl,flag)\
    SendMessage(hctl,DE_SETTEST,flag,0)

#define DeGetSel(hctl)\
    SendMessage(hctl,DE_GETSEL,0,0)

#define DeSetGrid(hctl,flag,x,y)\
    SendMessage(hctl,DE_SETGRID,flag,MAKELONG(x,y))

#define DeGetGrid(hctl)\
    SendMessage(hctl,DE_GETGRID,0,0)

#define DeIsGridOn(hctl)\
    SendMessage(hctl,DE_ISGRIDON,0,0)

#define DeSetSnapOn(hctl,flag)\
    SendMessage(hctl,DE_SETSNAPON,flag,0)

#define DeIsSnapOn(hctl)\
    SendMessage(hctl,DE_ISSNAPON,0,0)

/*  Used to load the DLL */

#ifdef __cplusplus
extern "C"{
#endif
void _export CALLBACK DeLoad(void);
#ifdef __cplusplus
}
#endif


/*-----------------------------------------------------------------

    WM_COMMAND Notification Codes

-----------------------------------------------------------------*/

#define DN_DOUBLECLICKED    1
#define DN_SELCHANGE        2
#define DN_CTLCHANGED       3
#define DN_RBUTTONDOWN      4
#endif
