/*-------------------------------------------------------------------------


	DLGED.C

	(c)	1993 Simon Whiteside

	Sample dialog editor using DLGEDIT and DLGPAL controls

---------------------------------------------------------------------------*/
#include "dlgpal.h"
#include "dlgedit.h"
#include <commdlg.h>
#include <windowsx.h>
#include <stdio.h>
#include <string.h>
#include <alloc.h>
#include "dlged.h"

// Functions in DLGEDS.C

void Style(HWND hwnd,int index);
void SaveDialog(HWND hwnd);

/*-------------------------------------------------------------------------

	Global Variables

---------------------------------------------------------------------------*/

#define HASFLAG(s,f)	(((s)&(f))==(f))

FARPROC tGridProc;
HANDLE  hInstance;
HWND 	hedit,		//	DLGEDIT control
		hpal;		//	DLGPAL control

typedef struct _PALETTEITEM{	//	An item on the palette control
	char * 	szTitle,
		 *	szClassName;
	DWORD 	dwStyle;
	char * 	szBitmap;
	int		nWidth,
			nHeight;
}PALETTEITEM;
PALETTEITEM pitems[]=
{
{"Check Box","BUTTON",BS_AUTOCHECKBOX|WS_TABSTOP,"CheckBox",100,50},
{"Radio Button","BUTTON",BS_AUTORADIOBUTTON|WS_TABSTOP,"RadioButton",100,50},
{"Push Button","BUTTON",BS_PUSHBUTTON|WS_TABSTOP,"PushButton",100,50},
{"Edit","EDIT",ES_LEFT|WS_BORDER|WS_TABSTOP,"Edit",100,50},
{"Text","STATIC",SS_LEFT|WS_GROUP|SS_SIMPLE,"Text",100,50},
{"Combo","COMBOBOX",CBS_DROPDOWN|WS_TABSTOP,"ComboBox",100,150},
{"List Box","LISTBOX",LBS_STANDARD|WS_TABSTOP,"ListBox",100,150},
{"Horiz Scroll Bar","SCROLLBAR",SBS_HORZ|WS_TABSTOP,"HScroll",100,16},
{"Horiz Scroll Bar","SCROLLBAR",SBS_VERT|WS_TABSTOP,"VScroll",16,100},
{"Group Box","BUTTON",BS_GROUPBOX|WS_GROUP|WS_CLIPSIBLINGS,"Group",100,100}
};
/*-------------------------------------------------------------------------

	Grid Dialog Methods

---------------------------------------------------------------------------*/
//--------------------------------------------------------------------------
BOOL Grid_OnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
//--------------------------------------------------------------------------
//	Show a dialog prompting the user for the grid settings
{
	DWORD d=DeGetGrid(hedit);
	SetDlgItemInt(hwnd,IDE_XINC,LOWORD(d),FALSE);
	SetDlgItemInt(hwnd,IDE_YINC,HIWORD(d),FALSE);
	if (DeIsGridOn(hedit))
		CheckDlgButton(hwnd,IDC_GRIDON,TRUE);
	if (DeIsSnapOn(hedit))
		CheckDlgButton(hwnd,IDC_SNAPON,TRUE);
	return TRUE;
}
//--------------------------------------------------------------------------
void Grid_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
//--------------------------------------------------------------------------
//	Respond to Grid Dialog buttons
{
	switch(id){
		case IDB_OK:
		{
			int x=0,y=0;
			BOOL b;
			x=GetDlgItemInt(hwnd,IDE_XINC,&b,FALSE);
			y=GetDlgItemInt(hwnd,IDE_YINC,&b,FALSE);
			DeSetGrid(hedit,IsDlgButtonChecked(hwnd,IDC_GRIDON),x,y);
			DeSetSnapOn(hedit,IsDlgButtonChecked(hwnd,IDC_SNAPON));
			EndDialog(hwnd,1);
			break;
		}
		case IDB_CANCEL:
			EndDialog(hwnd,0);break;
	}
}
//--------------------------------------------------------------------------
BOOL CALLBACK GridProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
//--------------------------------------------------------------------------
//	Window Procedure for the Grid Settings Dialog
{
	switch (msg){
		HANDLE_MSG(hwnd, WM_INITDIALOG, Grid_OnInitDialog);
		HANDLE_MSG(hwnd, WM_COMMAND, Grid_OnCommand);
	}
	return FALSE;
}
/*-------------------------------------------------------------------------

Window Functions

---------------------------------------------------------------------------*/
//--------------------------------------------------------------------------
void AddPaletteItem(PALETTEITEM * p)
//--------------------------------------------------------------------------
//	Adds a single item onto the palette
{
	CLASSINFO c;
	memset(&c,0,sizeof(CLASSINFO));
	c.lpszTitle=p->szTitle;
	c.lpszClassName=p->szClassName;
	c.dwStyle=p->dwStyle|WS_CHILD|WS_VISIBLE;
	c.hBitmap=LoadBitmap(hInstance,p->szBitmap);
	c.nWidth=p->nWidth;
	c.nHeight=p->nHeight;
	DpAddClass(hpal,&c);
}
//--------------------------------------------------------------------------
void FillPalette(void)
//--------------------------------------------------------------------------
//	Loops through the array of palette items adding them to the palette
{
	int x=0;
	int numitems=sizeof(pitems)/sizeof(PALETTEITEM);
	for (x=0;x<numitems;x++)
		AddPaletteItem(&(pitems[x]));
}
/*-------------------------------------------------------------------------

	Window Methods

---------------------------------------------------------------------------*/
//--------------------------------------------------------------------------
BOOL OnCreate(HWND hwnd, CREATESTRUCT FAR* lpCreateStruct)
//--------------------------------------------------------------------------
//	Creates the dialog editor and palette controls
{
	hedit=CreateWindow(DLGEDIT_CLASS,0,WS_CHILD|WS_VISIBLE,0,0,0,0,
						hwnd,ID_DLGEDIT,hInstance,0);
	hpal=CreateWindow(DLGPAL_CLASS,0,
						WS_POPUP|WS_VISIBLE|WS_BORDER,
						0,0,2*GetSystemMetrics(SM_CXICON)+2*GetSystemMetrics(SM_CXBORDER),
						5*GetSystemMetrics(SM_CYICON)
						+GetSystemMetrics(SM_CYCAPTION)/2
						+2*GetSystemMetrics(SM_CYBORDER),
						hwnd,0,hInstance,0);
	FillPalette();
	return TRUE;
}
//--------------------------------------------------------------------------
void OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
//--------------------------------------------------------------------------
//	Responds to menu events and control notifications
{
	switch (id){
		case IDM_EXIT:
		//	Quit the application
		{
			DestroyWindow(hwnd);
			break;
		}
		case IDM_TEST:
		//	Toggle the dialog editor test mode
		{
			HMENU hmenu=GetMenu(hwnd);
			if (GetMenuState(hmenu,IDM_TEST,MF_BYCOMMAND) & MF_CHECKED){
				CheckMenuItem(hmenu,IDM_TEST,MF_BYCOMMAND|MF_UNCHECKED);
				DeSetTest(hedit,FALSE);
				EnableWindow(hpal,TRUE);
			}else{
				CheckMenuItem(hmenu,IDM_TEST,MF_BYCOMMAND|MF_CHECKED);
				DeSetTest(hedit,TRUE);
				EnableWindow(hpal,FALSE);
			}
			break;
		}
		case IDM_DELETE:
		//	Delete the selected control
		{
			int index=DeGetSel(hedit);
			if (index>=0)
				DeDeleteControl(hedit,index);
			break;
		}
		case ID_DLGEDIT:
		//	Double-click notifications from the dialog editor
		//	Drop through to the style menu item
			if (codeNotify!=DN_DOUBLECLICKED){
				break;
			}

		case IDM_STYLE:
		//	Show a style dialog for selected control
		{
			int index=DeGetSel(hedit);
			if (index>=0){
				Style(hwnd,index);
			}
			break;
		}
		case IDM_SAVE:
		//	Save the current controls to a resource file
			SaveDialog(hwnd);
			break;

		case IDM_GRID:
		//	Show the Grid Settings dialog
			DialogBox(hInstance,"GRID",hwnd,tGridProc);
	}
}
//--------------------------------------------------------------------------
void OnSize(HWND hwnd, UINT state, int cx, int cy)
//--------------------------------------------------------------------------
//	Grow the dialog editor to fill the window
{
	MoveWindow(hedit,0,0,cx,cy,TRUE);
}
//--------------------------------------------------------------------------
void OnDestroy(HWND hwnd)
//--------------------------------------------------------------------------
//	Terminate the application
{
	PostQuitMessage(0);
}
//--------------------------------------------------------------------------
void OnSetFocus(HWND hwnd, HWND hwndOldFocus)
//--------------------------------------------------------------------------
//	Make sure focus goes to the dialog editor control
{
	SetFocus(hedit);
}
//--------------------------------------------------------------------------
void OnMenuSelect(HWND hwnd, HMENU hmenu, int item, HMENU hmenuPopup, UINT flags)
//--------------------------------------------------------------------------
//	If the user drops a menu, check whether a control is selected before
//	highlighting the Delete and Style options
{
	if ((int)flags!=-1){
		int numsel=DeGetSelCount(hedit);
		if (!numsel){
			EnableMenuItem(hmenu,IDM_DELETE,MF_BYCOMMAND|MF_DISABLED|MF_GRAYED);
			EnableMenuItem(hmenu,IDM_STYLE,MF_BYCOMMAND|MF_DISABLED|MF_GRAYED);
		}else{
			EnableMenuItem(hmenu,IDM_DELETE,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hmenu,IDM_STYLE,MF_BYCOMMAND|MF_ENABLED);
		}
	}
}
/*-------------------------------------------------------------------------

	Window Procedure

---------------------------------------------------------------------------*/
//--------------------------------------------------------------------------
LRESULT CALLBACK WindowProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
//--------------------------------------------------------------------------
//	Window procedure for the main application window
{
	switch(msg){
		HANDLE_MSG(hwnd, WM_CREATE, OnCreate);
		HANDLE_MSG(hwnd, WM_COMMAND, OnCommand);
		HANDLE_MSG(hwnd, WM_SIZE, OnSize);
		HANDLE_MSG(hwnd, WM_SETFOCUS, OnSetFocus);
		HANDLE_MSG(hwnd, WM_DESTROY, OnDestroy);
		HANDLE_MSG(hwnd, WM_MENUSELECT, OnMenuSelect);
	}
	return DefWindowProc(hwnd,msg,wParam,lParam);
}
/*-------------------------------------------------------------------------

	Main Procedure

---------------------------------------------------------------------------*/
//--------------------------------------------------------------------------
int PASCAL WinMain(HINSTANCE hinstCurrent,HINSTANCE hinstPrevious,
					LPSTR lpszCmdLine,int nCmdShow)
//--------------------------------------------------------------------------
{
	WNDCLASS w;

//	Load the control classes

	DeLoad();
	DpLoad();

//	Register our main window class

	hInstance= hinstCurrent;

	w.style=0;
	w.lpfnWndProc=WindowProc;
	w.cbClsExtra=0;
	w.cbWndExtra=0;
	w.hInstance=hinstCurrent;
	w.hIcon=LoadIcon(hinstCurrent,"DlgEd");
	w.hCursor=LoadIcon(0,IDC_ARROW);
	w.hbrBackground=COLOR_WINDOW+1;
	w.lpszMenuName="DlgEd";
	w.lpszClassName="DlgEd";
	if (RegisterClass(&w)){

//	Create and show the window

		HWND hwnd=CreateWindow("DlgEd","Dialog Editor Sample",
					WS_VISIBLE|WS_OVERLAPPEDWINDOW,
					CW_USEDEFAULT,CW_USEDEFAULT,
					CW_USEDEFAULT,CW_USEDEFAULT,
					0,0,hinstCurrent,0);
		if (hwnd){
			MSG msg;
			tGridProc=(FARPROC)MakeProcInstance((FARPROC)GridProc,hInstance);
			while (GetMessage(&msg, 0, 0, 0)) {
				if (!IsDialogMessage(hedit,&msg)){
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
			}
			FreeProcInstance(tGridProc);
		}
	}
	return 0;
}
