/*
 * WEP.C
 *
 * Standard routines for a DLL.
 *
 */


#include <windows.h>

HINSTANCE hDLLInst;			// DLL Handle

/*
 * LibMain
 *
 *
 */

int __export CALLBACK LibMain(HANDLE hModule, WORD wDataSeg,
                       WORD cbHeapSize, LPSTR lpszCmdLine)
{
	if (cbHeapSize != 0)   // If DLL data seg is MOVEABLE
		UnlockData (0);
    return 1;
}


/*
 * WEP
 *
 * Purpose:
 *  Performs cleanup tasks when the DLL is unloaded.  WEP() is
 *  called automatically by Windows when the DLL is unloaded (no
 *  remaining tasks still have the DLL loaded).  It is strongly
 *  recommended that a DLL have a WEP() function, even if it does
 *  nothing but returns success (1), as in this example.
 *
 * Parameters:
 *  bSystemExit int     Flag indicating if the system is shutting
 *                      down or not.
 *
 * Return Value:
 *  1
 *
 */
int __export CALLBACK _WEP (int bSystemExit);
#pragma alloc_text(FIXEDSEG, _WEP)

int __export CALLBACK _WEP (int bSystemExit)
{
    return(1);
}
