/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/*                                                                 */
/*                                                                 */
/*                                                                 */
/*   TCP4W.DLL  (Version 1.5)                                      */
/*                                                                 */
/*                                                                 */
/*                                                   By Ph. Jounin */
/*                                        Internet ark@ifh.sncf.fr */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */


#ifndef TCP4W_API

#include <winsock.h>

#ifdef __cplusplus  
extern "C" {            /* Assume C declarations for C++ */   
#endif  /* __cplusplus */   

#define API4W PASCAL FAR 

/* ------------------------------- */
/* Return codes of TCP4W functions */
/* ------------------------------- */
#define  IP_SUCCESS           1  /* >=1 function OK            */
#define  IP_ERROR            -1  /* error                      */
#define  IP_TIMEOUT          -2  /* timeout has occured        */
#define  IP_BUFFERFREED      -3  /* the buffer has been freed  */
#define  IP_HOSTUNKNOWN      -4  /* connect to unknown host    */
#define  IP_NOMORESOCKET     -5  /* all socket has been used   */
#define  IP_NOMORERESOURCE   -5  /* or no more free resource   */
#define  IP_CONNECTFAILED    -6  /* connect function has failed*/
#define  IP_UNMATCHEDLENGTH  -7  /* TcpPPRecv : Error in length*/
#define  IP_BINDERROR        -8  /* bind failed (Task already started?) */
#define  IP_OVERFLOW         -9  /* Overflow during TcpPPRecv  */
#define  IP_EMPTYBUFFER     -10  /* TcpPPRecv receives 0 byte  */
#define  IP_CANCELLED       -11  /* Call cancelled by TcpAbort */
#define  IP_INSMEMORY       -12  /* Not enough memory          */
#define  IP_SOCKETCLOSED      0  /* Host has close connection  */

/* ------------------------------ */
/* Return codes of TN4W functions */
/* ------------------------------ */
#define  TN_SUCCESS        IP_SUCCESS
#define  TN_ERROR          IP_ERROR         
#define  TN_TIMEOUT        IP_TIMEOUT       
#define  TN_BUFFERFREED    IP_BUFFERFREED   
#define  TN_SOCKETCLOSED   IP_SOCKETCLOSED
#define  TN_OVERFLOW       2



/* ------------------------------------------------- */
/* Registration functions                            */   
/* ------------------------------------------------- */
int API4W Tcp4wInit (void);
int API4W Tcp4wCleanup (void);
int API4W Tcp4wVer (LPSTR szInfo, UINT uBufSize);


/* ------------------------------------------------- */
/* TCP functions                                     */   
/* ------------------------------------------------- */
int API4W TcpAbort (void);
int API4W TcpAccept (SOCKET far *pCSock, SOCKET ListenSock, UINT nTO);
int API4W TcpConnect (SOCKET far *pS, LPSTR szServer, LPSTR szService, unsigned short far *lpPort);
int API4W TcpClose (SOCKET far *pS);
int API4W TcpFlush (SOCKET s);
int API4W TcpGetListenSocket (SOCKET far *pS, LPSTR szService, short far *lpPort, int nPendingConnection);
int API4W TcpRecv (SOCKET s, LPSTR szBuf, unsigned uBufSize, unsigned uTimeOut, HFILE hf);
int API4W TcpSend (SOCKET s, LPSTR szBuf, unsigned uBufSize, BOOL bHighPriority, HFILE hf);

int API4W TcpGetLocalID (LPSTR szStrName, int uNameSize, DWORD far *lpAddress);
int API4W TcpGetRemoteID (SOCKET s, LPSTR szStrName, int uNameSize, DWORD far *lpAddress);
BOOL API4W TcpIsDataAvail (SOCKET s);
BOOL API4W TcpIsOOBDataAvail (SOCKET s);

/* PP protocole (2 first bytes contain length of data) */
int API4W TcpPPRecv (SOCKET s, LPSTR szBuf, unsigned uBufSize, unsigned uTimeOut, BOOL bExact, HFILE hLogFile);
int API4W TcpPPSend (SOCKET s, LPSTR szBuf, unsigned uBufSize, HFILE hLogFile);

int API4W TcpRecvUntilStr (SOCKET s, LPSTR szBuf,unsigned far *lpBufSize,
                          LPSTR szStop, unsigned uStopSize, BOOL bCaseSensitive,
                          unsigned uTimeOut, HFILE hLogFile);
   
/* ------------------------------------------------- */
/* Telnet functions                                  */   
/* ------------------------------------------------- */
int API4W TnReadLine (SOCKET s, LPSTR szBuf, UINT BufSize, UINT uTimeOut, HFILE hf);
int API4W TnSend (SOCKET s, LPSTR szString, BOOL bHighPriority, HFILE hf);
int API4W TnGetAnswerCode(SOCKET ctrl_skt,LPSTR szInBuf,UINT uBufSize,UINT uTimeOut, HFILE hf);



#ifdef __cplusplus     
}  /* End of extern "C" */   
#endif /* ifdef __cplusplus */

#define TCPW_API loaded
#endif /* ifndef TCP4W_API */

