Unit UseFTP4W;
{by Barbara Tikart  Polarwolf Hard & Software, D-63906 Erlenbach am Main}
{and AStA Uni Konstanz (AStA = Allgemeiner Studierenden Ausschuss)}
{eMail to Andreas.Tikart@uni-konstanz.de or AStA@uni-konstanz.de}
{Declarations for FTP module to use with 'FTP4W' Version 2.2g or higher}
{Released into Public Domain}
{Get the newest version via http://www.uni-konstanz.de/studis/asta/software/index.html}

Interface

Uses WinTypes, WinProcs;

{-----------------------------------------------------------}
{ASCII or binary tranfser}

Const TYPE_A = Ord ('A');
Const TYPE_I = Ord ('I');

{-----------------------------------------------------------}
{              Return codes of FTP functions                }
{-----------------------------------------------------------}

Const FTPERR_OK = 0;                  {succesful function}
Const FTPERR_ENTERPASSWORD = 1;       {userid need a password}
Const FTPERR_ACCOUNTNEEDED = 2;       {user/pass OK but account required}
Const FTPERR_CANCELBYUSER = -1;       {Transfer aborted by user FtpAbort}

{* user's or programmer's Errors}
Const FTPERR_INVALIDPARAMETER = 1000; {Error in parameters}
Const FTPERR_SESSIONUSED = 1001;      {User has already a FTP session}
Const FTPERR_NOTINITIALIZED = 1002;   {FtpInit has not been call}
Const FTPERR_NOTCONNECTED = 1003;     {User is not connected to a server}
Const FTPERR_CANTOPENFILE = 1004;     {can not open specified file}
Const FTPERR_CANTWRITE = 1005;        {can't write into file (disk full?)}
Const FTPERR_NOACTIVESESSION = 1006;  {FtpRelease without FtpInit}
Const FTPERR_STILLCONNECTED = 1007;   {FtpRelease without any Close}
Const FTPERR_SERVERCANTEXECUTE = 1008;{file action not taken}
Const FTPERR_LOGINREFUSED = 1009;     {Server rejects usrid/passwd}
Const FTPERR_NOREMOTEFILE = 1010;     {server can not open file}
Const FTPERR_TRANSFERREFUSED = 1011;  {Host refused the transfer}
Const FTPERR_WINSOCKNOTUSABLE = 1012; {A winsock.DLL ver 1.1 is required}
Const FTPERR_CANTCLOSE = 1013;        {close failed (cmd is in progress)}
Const FTPERR_FILELOCKED = 1014;       {temporary error during FtpDelete}

{* TCP errors}
Const FTPERR_UNKNOWNHOST = 2001;      {can not resolve host adress}
Const FTPERR_NOREPLY = 2002;          {host does not send an answer}
Const FTPERR_CANTCONNECT = 2003;      {Error during connection}
Const FTPERR_CONNECTREJECTED = 2004;  {host has no FTP server}
Const FTPERR_SENDREFUSED = 2005;      {can't send data (network down)}
Const FTPERR_DATACONNECTION = 2006;   {connection on data-port failed}
Const FTPERR_TIMEOUT = 2007;          {timeout occurred}

{* FTP errors}
Const FTPERR_UNEXPECTEDANSWER = 3001; {answer was not expected}
Const FTPERR_CANNOTCHANGETYPE = 3002; {host rejects the TYPE command}
Const FTPERR_CMDNOTIMPLEMENTED = 3003;{host recognize but can't exec cmd}
Const FTPERR_PWDBADFMT = 3004;        {PWD cmd OK, but answer has no "}
Const FTPERR_PASVCMDNOTIMPL = 3005;   {Server don't support passive mode}

{* Resource errors}
Const FTPERR_CANTCREATEWINDOW = 5002; {Insufficent free resources}
Const FTPERR_INSMEMORY = 5003;        {Insufficient Heap memory}
Const FTPERR_CANTCREATESOCKET = 5004; {no more socket}
Const FTPERR_CANTBINDSOCKET = 5005;   {bind is not succesful}
Const FTPERR_SYSTUNKNOWN = 5006;      {host system not in the list}

{-----------------------------------------------------------}
{              FTP4W internal data structure                }
{-----------------------------------------------------------}

Const FTP_DATABUFFER = 4096; {a good value for X25/Ethernet/Token Ring}

Type PFtp_Msg = ^TFtp_Msg;
     TFtp_MSG = Record
         hParentWnd: hWnd;        {window which the msg is to be passed}
         nCompletedMessage: Word; {msg to be sent at end of the function}
       End;

     PFtp_Verbose = ^TFtp_Verbose;
     TFtp_Verbose = Record
         hVerboseWnd: hWnd;  {window which the message is to be passed}
         nVerboseMsg: Word;  {msg to be sent each time a line is received}
       End;

     PFtp_FileTrf = ^TFtp_FileTrf;
     TFtp_FileTrf = Record
         hf: THandle;        {handle of the file which is being transfered}
         nCount: Word;       {number of writes/reads made on a file}
         nAsyncAlone: Word;  {pause each N frame in Async mode  (Def 40)}
         nAsyncMulti: Word;  {Idem but more than one FTP sssion (Def 10)}
         nDelay: Word;       {time of the pause in milliseconds}
         bAborted: Bool;     {data transfer has been canceled}
         szBuf : Array [0..FTP_DataBuffer-1] Of Char; {Data buffer}
         bNotify: Bool;      {application receives a msg each data packet}
         bAsyncMode: Bool;   {synchronous or asynchronous Mode}
         lPos: LongInt;      {Bytes transfered}
         lTotal: LongInt;    {bytes to be transfered}
       End;

     PWinsock_in_addr = ^TWinsock_in_addr;
     TWinsock_in_addr = Record
         Case Byte Of
             0: (B1, B2, B3, B4: Byte);
           End;

     PWinsock_sockaddr_in = ^TWinsock_sockaddr_in;
     TWinsock_sockaddr_in = Record
         in_family: Integer;
         in_port: Word;
         in_addr: TWinsock_in_addr;
         sin_zero: Array [0..7] Of Char;
       End;

     PFtp_FtpData = ^TFtp_FtpData;
     TFtp_FtpData = Record
         ctrl_socket: Word;    {control stream       init INVALID_SOCKET}
         data_socket: Word;    {data stream          init INVALID_SOCKET}
         cType: Char;          {type (ASCII/binary)  init TYPE_A}
         bVerbose: Bool;       {verbose mode         init FALSE}
         bPassif: Bool;        {VRAI -> mode passif}
         nPort: Integer;       {connexion Port       init FTP_DEFPORT}
         nTimeOut: Integer;    {TimeOut in seconds   init FTP_DEFTIMEOUT}
         hLogFile: THandle;    {Log file}
         szInBuf: Array [0..1024-1] of Char; {incoming Buffer}
         Unknown: Byte;        {Perhaps it is on the wrong Place}
         saSockAddr: TWinsock_sockaddr_in;
         saAcceptAddr: TWinsock_sockaddr_in;
       End;

     PFtp_ProcData = ^TFtp_ProcData;
     TFtp_ProcData = Record
           { task data }
         hTask: THandle;        {Task Id}
         hFtpWindow: hWnd;      {Handle of the internal window}
         hParentWnd: hWnd;      {handle given to the FtpInit function}
         hInstance: THandle;    {Task Instance}
         bRelease:  Bool;       {FtpRelease has been called}
           {Mesasge information}
         MSG: TFtp_Msg;
         VMSG: TFtp_Verbose;
           {File information}
         FileTrf: TFtp_FileTrf;
           {Ftp information}
         Ftp: TFtp_FtpData;
           {Linked list}
         Next, Prev: PFtp_ProcData;  {Don't use}
                              { TFtp_FtpData has wrong length}
       End;

{-----------------------------------------------------------}
{              FTP Import Functions                         }
{-----------------------------------------------------------}

{* Init functions}
Type TFtpInit = Function (hWindow: hWnd): Integer;
Type TFtpRelease = Function : Integer;

{* Connection}
Type TFtpLogin = Function (Host, User, Password: PChar; hWindow: hWnd; wMSG: Word): Integer;
Type TFtpOpenConnection = Function (Host: PChar): Integer;
Type TFtpCloseConnection = Function : Integer;
Type TFtpLocalClose = Function : Integer;

{* authentification}
Type TFtpSendUserName = Function (UserName: PChar): Integer;
Type TFtpSendPasswd = Function (Passwd: PChar): Integer;

{* commands}
Type TFtpHelp = Function (Arg, Buf: PChar; BufSize: Word): Integer;
Type TFtpDeleteFile = Function (szRemoteFile: PChar): Integer;
Type TFtpRenameFile = Function (szFrom, szTo: PChar): Integer;
Type TFtpSyst = Function (szSystemStr: Pointer): Integer;
Type TFtpCWD = Function (Path: PChar): Integer;
Type TFtpQuote = Function (Cmd, ReplyBuf: PChar; BufSize: Integer): Integer;
Type TFtpSetType = Function (Typ: Integer): Integer;
Type TFtpCDUP = Function: Integer;
Type TFtpPWD = Function (szBuf: PChar; uBufSize: Word): Integer;
Type TFtpMKD = Function (szPath, szFullDir: PChar; uBufSize: Word): Integer;
Type TFtpRMD = Function (szPath: PChar): Integer;

{* file transfer}
Type TFtpAbort = Function : Integer;
Type TFtpFlush = Function : Integer;
Type TFtpSendFile = Function (Lcl, Remote: PChar; Typ: Integer; Notify :
         Bool; hWindow: hWnd; wMSG: Word): Integer;
Type TFtpRecvFile = Function (Remote, Lcl: PChar; Typ: Integer; Notify :
         Bool; hWindow: hWnd; wMSG: Word): Integer;
Type TFtpAppendToRemoteFile = Function (Lcl, Remote: PChar; Typ: Integer; Notify :
         Bool; hWindow: hWnd; wMSG: Word): Integer;
Type TFtpAppendToLocalFile = Function (Remote, Lcl: PChar; Typ: Integer; Notify :
         Bool; hWindow: hWnd; wMSG: Word): Integer;
Type TFtpGetFileSize = Function : LongInt;

{* Directory}
Type TFtpDir = Function (Def, LocalFile: PChar; LongDir: Bool;
         hWindow: hWnd; wMSG: Word): Integer;

{* specials}
Type TFtpBytesTransferred =  Function : LongInt;
Type TFtpBytesToBeTransferred = Function : LongInt;
Type TFtpSetDefaultTimeOut = Procedure (nTo_in_sec: Integer);
Type TFtpSetDefaultPort = Procedure (nDefPort: Integer);
Type TFtpSetAsynchronousMode = Procedure;
Type TFtpSetSynchronousMode =  Procedure;
Type TFtpIsAsynchronousMode = Function : Bool;
Type TFtpSetNewDelay = Procedure (X: Integer);
Type TFtpSetNewSlices = Procedure (X, Y: Integer);
Type TFtpSetPassiveMode = Procedure (bPassive: Bool);
Type TFtpLogTo = Procedure (hLogFile: THandle);

{* Utilities functions}
Type TWEP = Function (nType: Integer): Integer;
Type TFtpSetVerboseMode = Function (bVerboseMode: Integer; hWindow: hWnd;
  wMsg: Integer): Integer;
Type TFtpDataPtr = Function: PFtp_ProcData;
Type TFtp4wVer = Function (szVerStr: PChar; nStrSize: Word): Integer;

Var FtpInit : TFtpInit;
Var FtpRelease: TFtpRelease;
Var FtpLogin: TFtpLogin;
Var FtpOpenConnection: TFtpOpenConnection;
Var FtpCloseConnection: TFtpCloseConnection;
Var FtpLocalClose: TFtpLocalClose;
Var FtpSendUserName: TFtpSendUserName;
Var FtpSendPasswd: TFtpSendPasswd;
Var FtpHelp: TFtpHelp;
Var FtpDeleteFile: TFtpDeleteFile;
Var FtpRenameFile: TFtpRenameFile;
Var FtpSyst: TFtpSyst;
Var FtpCWD: TFtpCWD;
Var FtpQuote: TFTPQuote;
Var FtpSetType: TFtpSetType;
Var FtpCDUP : TFtpCDUP;
Var FtpPWD: TFtpPWD;
Var FtpMKD: TFtpMKD;
Var FtpRMD: TFtpRMD;
Var FtpAbort: TFtpAbort;
Var FtpFlush: TFtpFlush;
Var FtpSendFile: TFtpSendFile;
Var FtpRecvFile: TFtpRecvFile;
Var FtpAppendToRemoteFile : TFtpAppendToRemoteFile;
Var FtpAppendToLocalFile : TFtpAppendToLocalFile;
Var FtpGetFileSize: TFtpGetFileSize;
Var FtpDir: TFtpDir;
Var FtpBytesTransferred: TFtpBytesTransferred;
Var FtpBytesToBeTransferred: TFtpBytesToBeTransferred;
Var FtpSetDefaultTimeOut: TFtpSetDefaultTimeOut;
Var FtpSetDefaultPort: TFtpSetDefaultPort;
Var FtpSetAsynchronousMode: TFtpSetAsynchronousMode;
Var FtpSetSynchronousMode: TFtpSetSynchronousMode;
Var FtpIsAsynchronousMode: TFtpIsAsynchronousMode;
Var FtpSetNewDelay: TFtpSetNewDelay;
Var FtpSetNewSlices: TFtpSetNewSlices;
Var FtpSetPassiveMode: TFtpSetPassiveMode;
Var FtpLogTo: TFtpLogTo;

Var WEP: TWEP;
Var FtpSetVerboseMode: TFtpSetVerboseMode;
Var FtpDataPtr: TFtpDataPtr;
Var Ftp4wVer: TFtp4wVer;

{Unit-implemented Functions}
Function FTP4W_Error (ErrorValue: Integer): PChar;

Implementation

Var hFtp4W: THandle;

Procedure LoadFtp4WDLL;
  Var FP: TFarProc;
  Begin
    If hFtp4W >= 32 Then FreeLibrary (hFtp4W);
    hFtp4W := LoadLibrary ('FTP4W.DLL');
    If hFtp4W < 32 Then Exit;
    FP := GetProcAddress (hFtp4W, 'FtpInit');
    FtpInit := TFtpInit (FP);
    FP := GetProcAddress (hFtp4W, 'FtpRelease');
    FtpRelease := TFtpRelease (FP);
    FP := GetProcAddress (hFtp4W, 'FtpLogin');
    FtpLogin := TFtpLogin (FP);
    FP := GetProcAddress (hFtp4W, 'FtpOpenConnection');
    FtpOpenConnection := TFtpOpenConnection (FP);
    FP := GetProcAddress (hFtp4W, 'FtpCloseConnection');
    FtpCloseConnection := TFtpCloseConnection (FP);
    FP := GetProcAddress (hFtp4W, 'FtpLocalClose');
    FtpLocalClose := TFtpLocalClose (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSendUserName');
    FtpSendUserName := TFtpSendUserName (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSendPasswd');
    FtpSendPasswd := TFtpSendPasswd (FP);
    FP := GetProcAddress (hFtp4W, 'FtpHelp');
    FtpHelp := TFtpHelp (FP);
    FP := GetProcAddress (hFtp4W, 'FtpDeleteFile');
    FtpDeleteFile := TFtpDeleteFile (FP);
    FP := GetProcAddress (hFtp4W, 'FtpRenameFile');
    FtpRenameFile := TFtpRenameFile (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSyst');
    FtpSyst := TFtpSyst (FP);
    FP := GetProcAddress (hFtp4W, 'FtpCWD');
    FtpCWD := TFtpCWD (FP);
    FP := GetProcAddress (hFtp4W, 'FtpQuote');
    FtpQuote := TFtpQuote (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSetType');
    FtpSetType := TFtpSetType (FP);
    FP := GetProcAddress (hFtp4W, 'FtpCDUP');
    FtpCDUP := TFtpCDUP (FP);
    FP := GetProcAddress (hFtp4W, 'FtpPWD');
    FtpPWD := TFtpPWD (FP);
    FP := GetProcAddress (hFtp4W, 'FtpMKD');
    FtpMKD := TFtpMKD (FP);
    FP := GetProcAddress (hFtp4W, 'FtpRMD');
    FtpRMD := TFtpRMD (FP);
    FP := GetProcAddress (hFtp4W, 'FtpAbort');
    FtpAbort := TFtpAbort (FP);
    FP := GetProcAddress (hFtp4W, 'FtpFlush');
    FtpFlush := TFtpFlush (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSendFile');
    FtpSendFile := TFtpSendFile (FP);
    FP := GetProcAddress (hFtp4W, 'FtpRecvFile');
    FtpRecvFile := TFtpRecvFile (FP);
    FP := GetProcAddress (hFtp4W, 'FtpAppendToRemoteFile');
    FtpAppendToRemoteFile := TFtpAppendToRemoteFile (FP);
    FP := GetProcAddress (hFtp4W, 'FtpAppendToLocalFile');
    FtpAppendToLocalFile := TFtpAppendToLocalFile (FP);
    FP := GetProcAddress (hFtp4W, 'FtpGetFileSize');
    FtpGetFileSize := TFtpGetFileSize (FP);
    FP := GetProcAddress (hFtp4W, 'FtpDir');
    FtpDir := TFtpDir (FP);
    FP := GetProcAddress (hFtp4W, 'FtpBytesTransferred');
    FtpBytesTransferred := TFtpBytesTransferred (FP);
    FP := GetProcAddress (hFtp4W, 'FtpBytesToBeTransferred');
    FtpBytesToBeTransferred := TFtpBytesToBeTransferred (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSetDefaultTimeOut');
    FtpSetDefaultTimeOut := TFtpSetDefaultTimeOut (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSetDefaultPort');
    FtpSetDefaultPort := TFtpSetDefaultPort (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSetAsynchronousMode');
    FtpSetAsynchronousMode := TFtpSetAsynchronousMode (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSetSynchronousMode');
    FtpSetSynchronousMode := TFtpSetSynchronousMode (FP);
    FP := GetProcAddress (hFtp4W, 'FtpIsAsynchronousMode');
    FtpIsAsynchronousMode := TFtpIsAsynchronousMode (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSetNewDelay');
    FtpSetNewDelay := TFtpSetNewDelay (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSetNewSlices');
    FtpSetNewSlices := TFtpSetNewSlices (FP);
    FP := GetProcAddress (hFtp4W,  'FtpSetPassiveMode');
    FtpSetPassiveMode := TFtpSetPassiveMode (FP);
    FP := GetProcAddress (hFtp4W, 'FtpLogTo');
    FtpLogTo := TFtpLogTo (FP);
    FP := GetProcAddress (hFtp4W, 'WEP');
    WEP := TWEP (FP);
    FP := GetProcAddress (hFtp4W, 'FtpSetVerboseMode');
    FtpSetVerboseMode := TFtpSetVerboseMode (FP);
    FP := GetProcAddress (hFtp4W, 'FtpDataPtr');
    FtpDataPtr := TFtpDataPtr (FP);
    FP := GetProcAddress (hFtp4W, 'Ftp4wVer');
    Ftp4wVer := TFtp4wVer (FP);
  End;

Function FTP4W_Error (ErrorValue: Integer): PChar;
  {return a PChar related to the ErrorValue given}
  {as a parameter}
  Var Msg: PChar;
  Begin
    Case ErrorValue Of
        FTPERR_OK:               Msg := 'Ok';
        FTPERR_ENTERPASSWORD:    Msg := 'Userid need a password';
        FTPERR_ACCOUNTNEEDED:    Msg := 'User/pass OK but account required';
        FTPERR_CANCELBYUSER:     Msg := 'Transfer aborted by user FtpAbort';
        FTPERR_INVALIDPARAMETER: Msg := 'Error in parameters';
        FTPERR_SESSIONUSED:      Msg := 'User has already a FTP session';
        FTPERR_NOTINITIALIZED:   Msg := 'FtpInit has not been called';
        FTPERR_NOTCONNECTED:     Msg := 'User is not connected to a server';
        FTPERR_CANTOPENFILE:     Msg := 'Can not open specified file';
        FTPERR_CANTWRITE:        Msg := 'Can'#39't write into file (disk full?)';
        FTPERR_NOACTIVESESSION:  Msg := 'FtpRelease without FtpInit';
        FTPERR_STILLCONNECTED:   Msg := 'FtpRelease without any Close';
        FTPERR_SERVERCANTEXECUTE:Msg := 'File action not taken';
        FTPERR_LOGINREFUSED:     Msg := 'Server rejects Userid/Passwd';
        FTPERR_NOREMOTEFILE:     Msg := 'Server can not open file';
        FTPERR_TRANSFERREFUSED:  Msg := 'Host refused the transfer';
        FTPERR_WINSOCKNOTUSABLE: Msg := 'A winsock.DLL version 1.1 is required';
        FTPERR_CANTCLOSE:        Msg := 'Close failed (cmd is in progress)';
        FTPERR_FILELOCKED:       Msg := 'temporary error during FtpDelete';
        FTPERR_UNKNOWNHOST:      Msg := 'Can not resolve host address';
        FTPERR_NOREPLY:          Msg := 'Host does not send an answer';
        FTPERR_CANTCONNECT:      Msg := 'Error during connection';
        FTPERR_CONNECTREJECTED:  Msg := 'Host has no FTP server';
        FTPERR_SENDREFUSED:      Msg := 'Can'#39't send data (network down)';
        FTPERR_DATACONNECTION:   Msg := 'Connection on data-port failed';
        FTPERR_TIMEOUT:          Msg := 'Timeout occurred';
        FTPERR_UNEXPECTEDANSWER: Msg := 'Answer was not expected';
        FTPERR_CANNOTCHANGETYPE: Msg := 'Host rejects the TYPE command';
        FTPERR_CMDNOTIMPLEMENTED:Msg := 'host recognize but can'#39't exec cmd';
        FTPERR_PWDBADFMT:        Msg := 'PWD cmd OK, but answer has no "';
        FTPERR_PASVCMDNOTIMPL:   Msg := 'Server don'#39't support passive mode';
        FTPERR_CANTCREATEWINDOW: Msg := 'Insufficent free resources';
        FTPERR_INSMEMORY:        Msg := 'Insufficient Heap memory';
        FTPERR_CANTCREATESOCKET: Msg := 'No more socket';
        FTPERR_CANTBINDSOCKET:   Msg := 'Bind is not succesful';
        FTPERR_SYSTUNKNOWN:      Msg := 'host system not in the list';
      Else Msg := 'Unknown Error';
      End;
    FTP4W_Error := MSG;
  End;

Var SaveExitProc: Pointer;

Procedure MyExitProc; Far;
  Begin
    ExitProc := SaveExitProc;
    If hFtp4W >= 32 Then
      Begin
        FtpAbort;
        FtpFlush;
        FtpCloseConnection;
        FtpLocalClose;
        FTPRelease;
        FreeLibrary (hFtp4W)
      End
  End;

Begin
  hFtp4W := 0;
  SaveExitProc := ExitProc;
  ExitProc := @MyExitProc;
  LoadFtp4WDLL;
  If hFtp4W < 32 Then
    Begin
      MessageBox (0, 'FTP4W.DLL not found', 'FTP4W',
        mb_IconStop Or mb_SystemModal Or mb_Ok);
      Halt;
    End;
  If @Ftp4wVer = NIL Then
    Begin
      MessageBox (0, 'Unsupported Version of FTP4W', 'FTP4W',
        mb_IconStop Or mb_SystemModal Or mb_Ok);
      Halt;
    End;
End.
