// NAME     : Martin's Standard Library for Program Manager DDE Comms.
//
// DDE Library for Creating Program Manager Groups From User Programs
// AUTHOR   : M.A.Searle, 10/02/95
// COMPILER : Borland C++ v4.0 & v4.02
// VERSION  : 2.0
// PLATFORM : MS Windows version 3.1 & 3.11
// PRODUCES : DDEDLL.DLL
// COPYRIGHT: M.A.Searle, 10/02/95
// DISTRIBUTION : FREEWARE, Please include author creditation in programs
//                that use these routines, thanks.
/*
Purpose : This is a DDE .DLL library designed to be used in conjunction
	 with program manager. The library facilitates all DDE calls to program
	 manager. It can also can copy files from one location to another. 

	 Most of the function calls are to the more obscure Windows API functions
	 The code is designed to simplify the calls these functions by encapsulating
	 them with a simple call to a function.
*/

#define WIN31
#include <windows.h>
#include <ddeml.h>
#include <string.h>
#include <lzexpand.h>
#include <dir.h>
#include "c:\cplus\windows\dlltest\newdde\ddedll.h"

DWORD InstId;
HCONV HConv;
HSZ Service;
HSZ Topic;
HSZ Item;
FARPROC lpDdeProc;
HWND hWindow;

/*
  This is DDE callback function. All DDE transactions handled in this library refer to this
  procedure for Disconnects and other Errors.
*/
HDDEDATA CALLBACK FAR PASCAL _export CallBack(WORD type,WORD,HCONV,HSZ,HDDEDATA,DWORD,DWORD)
{

  switch (type)
  {
	 case XTYP_DISCONNECT:
		 MessageBox(0,"Disconnected From Program Manager","dde server",MB_ICONINFORMATION);
		 HConv = 0;
		 break;
	 case XTYP_ERROR:
		 MessageBox(0,"A Critical DDE error has occured","dde server",MB_ICONINFORMATION);
  }
  return 0;
};


/*
  The next three functions handle the creation of icons and maintaining of them. There are functions
  to add icons (CreatePMIcon),To replace one icon with another (ReplacePMIcon) and also to
  delete icons (DeletePMIcon). They use the callback function in DDE communication to
  program manager.
*/
void _export CreatePMIcon(char IconName[64],char Description[64])
{
  InstId = 0;
  HConv = 0;
  Service = Topic = 0;
  char* addItem = "[AddItem(%s,%s)]";
  lpDdeProc = MakeProcInstance((FARPROC) CallBack,0);
  if (DdeInitialize(&InstId,(PFNCALLBACK) lpDdeProc,APPCMD_CLIENTONLY,0L) == DMLERR_NO_ERROR)
  {
	  Service = DdeCreateStringHandle(InstId,"PROGMAN",CP_WINANSI);
  }
  else
	MessageBox(0,"Unable to connect to program manager","dde_apl",MB_OK | MB_ICONSTOP);
  HConv = DdeConnect(InstId,Service,Topic,0);
  if (!HConv)
  {
	  MessageBox(0,"Unable to connect to Program Manager","Dde Appl",MB_OK | MB_ICONSTOP);
	  return;
  }
  int len = strlen(IconName) + strlen(addItem) + strlen(Description) - 4 + 1;
  LPSTR commands = new char[len];
  LPSTR ptr=commands;
  wsprintf(ptr,addItem,(LPSTR)IconName,Description);
  if (DdeClientTransaction((LPBYTE)commands,len,HConv,0L,CF_TEXT,XTYP_EXECUTE,100,0))
	  delete commands;
  if (HConv)
	  DdeDisconnect(HConv);
  if (InstId){
	  DdeFreeStringHandle(InstId,Service);
	  DdeUninitialize(InstId);
  }
}

void _export ReplacePMIcon(char OldIconName[64],char NewIconName[64])
{
  InstId = 0;
  HConv = 0;
  Service = Topic = 0;
  char* replaceItem = "[ReplaceItem(%s)]";
  char* AddItem = "[AddItem(%s)]";
  lpDdeProc = MakeProcInstance((FARPROC) CallBack,0);
  if (DdeInitialize(&InstId,(PFNCALLBACK) lpDdeProc,APPCMD_CLIENTONLY,0L) == DMLERR_NO_ERROR)
  {
	  Service = DdeCreateStringHandle(InstId,"PROGMAN",CP_WINANSI);
  }
  else
  MessageBox(0,"Unable to connect to program manager","dde_apl",MB_OK | MB_ICONSTOP);
  HConv = DdeConnect(InstId,Service,Topic,0);
  if (!HConv)
  {
	  MessageBox(0,"Unable to connect to Program Manager","Dde Appl",MB_OK | MB_ICONSTOP);
	  return;
  }
  int len = strlen(OldIconName) + strlen(replaceItem) - 2 + 1;
  int nextLen = strlen(NewIconName) + strlen(AddItem) - 2 + 1;
  LPSTR commands = new char[len];
  LPSTR info = new char[nextLen];
  LPSTR ptr=commands;
  LPSTR Nptr=info;
  wsprintf(ptr,replaceItem,(LPSTR)OldIconName);
  wsprintf(Nptr,AddItem,(LPSTR)NewIconName);
  if (DdeClientTransaction((LPBYTE)commands,len,HConv,0L,CF_TEXT,XTYP_EXECUTE,100,0))
	  delete commands;
  if (DdeClientTransaction((LPBYTE)info,nextLen,HConv,0L,CF_TEXT,XTYP_EXECUTE,100,0))
	  delete info;
  if (HConv)
	  DdeDisconnect(HConv);
  if (InstId){
	  DdeFreeStringHandle(InstId,Service);
	  DdeUninitialize(InstId);
  }
}

void _export DeletePMIcon(char IconName[64])
{
  InstId = 0;
  HConv = 0;
  Service = Topic = 0;
  char* addItem = "[DeleteItem(%s)]";
  lpDdeProc = MakeProcInstance((FARPROC) CallBack,0);
  if (DdeInitialize(&InstId,(PFNCALLBACK) lpDdeProc,APPCMD_CLIENTONLY,0L) == DMLERR_NO_ERROR)
  {
	  Service = DdeCreateStringHandle(InstId,"PROGMAN",CP_WINANSI);
  }
  else
	MessageBox(0,"Unable to connect to program manager","dde_apl",MB_OK | MB_ICONSTOP);
  HConv = DdeConnect(InstId,Service,Topic,0);
  if (!HConv)
  {
	  MessageBox(0,"Unable to connect to Program Manager","Dde Appl",MB_OK | MB_ICONSTOP);
	  return;
  }
  int len = strlen(IconName) + strlen(addItem) - 2 + 1;
  LPSTR commands = new char[len];
  LPSTR ptr=commands;
  wsprintf(ptr,addItem,(LPSTR)IconName);
  if (DdeClientTransaction((LPBYTE)commands,len,HConv,0L,CF_TEXT,XTYP_EXECUTE,100,0))
	  delete commands;
  if (HConv)
	  DdeDisconnect(HConv);
  if (InstId){
	  DdeFreeStringHandle(InstId,Service);
	  DdeUninitialize(InstId);
  }
}


/*
  The next four functions are designed to handle and maintain program manager groups. The functions
  perform these tasks Creation (CreatePMGroup),Show Groups (ShowPMGroup), Deletion (DeletePMGroup) and
  Reloading (ReloadPMGroup).
*/

void _export CreatePMGroup(char GroupName[64])
{
  InstId = 0;
  HConv = 0;
  Service = Topic = 0;
  char* createGroup = "[CreateGroup(%s)]";
  lpDdeProc = MakeProcInstance((FARPROC) CallBack,0);
  if (DdeInitialize(&InstId,(PFNCALLBACK) lpDdeProc,APPCMD_CLIENTONLY,0L) == DMLERR_NO_ERROR)
  {
	  Service = DdeCreateStringHandle(InstId,"PROGMAN",CP_WINANSI);
  }
  else
	MessageBox(0,"Unable to connect to program manager","dde_apl",MB_OK | MB_ICONSTOP);
  HConv = DdeConnect(InstId,Service,Topic,0);
  if (!HConv)
  {
	  MessageBox(0,"Unable to connect to Program Manager","Dde Appl",MB_OK | MB_ICONSTOP);
	  return;
  }
  int len = strlen(GroupName) + strlen(createGroup) - 2 + 1;
  LPSTR commands = new char[len];
  LPSTR ptr=commands;
  wsprintf(ptr,createGroup,(LPSTR)GroupName);
  if (DdeClientTransaction((LPBYTE)commands,len,HConv,0L,CF_TEXT,XTYP_EXECUTE,100,0))
	  delete commands;
  if (HConv)
	  DdeDisconnect(HConv);
  if (InstId){
	  DdeFreeStringHandle(InstId,Service);
	  DdeUninitialize(InstId);
  }
}

void _export ShowPMGroup(char GroupName[64], int Operation)
{
  InstId = 0;
  HConv = 0;
  Service = Topic = 0;
  char* ChangeGroup = "[ShowGroup(%s,%d)]";
  lpDdeProc = MakeProcInstance((FARPROC) CallBack,0);
  if (DdeInitialize(&InstId,(PFNCALLBACK) lpDdeProc,APPCMD_CLIENTONLY,0L) == DMLERR_NO_ERROR)
  {
	  Service = DdeCreateStringHandle(InstId,"PROGMAN",CP_WINANSI);
  }
  else
	MessageBox(0,"Unable to connect to program manager","dde_apl",MB_OK | MB_ICONSTOP);
  HConv = DdeConnect(InstId,Service,Topic,0);
  if (!HConv)
  {
	  MessageBox(0,"Unable to connect to Program Manager","Dde Appl",MB_OK | MB_ICONSTOP);
	  return;
  }
  int len = strlen(GroupName) + strlen(ChangeGroup) - 4 + 2;
  LPSTR commands = new char[len];
  LPSTR ptr=commands;
  wsprintf(ptr,ChangeGroup,(LPSTR)GroupName,Operation);
  if (DdeClientTransaction((LPBYTE)commands,len,HConv,0L,CF_TEXT,XTYP_EXECUTE,100,0))
	  delete commands;
  if (HConv)
	  DdeDisconnect(HConv);
  if (InstId){
	  DdeFreeStringHandle(InstId,Service);
	  DdeUninitialize(InstId);
  }
}

void _export DeletePMGroup(char GroupName[64])
{
  InstId = 0;
  HConv = 0;
  Service = Topic = 0;
  char* createGroup = "[DeleteGroup(%s)]";
	lpDdeProc = MakeProcInstance((FARPROC) CallBack,0);
  if (DdeInitialize(&InstId,(PFNCALLBACK) lpDdeProc,APPCMD_CLIENTONLY,0L) == DMLERR_NO_ERROR)
  {
	  Service = DdeCreateStringHandle(InstId,"PROGMAN",CP_WINANSI);
  }
  else
	MessageBox(0,"Unable to connect to program manager","dde_apl",MB_OK | MB_ICONSTOP);
  HConv = DdeConnect(InstId,Service,Topic,0);
  if (!HConv)
  {
	  MessageBox(0,"Unable to connect to Program Manager","Dde Appl",MB_OK | MB_ICONSTOP);
	  return;
  }
  int len = strlen(GroupName) + strlen(createGroup) - 2 + 1;
  LPSTR commands = new char[len];
  LPSTR ptr=commands;
  wsprintf(ptr,createGroup,(LPSTR)GroupName);
  if (DdeClientTransaction((LPBYTE)commands,len,HConv,0L,CF_TEXT,XTYP_EXECUTE,100,0))
	  delete commands;
  if (HConv)
	  DdeDisconnect(HConv);
  if (InstId){
	  DdeFreeStringHandle(InstId,Service);
	  DdeUninitialize(InstId);
  }
}

void _export ReloadPMGroup(char GroupName[64])
{
  InstId = 0;
  HConv = 0;
  Service = Topic = 0;
  char* createGroup = "[ReloadGroup(%s)]";
  lpDdeProc = MakeProcInstance((FARPROC) CallBack,0);
  if (DdeInitialize(&InstId,(PFNCALLBACK) lpDdeProc,APPCMD_CLIENTONLY,0L) == DMLERR_NO_ERROR)
  {
	  Service = DdeCreateStringHandle(InstId,"PROGMAN",CP_WINANSI);
  }
  else
	MessageBox(0,"Unable to connect to program manager","dde_apl",MB_OK | MB_ICONSTOP);
  HConv = DdeConnect(InstId,Service,Topic,0);
  if (!HConv)
  {
	  MessageBox(0,"Unable to connect to Program Manager","Dde Appl",MB_OK | MB_ICONSTOP);
	  return;
  }
  int len = strlen(GroupName) + strlen(createGroup) - 2 + 1;
  LPSTR commands = new char[len];
  LPSTR ptr=commands;
  wsprintf(ptr,createGroup,(LPSTR)GroupName);
  if (DdeClientTransaction((LPBYTE)commands,len,HConv,0L,CF_TEXT,XTYP_EXECUTE,100,0))
	  delete commands;
  if (HConv)
	  DdeDisconnect(HConv);
  if (InstId){
	  DdeFreeStringHandle(InstId,Service);
	  DdeUninitialize(InstId);
  }
}

/*
  The next series of functions handle common program manager functions using the messaging
  technology within windows. These functions handle tasks such as Tiling of Groups, Restoring
  program manager to normal size, minimizing it, maximizing it and Exiting it.
*/

void _export TileProgMan()
{
HWND ProgHWND,MdiProgHWND;
 ProgHWND = ::FindWindow(NULL,"Program Manager");          // Get Prog. Man. Handle
 MdiProgHWND = ::GetWindow(ProgHWND,GW_CHILD);             // Get Prog. Man. MDI client App handle
 ::SendMessage(MdiProgHWND,WM_MDIGETACTIVE,0,0);           // Get the active MDI group
 ::SendMessage(MdiProgHWND,WM_MDITILE,MDITILE_VERTICAL,0); // Tile the groups
};

BOOL _export RestartWindows()
{
  return ExitWindows(EW_RESTARTWINDOWS,0);
};

BOOL _export RebootSystem()
{
	return ExitWindows(EW_REBOOTSYSTEM,0);
};

void _export ExitPM(int Save)
{
  InstId = 0;
  HConv = 0;
  Service = Topic = 0;
  char* createGroup = "[ExitProgman(%d)]";
  lpDdeProc = MakeProcInstance((FARPROC) CallBack,0);
  if (DdeInitialize(&InstId,(PFNCALLBACK) lpDdeProc,APPCMD_CLIENTONLY,0L) == DMLERR_NO_ERROR)
  {
	  Service = DdeCreateStringHandle(InstId,"PROGMAN",CP_WINANSI);
  }
  else
	MessageBox(0,"Unable to connect to program manager","dde_apl",MB_OK | MB_ICONSTOP);
  HConv = DdeConnect(InstId,Service,Topic,0);
  if (!HConv)
  {
	  MessageBox(0,"Unable to connect to Program Manager","Dde Appl",MB_OK | MB_ICONSTOP);
	  return;
  }
  int len = strlen(createGroup);
  LPSTR commands = new char[len];
  LPSTR ptr=commands;
  wsprintf(ptr,createGroup,Save);
  if (DdeClientTransaction((LPBYTE)commands,len,HConv,0L,CF_TEXT,XTYP_EXECUTE,100,0))
	  delete commands;
  if (HConv)
	  DdeDisconnect(HConv);
  if (InstId){
	  DdeFreeStringHandle(InstId,Service);
	  DdeUninitialize(InstId);
  }
}

void _export CopyFile(char SourceFile[MAXPATH],char DestinationFile[MAXPATH])
{
  HFILE hfSrcFile,hfDstFile;
  OFSTRUCT ofStrSrc;
  OFSTRUCT ofStrDest;

  LZStart();
  hfSrcFile = LZOpenFile(SourceFile,&ofStrSrc,OF_READ);
  hfDstFile = LZOpenFile(DestinationFile,&ofStrDest,OF_CREATE);
  LZCopy(hfSrcFile,hfDstFile);
  LZClose(hfSrcFile);
  LZClose(hfDstFile);
  LZDone();
};




/* GENERAL FUNCTIONS TO HANDLE WINDOWS SYSTEM CHANGES */

BOOL _export ChangeWallpaper(char wallpaper[MAXPATH],BOOL changeini)
{
  if (changeini == TRUE)
  {
	 return SystemParametersInfo(SPI_SETDESKWALLPAPER,0,wallpaper,SPIF_UPDATEINIFILE | SPIF_SENDWININICHANGE);
  }
  else
  {
	 return SystemParametersInfo(SPI_SETDESKWALLPAPER,0,wallpaper,0);
  };
};

BOOL _export SetScreenSaver(BOOL Active,int Interval,BOOL changeini)
{
  BOOL OK;
  if (changeini == TRUE)
  {
	 OK = SystemParametersInfo(SPI_SETSCREENSAVEACTIVE,Active,NULL,SPIF_UPDATEINIFILE | SPIF_SENDWININICHANGE);
	 if (OK==TRUE)
		 return SystemParametersInfo(SPI_SETSCREENSAVETIMEOUT,Interval,NULL,SPIF_UPDATEINIFILE | SPIF_SENDWININICHANGE);
  }
  else
  {
	 OK = SystemParametersInfo(SPI_SETSCREENSAVEACTIVE,Active,NULL,0);
	 if (OK==TRUE)
		 return SystemParametersInfo(SPI_SETSCREENSAVETIMEOUT,Interval,NULL,0);
  };
  return FALSE;
};

BOOL _export SwapMouse(BOOL Swap,BOOL changeini)
{
  if (changeini == TRUE)
  {
	 return SystemParametersInfo(SPI_SETMOUSEBUTTONSWAP,Swap,NULL,SPIF_UPDATEINIFILE | SPIF_SENDWININICHANGE);
  }
  else
  {
	 return SystemParametersInfo(SPI_SETMOUSEBUTTONSWAP,Swap,NULL,0);
  };
};

void _export AddAnExcelCell(char* data,char *coord,char* spreadsheet)
{
  InstId = 0;
  HConv = 0;
  Service = Topic = Item = 0;
  lpDdeProc = MakeProcInstance((FARPROC) CallBack,0);
  if (DdeInitialize(&InstId,(PFNCALLBACK) lpDdeProc,APPCMD_CLIENTONLY,0L) == DMLERR_NO_ERROR)
  {
	  Service = DdeCreateStringHandle(InstId,"Excel",CP_WINANSI);
	  Topic = DdeCreateStringHandle(InstId,spreadsheet,CP_WINANSI);
	  Item = DdeCreateStringHandle(InstId,coord,CP_WINANSI);
  }
  else
	  MessageBox(0,"Unable to connect to MicroSoft Excel","DDE DLL",MB_OK | MB_ICONSTOP);
  HConv = DdeConnect(InstId,Service,Topic,0);
  if (!HConv)
  {
	  MessageBox(0,"Unable to connect to Microsoft Excel","DDE DLL",MB_OK | MB_ICONSTOP);
	  return;
  }
#ifdef DBG
  else

	  MessageBox(0,"Connected To Microsoft Excel","Dde Dll",MB_OK | MB_ICONINFORMATION);
#endif
  int len = strlen(data);
  LPSTR commands = new char[len+1];
  if (commands==NULL)
  {
	  MessageBox(0,"Error. Out of memory","Dde Dll",MB_OK | MB_ICONEXCLAMATION);
  }
  else
  {
	  wsprintf(commands,data);
	  DdeClientTransaction((void FAR *)commands,len+1,HConv,Item,CF_TEXT,XTYP_POKE,1000,0);
	  delete commands;
  }
  if (HConv)
	  DdeDisconnect(HConv);
  if (InstId){
	  DdeFreeStringHandle(InstId,Service);
	  DdeFreeStringHandle(InstId,Topic);
	  DdeFreeStringHandle(InstId,Item);
	  DdeUninitialize(InstId);
  }
}

void _export GetAnExcelCell(char *coord,char *RetData, int LenRetData,char* Spreadsheet)
{
  InstId = 0;
  HConv = 0;
  Service = Topic = Item = 0;
  lpDdeProc = MakeProcInstance((FARPROC) CallBack,0);
  if (DdeInitialize(&InstId,(PFNCALLBACK) lpDdeProc,APPCMD_CLIENTONLY,0L) == DMLERR_NO_ERROR)
  {
	  Service = DdeCreateStringHandle(InstId,"Excel",CP_WINANSI);
	  Topic = DdeCreateStringHandle(InstId,Spreadsheet,CP_WINANSI);
	  Item = DdeCreateStringHandle(InstId,coord,CP_WINANSI);
  }
  else
	  MessageBox(0,"Unable to connect to MicroSoft Excel","DDE DLL",MB_OK | MB_ICONSTOP);
  HConv = DdeConnect(InstId,Service,Topic,0);
  if (!HConv)
  {
	  MessageBox(0,"Unable to connect to Microsoft Excel","DDE DLL",MB_OK | MB_ICONSTOP);
	  return;
  }
#ifdef DBG
  MessageBox(0,"Connected To Microsoft Excel","Dde Dll",MB_OK | MB_ICONINFORMATION);
#endif

  HDDEDATA hData;
  LPBYTE lpszAdviseData;
  DWORD cbDataLen;
  DWORD i;

  hData=DdeClientTransaction((void FAR *)NULL,0,HConv,Item,CF_TEXT,XTYP_REQUEST,100,0);

  lpszAdviseData = DdeAccessData(hData, &cbDataLen);
  if (cbDataLen>LenRetData)
  {
	  MessageBox(0,"Error. Returned data too long for string","DdeDll",MB_OK|MB_ICONEXCLAMATION);
  }
  else
  {
	  for (i = 0; i < cbDataLen; i++)
		 RetData[i] = *lpszAdviseData++;
  }
  DdeUnaccessData(hData);

  if (HConv)
	  DdeDisconnect(HConv);
  if (InstId){
	  DdeFreeStringHandle(InstId,Service);
	  DdeFreeStringHandle(InstId,Topic);
	  DdeFreeStringHandle(InstId,Item);
	  DdeUninitialize(InstId);
  }
}

/* Library definition functions for loading and exiting using a standard method */

int FAR PASCAL LibMain(HINSTANCE hInstance,WORD wDataSeg,WORD cbHeapSize,LPSTR lpCmdLine);

int FAR PASCAL WEP(int nParameter);
