/*
//	SCCS Id: "@(#)agrep.h		(C) Yves Roumazeilles	94/05/28";
//
//	Version 3.02a
*/

#ifndef	__AGREP_H__
#define	__AGREP_H__
#ifdef __cplusplus
extern "C" {
#endif


#ifdef	WINVER
#define	AGCALL	FAR PASCAL
#else
#define	AGCALL
#endif

WORD	AGCALL	AGrepVersion( void );


/* AGrep Search Engine Error Codes */
#define AGERR_UNKNOWN_TYPE		-1
#define AGERR_NO_ERROR			0
#define AGERR_STATE			1
#define AGERR_ALLOC_MEM			2
#define AGERR_TOO_SHORT			3
#define AGERR_TOO_LONG			4
#define AGERR_NO_PREVIOUS		5

#define RGERR_MUNGED_AUTO		20
#define RGERR_MISS_BRACKET		25
#define RGERR_EMPTY_ENCL		26
#define RGERR_ILLEGAL_ENCL		27
#define RGERR_TOO_MANY_PAR		28
#define RGERR_NULL_IN_PAR		29
#define RGERR_UNMATCHED			30
#define RGERR_NULL_IN_CRO		31
#define RGERR_CYCLICAL_REF		32
#define RGERR_UNDETERM_REF		33
#define RGERR_UNMATCHED_PAR		34

#define	MATCH		0
#define	MISMATCH	1
#define	EXACTMATCH	2
#define	MAXSYM		256	/* Size of the alphabet (in chars) */
#define	WORD_SIZE	1024	/* in bits */
#define MAXTAG  10

#include	<bitlist.h>

typedef struct tagAGrepInfo {
	int	iErrorCode;
	char	cPat[WORD_SIZE];
	LPSTR	TagStart[MAXTAG];
	LPSTR	TagEnd[MAXTAG];
	BLIST	uMask;
	BLIST	uOvMask;
	BLIST	uLimit;
	BLIST	uTable[MAXSYM];	/* characteristic vector table */
	int	iBitsPerState;
	int	iWordSize;	/* actual word size of BLIST's */
	int	iType;		/* MATCH or MISMATCH */
} AGREPINFO;
#ifdef	WINVER
typedef	AGREPINFO FAR*	LPAGREPINFO;
#else
typedef	AGREPINFO*	LPAGREPINFO;
#endif


int	AGCALL	CompileAGrep( LPCSTR GrepString, int k, BOOL bMatchCase, LPAGREPINFO pGI );
int	AGCALL	AGrep( LPCSTR StringToSearch, LPAGREPINFO pGI );
int	AGCALL	AGrepEmpty( LPAGREPINFO pGI );
int	AGCALL	AGrepSubs(LPSTR lpszPattern, LPSTR lpszDest, int iSize, LPAGREPINFO pGI);



#define	MAXDFA	2*WORD_SIZE

#define CHRBIT	8
#define BITBLK	MAXSYM/CHRBIT

typedef struct tagRGrepInfo {
	int	iErrorCode;
	char	cPat[WORD_SIZE];
	LPSTR	TagStart[MAXTAG];
	LPSTR	TagEnd[MAXTAG];
	int	bMatchCase;
	int	iCircf;
	char	cDFA[MAXDFA];
} RGREPINFO;
#ifdef	WINVER
typedef	RGREPINFO FAR*	LPRGREPINFO;
#else
typedef	RGREPINFO*	LPRGREPINFO;
#endif

int	AGCALL	CompileRGrep( LPCSTR GrepString, BOOL bMatchCase, LPRGREPINFO pGI );
int	AGCALL	RGrep( LPCSTR StringToSearch, LPRGREPINFO pGI );
int	AGCALL	RGrepSubs(LPSTR lpszPattern, LPSTR lpszDest, int iSize, LPRGREPINFO pGI);
void	AGCALL	InitWordCharTable( void );
void	AGCALL	AddWordChar(LPSTR s);
void	AGCALL	RemoveWordChar(LPSTR s);



typedef	union tagXGrepInfo {
	AGREPINFO	aGI;
	RGREPINFO	rGI;
} XGREPINFO;




#ifdef	WINVER
#define	AGREPMSGSTRING	"agrep_Find"

typedef struct tagAGREPREPLACE
{
    DWORD	lStructSize;	/* size of this struct 0x?? */
    HWND	hwndOwner;	/* handle to owner's window */
    HINSTANCE	hInstance;	/* instance handle of.EXE that  */
				/* contains cust. dlg. template */
    DWORD	Flags;		/* one or more of the FR_?? */
    LPSTR	lpstrFindWhat;	/* ptr. to search string    */
    LPSTR	lpstrReplaceWith;/* ptr. to replace string  */
    UINT	wFindWhatLen;	/* size of find buffer      */
    UINT	wReplaceWithLen;/* size of replace buffer   */
    LPARAM	lCustData;	/* data passed to hook fn.  */
    UINT	(CALLBACK* lpfnHook)(HWND, UINT, WPARAM, LPARAM);
				/* ptr. to hook fn. or NULL */
    LPCSTR	lpTemplateName;	/* custom template name     */
} AGREPREPLACE;
typedef AGREPREPLACE FAR *LPAGREPREPLACE;

#define AG_DOWN 			0x00000001
#define AG_WHOLEWORD			0x00000002
#define AG_MATCHCASE			0x00000004
#define AG_FINDNEXT			0x00000008
#define AG_REPLACE			0x00000010
#define AG_REPLACEALL			0x00000020
#define AG_DIALOGTERM			0x00000040
#define AG_SHOWHELP			0x00000080
#define AG_ENABLEHOOK			0x00000100
#define AG_ENABLETEMPLATE		0x00000200
#define AG_NOUPDOWN			0x00000400
#define AG_NOMATCHCASE			0x00000800
#define AG_NOWHOLEWORD			0x00001000
#define AG_ENABLETEMPLATEHANDLE 	0x00002000
#define AG_HIDEUPDOWN			0x00004000
#define AG_HIDEMATCHCASE		0x00008000
#define AG_HIDEWHOLEWORD		0x00010000

HWND    WINAPI GrepFindText(LPAGREPREPLACE);
HWND    WINAPI GrepReplaceText(LPAGREPREPLACE);
#endif	/*WINVER*/



#ifdef __cplusplus
} /* extern "C" */
#endif
#endif	/* __AGREP_H__ */
