/******************************************************************************

                                 TOOLBAR 1.20

                                   DEMOEXE.C

                        (C) Juan M. Aguirregabiria 1993

                            First version  8-13-93
 
                            Last revision  8-15-93

******************************************************************************/

#include "demoexe.h"

/* -----------------------------[ Parameters ]------------------------------ */

#define ID_TIMER     1                          /* Timer */

#define IDM_OPTIONS  101                        /* Menu entries */
#define IDM_ABOUT    102

/* --------------------------[ Global variables ]--------------------------- */

char szParams[LENPARAM] = "20:4";       /* Instance parameters: def. values */

InitDLLType FAR* lpData;                /* DLL data */

HINSTANCE hInst;                        /* Module instance */

/* ---------------------------[ About procedure ]--------------------------- */

#pragma argsused
BOOL CALLBACK AboutProc(HWND hDlg,UINT wMsg,WPARAM wParam,LPARAM lParam)
{
  switch (wMsg) {

    case WM_COMMAND:                    /* Dialog box control message */
      switch (wParam) {
        case IDOK:                      /* Click on OK button */
          EndDialog(hDlg,TRUE);
          return TRUE;
      }
    break;

    case WM_SYSCOMMAND:                 /* Dialog box system menu */
      switch (wParam) {
        case SC_CLOSE:                  /* ALT+F4 or "Close"  */
          EndDialog(hDlg,TRUE);
          return TRUE;
      }
    break;
  }
  return FALSE;
}

/* ------------------------[ Main window procedure ]------------------------ */

LRESULT CALLBACK MainWndProc(HWND hwnd,UINT wMsg,WPARAM wParam,LPARAM lParam)
{
  switch (wMsg) {

    case WM_CREATE:                             /* Append menu entries */
      {                                         /* and gray restore */
        HMENU hMenu;

        hMenu = GetSystemMenu(hwnd,FALSE);
        AppendMenu(hMenu,MF_SEPARATOR,-1,NULL);
        AppendMenu(hMenu,MF_STRING,IDM_OPTIONS,"&Options...");
        AppendMenu(hMenu,MF_STRING,IDM_ABOUT  ,"&About...");
      }
      return 0;

    case WM_QUERYOPEN:                          /* Always minimized */
      return 0;

    case WM_PAINT:
      {
        PAINTSTRUCT ps;
        HDC hdc;
        
        InvalidateRect(hwnd,NULL,TRUE);
        hdc = BeginPaint(hwnd,&ps);
        lpData->lpDrawToolbarDLL(hwnd,hdc,szParams);
        EndPaint(hwnd,&ps);
      }
      return 0;

    case WM_TIMER:                              /* Draw lines */
      {
        HDC hdc;

        hdc = GetDC(hwnd);
        lpData->lpTickToolbarDLL(hwnd,hdc,szParams);
        ReleaseDC(hwnd,hdc);
      }
      return 0;

    case WM_SYSCOMMAND:
      switch (wParam) {

        case IDM_OPTIONS:                       /* Open dialog box */
          RunToolbarDLL(hwnd,szParams,NULL);
          return 0;

        case IDM_ABOUT:
          DialogBox(hInst,MAKEINTRESOURCE(DLG_ABOUT),hwnd,AboutProc);
          return 0;

      }
      break;

  }

  return DefWindowProc(hwnd,wMsg,wParam,lParam);
}

/* -------------------------------[ WinMain ]------------------------------- */

#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,
                   LPSTR lpszCmdLine,int nCmdShow)
{
  static char szName[] = "Toolbar_DemoEXE";
  MSG         msg;
  WNDCLASS    wndclass;
  HWND        hwnd;

  hInst = hInstance;

  if (!hPrevInstance) {         /* Register the main window class */
    wndclass.style         = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc   = MainWndProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 0;
    wndclass.hInstance     = hInstance;
    wndclass.hIcon         = NULL;
    wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW);
    wndclass.hbrBackground = GetStockBrush(BLACK_BRUSH);
    wndclass.lpszMenuName  = NULL;
    wndclass.lpszClassName = szName;
    RegisterClass(&wndclass);
  }
                                                        /* Create window */
  hwnd = CreateWindow(szName,szName,WS_OVERLAPPEDWINDOW,
                      CW_USEDEFAULT, CW_USEDEFAULT,
                      CW_USEDEFAULT, CW_USEDEFAULT, 
                      NULL,NULL,hInst,NULL);
                                                        /* Start the timer */
  if (!SetTimer(hwnd,ID_TIMER,300,NULL)) {              
    MessageBox(hwnd,"Too many clocks or timers!",szName, MB_ICONSTOP | MB_OK);
    return FALSE;
  }
                                                        /* Initialize DLL */
  lpData = InitToolbarDLL(hInstance,szParams);

  ShowWindow(hwnd,SW_SHOWMINNOACTIVE);                  /* Show the icon */
  UpdateWindow(hwnd);

  while (GetMessage(&msg,NULL,0,0)) {                   /* Message loop */
    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

  KillTimer(hwnd,ID_TIMER);                             /* End the timer */

  FreeToolbarDLL(hInstance,szParams);                   /* End DLL */

  return msg.wParam;
}

