/*
 **************************************************************
 * newpaper.c                                                 *
 * 7/28/90 by Jim Button                                      *
 *------------------------------------------------------------*
 * Updates WIN.INI Wallpaper specification to point to the    *
 *   to the next BMP file in the windows subdirectory.        *
 *                                                            *
 *                                                            *
 * This hardly looks like a Windows program. The traditional  *
 *   message loop is not even needed, since it does no input, *
 *   has no output, and terminates almost before it starts!   *
 **************************************************************
 */

#ifndef _WINDOWS
#define _WINDOWS
#endif

#include <windows.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dos.h>
#include <string.h>

static char msg[]       = " By Jim Button ";
static char WallPaper[] = "Wallpaper";

#define MAX_PROF_STR  13


int PASCAL WinMain(  HANDLE hInstance,
                     HANDLE hPrevInstance,
                     LPSTR lpszCmdLine,
                     int nCmdShow)
{
   unsigned int done;
   char oldbmp[MAX_PROF_STR+1];
   char firstbmp[MAX_PROF_STR+1];
   char newbmp[MAX_PROF_STR+1];
   struct  find_t dta;
   struct  stat   buf;
   char *tiled;

   GetProfileString("Desktop", WallPaper, "", oldbmp, MAX_PROF_STR);
   newbmp[0] = '\0';                            /* In case no BMP files exist */

   /*** Get the list of .BMP files ***/
   done = _dos_findfirst("*.BMP", 0, &dta);     /* Find files */
   if (!done) {
      strcpy(firstbmp, dta.name);
      strcpy(newbmp, firstbmp);
   }

   while (!done) {
      if (!strcmpi(dta.name, oldbmp)) {         /* Current one? */
          done = _dos_findnext(&dta);
          strcpy(newbmp, (done ? firstbmp : dta.name));
          break;
      }
      done = _dos_findnext(&dta);
   }

   /*** Update WIN.INI ***/
   WriteProfileString("Desktop", WallPaper, newbmp);

   /*** if filesize < 100K, use "tiled" ***/
   tiled = "0";                                 /* Point to string "0" */
   if (stat(newbmp,&buf) != -1)
       if (buf.st_size < 100000L)
           tiled = "1";                         /* Point to string "1" */
   WriteProfileString("Desktop", "TileWallpaper", tiled);

   return(FALSE);
}



