#ifndef ICONBOX_H
#define ICONBOX_H
#ifdef __cplusplus
extern "C"{
#endif
#include <windows.h>
/*-----------------------------------------------------------------

    ICONBOX.H


    Declarations for Icon Box Control

    (c) 1994 ToolSoft


-----------------------------------------------------------------*/

#define ICONBOX_CLASS "ICONBOX"
#define ICONBOX_DLL "ICONBOX.DLL"

/*-----------------------------------------------------------------

    Control Structures

-----------------------------------------------------------------*/

#define MAXTITLE 50

typedef struct _ICONENTRY
{
    HICON       hicon;                      /*  Handle of entry's icon */
    char        achTitle[MAXTITLE];         /*  Text appearing under icon */
    POINT       ptPos;                      /*  Position of icon */
    BOOL        bSelected;                  /*  Whether item is selected */
    DWORD       dwData;                     /*  User Data */
}ICONENTRY,FAR * LPICONENTRY;
/*-----------------------------------------------------------------

    Control styles

-----------------------------------------------------------------*/

#define IBS_MULTIPLESEL            0x0001L

/*-----------------------------------------------------------------

    Messages for the control

-----------------------------------------------------------------*/
#define IB_BYNAME                   0
#define IB_BYPOSITION               1

#define IB_ADDITEM                  WM_USER+100
#define IB_DRAWITEM                 WM_USER+101
#define IB_DELETEITEM               WM_USER+102
#define IB_FINDITEM                 WM_USER+103
#define IB_GETCOUNT                 WM_USER+104
#define IB_GETSELCOUNT              WM_USER+105
#define IB_GETSELITEMS              WM_USER+106
#define IB_GETITEMDATA              WM_USER+107
#define IB_GETITEM                  WM_USER+108
#define IB_RESETCONTENT             WM_USER+109
#define IB_SETITEMDATA              WM_USER+110
#define IB_SETITEM                  WM_USER+111
#define IB_SETSEL                   WM_USER+112
#define IB_AUTOARRANGE              WM_USER+113
#define IB_ARRANGEICONS             WM_USER+114
#define IB_GETSEL                   WM_USER+115
#define IB_SETCARETINDEX            WM_USER+116
#define IB_GETCARETINDEX            WM_USER+117
#define IB_SETCURSEL                WM_USER+118
#define IB_GETCURSEL                WM_USER+119
#define IB_GETSCROLLORIGIN          WM_USER+120

/*-----------------------------------------------------------------

    Message Macros for the control

-----------------------------------------------------------------*/

#define IbAddItem(hctl,pitem)\
    (int)SendMessage(hctl,IB_ADDITEM,0,(LPARAM)(LPICONENTRY)pitem)
        
#define IbDrawItem(hctl,index,bdraw)\
    (int)SendMessage(hctl,IB_DRAWITEM,(WPARAM)(int)index,(LPARAM)bdraw)      
        
#define IbDeleteItem(hctl,index)\
    (int)SendMessage(hctl,IB_DELETEITEM,(WPARAM)(int)index,0)
        
#define IbFindItem(hctl,flag,pdata)\
    (int)SendMessage(hctl,IB_FINDITEM,(WPARAM)flag,(LPARAM)pdata)       
        
#define IbGetCount(hctl)\
    (int)SendMessage(hctl,IB_GETCOUNT,0,0)
        
#define IbGetSelCount(hctl)\
    (int)SendMessage(hctl,IB_GETSELCOUNT,0,0)    
        
#define IbGetSelItems(hctl,count,lpselected)\
    (int)SendMessage(hctl,IB_GETSELITEMS,(WPARAM)count,(LPARAM)(LPINT)lpselected)  
        
#define IbGetItemData(hctl,index)\
    (DWORD)SendMessage(hctl,IB_GETITEMDATA,(WPARAM)(int)index,0)
        
#define IbGetItem(hctl,index,pitem)\
    (int)SendMessage(hctl,IB_GETITEM,(WPARAM)(int)index,(LPARAM)(LPICONENTRY)pitem)
        
#define IbResetContent(hctl)\
    SendMessage(hctl,IB_RESETCONTENT,0,0)
        
#define IbSetItemData(hctl,index,dwdata)\
    SendMessage(hctl,IB_SETITEMDATA,(WPARAM)(int)index,(LPARAM)(DWORD)dwdata)
        
#define IbSetItem(hctl,index,pitem)\
    SendMessage(hctl,IB_SETITEM,(WPARAM)(int)index,(LPARAM)(LPICONENTRY)pitem)  
        
#define IbSetSel(hctl,index,bsel)\
    SendMessage(hctl,IB_SETSEL,(WPARAM)(int)index,(LPARAM)(BOOL)bsel) 
        
#define IbAutoArrange(hctl,bauto)\
    SendMessage(hctl,IB_AUTOARRANGE,(WPARAM)(BOOL)bauto,0)
        
#define IbArrangeIcons(hctl)\
    SendMessage(hctl,IB_ARRANGEICONS,0,0)
        
#define IbGetSel(hctl,index)\
    (BOOL)SendMessage(hctl,IB_GETSEL,(WPARAM)(int)index,0)


#define IbSetCaretIndex(hctl,index)\
    SendMessage(hctl,IB_SETCARETINDEX,(WPARAM)(int)index,0)

#define IbGetCaretIndex(hctl)\
    (int)SendMessage(hctl,IB_GETCARETINDEX,0,0)

#define IbSetCurSel(hctl,index)\
    SendMessage(hctl,IB_SETCURSEL,(WPARAM)(int)index,0)

#define IbGetCurSel(hctl)\
    (int)SendMessage(hctl,IB_GETCURSEL,0,0)

#define IbGetScrollOrigin(hctl,ppoint)\
    (int)SendMessage(hctl,IB_GETSCROLLORIGIN,0,(LPARAM)(LPPOINT)ppoint)

/*-----------------------------------------------------------------

    WM_COMMAND Notification Codes

-----------------------------------------------------------------*/

#define IBN_SELCHANGE       1
#define IBN_DBLCLK          2
#define IBN_SETFOCUS        3
#define IBN_KILLFOCUS       4
#define IBN_ENTER           5
#define IBN_PICKUP          6

/*  Used to load the DLL */

void _export CALLBACK  IconBoxLoad();
#ifdef __cplusplus
}
#endif

#endif

