/*-------------------------------------------------------------------------


    DTARGET.C

    (c) 1994 ToolSoft

    Drag and Drop Target Window
    
    Example source code

---------------------------------------------------------------------------*/
#include <windows.h>
#include <windowsx.h>
#include "iconbox.h"
#include "dtarget.rh"
#include "dragdrop.h"

/*-------------------------------------------------------------------------

    Global Variables

---------------------------------------------------------------------------*/
HANDLE      hInstance;
/*-------------------------------------------------------------------------

Window Functions

---------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------

    Window Methods

---------------------------------------------------------------------------*/
//--------------------------------------------------------------------------
void OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
//--------------------------------------------------------------------------
//  Responds to Save key press
{
    switch(id){
        case IDC_SAVE :
            MessageBeep(0);
            SetDlgItemText(hwnd,IDC_MGR,"");
            SetDlgItemText(hwnd,IDC_SEVERITY,"");
            SetDlgItemText(hwnd,IDC_AREA,"");
            break;
    }
}
//--------------------------------------------------------------------------
void OnClose(HWND hwnd)
//--------------------------------------------------------------------------
//  Terminate the application
{
    PostQuitMessage(0);
}
//--------------------------------------------------------------------------
int OnDragOver(HWND hwnd,LPINT preply)
//--------------------------------------------------------------------------
/*  Handle being dragged over */
{
    if ( preply) {
        DRAGSTATE d;
        GetDragState(&d);
        //  Only accept the drag over one of these controls
        if (    d.hTarget==GetDlgItem(hwnd,IDC_MGR)
            ||  d.hTarget==GetDlgItem(hwnd,IDC_SEVERITY)
            ||  d.hTarget==GetDlgItem(hwnd,IDC_AREA))
            *preply=YES_STOPSENDING;
        else
            *preply=NO_STOPSENDING;
    }   
    return 0;
}
//--------------------------------------------------------------------------
int OnDrop(HWND hwnd)
//--------------------------------------------------------------------------
/*  Handle drop of an icon */
{
    DRAGSTATE d;
    GetDragState(&d);
    if (    d.hTarget==GetDlgItem(hwnd,IDC_MGR)
        ||  d.hTarget==GetDlgItem(hwnd,IDC_SEVERITY)
        ||  d.hTarget==GetDlgItem(hwnd,IDC_AREA)){
        /* Only allow drop if on one of these controls */    
        DRAGITEM i;
        GetDragItem(1,&i);
        if ( i.aName ){
            char text[256];
            /* Just pull out item's text and put in control */
            GlobalGetAtomName(i.aName,text,256);
            SetWindowText(d.hTarget,text);
        }
    }
    return 0;
}
/*-------------------------------------------------------------------------

    Dialog Procedure

---------------------------------------------------------------------------*/
/*---------------------------------------------------------*/
BOOL  CALLBACK DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
/*---------------------------------------------------------*/
//  Main dialog procedure and despatcher
{
    switch(msg){
        HANDLE_MSG(hwnd, WM_COMMAND, OnCommand);
        HANDLE_MSG(hwnd, WM_CLOSE, OnClose);
        HANDLE_MSG(hwnd, WM_DRAGOVER, OnDragOver);
        HANDLE_MSG(hwnd, WM_DROP, OnDrop);
    }
    return FALSE;
}
/*-------------------------------------------------------------------------

    Main Procedure

---------------------------------------------------------------------------*/
/*---------------------------------------------------------*/
int PASCAL WinMain(HINSTANCE hinstCurrent,HINSTANCE hinstPrevious,
                    LPSTR lpszCmdLine,int nCmdShow)
/*---------------------------------------------------------*/
//  Windows entry point
{
    hInstance=hinstCurrent;
    

//  Create our window as a modeless dialog box
    
    FARPROC pfn=MakeProcInstance((FARPROC)DlgProc,hInstance);
    HWND hwnd=CreateDialog(hInstance,MAKEINTRESOURCE(DTARGET),0,pfn);
    if ( hwnd ){
        
    //  Go into message loop
        
        MSG msg;
        while (GetMessage(&msg,0,0,0)){
            if ( !IsDialogMessage(hwnd,&msg) ){
                TranslateMessage(&msg);
                DispatchMessage(&msg);
            }
        }       
    }
    FreeProcInstance(pfn);
    return 0;
}

