/*-------------------------------------------------------------------------


    DSOURCE.C

    (c) 1994 ToolSoft

    Drag and Drop Source Window
    
    Example source code

---------------------------------------------------------------------------*/
#include <windows.h>
#include <windowsx.h>
#include "iconbox.h"
#include "dsource.rh"
#include "dragdrop.h"

/*-------------------------------------------------------------------------

    Global Variables

---------------------------------------------------------------------------*/
HANDLE      hInstance;
/*-------------------------------------------------------------------------

Window Functions

---------------------------------------------------------------------------*/
struct Entry{
    const char *    name;
    const char *    iconid;
    const char *    desc;
};
/* Info about each icon in the window */
Entry severities[]={ {"Information",IDI_ASTERISK,"Miscellaneous comments about section"},
                     {"Warning",IDI_EXCLAMATION,"Warning of possible problems"},
                     {"Severe",IDI_HAND,"Report of actual problem situation"},
                     {0,0,0 } };
Entry managers[]={  {"Manager 1",MAKEINTRESOURCE(IDI_MGR1),"Mr Little - ex 568"},
                    {"Manager 2",MAKEINTRESOURCE(IDI_MGR2),"Ms Medium - ex 443"},
                    {"Manager 3",MAKEINTRESOURCE(IDI_MGR3),"Mrs Tall - ex 221"},
                     {0,0,0 } };
Entry areas[]={     {"Bread",MAKEINTRESOURCE(IDI_BREAD),"Bread and other Bakery Produce"},
                    {"Wine",MAKEINTRESOURCE(IDI_WINE),"Wine and Spirits"},
                    {"Vegetables",MAKEINTRESOURCE(IDI_VEG),"Vegetables and Fruit"},
                     {0,0,0 } };
//--------------------------------------------------------------------------
void addIcons(HWND hwnd)
//--------------------------------------------------------------------------
// Add the predefined Icons to the icon boxes
{
    HWND harea=GetDlgItem(hwnd,IDC_AREA);
    HWND hseverity=GetDlgItem(hwnd,IDC_SEVERITY);
    HWND hmanager=GetDlgItem(hwnd,IDC_MANAGER);
    
    /* Severities */
    for ( int x=0;severities[x].name ;x++ ) {
        ICONENTRY i;
        i.hicon=LoadIcon(NULL,severities[x].iconid);
        lstrcpy(i.achTitle,severities[x].name);
        i.ptPos.x=8+x*GetSystemMetrics(SM_CXICONSPACING);
        i.ptPos.y=8;
        i.bSelected=0;
        i.dwData=(DWORD)severities[x].desc;
        IbAddItem(hseverity,&i);
    }
    /* Managers */
    for ( x=0;managers[x].name ;x++ ) {
        ICONENTRY i;
        i.hicon=LoadIcon(hInstance,managers[x].iconid);
        lstrcpy(i.achTitle,managers[x].name);
        i.ptPos.x=8+x*GetSystemMetrics(SM_CXICONSPACING);
        i.ptPos.y=8;
        i.bSelected=0;
        i.dwData=(DWORD)managers[x].desc;
        IbAddItem(hmanager,&i);
    }
    /* Areas */
    for ( x=0;areas[x].name ;x++ ) {
        ICONENTRY i;
        i.hicon=LoadIcon(hInstance,areas[x].iconid);
        lstrcpy(i.achTitle,areas[x].name);
        i.ptPos.x=8+x*GetSystemMetrics(SM_CXICONSPACING);
        i.ptPos.y=8;
        i.bSelected=0;
        i.dwData=(DWORD)areas[x].desc;
        IbAddItem(harea,&i);
    }
    IbAutoArrange(harea,TRUE);
    IbAutoArrange(hseverity,TRUE);
    IbAutoArrange(hmanager,TRUE);
}
/*-------------------------------------------------------------------------

    Window Methods

---------------------------------------------------------------------------*/
//--------------------------------------------------------------------------
BOOL OnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
//--------------------------------------------------------------------------
//  Populates the icon box
{
    addIcons(hwnd);
    return TRUE;
}
//--------------------------------------------------------------------------
void OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
//--------------------------------------------------------------------------
//  Responds to menu events and control notifications
{
    if ( id==IDC_AREA || id==IDC_SEVERITY || id==IDC_MANAGER){
        switch ( codeNotify ) {
            case IBN_ENTER: 
            case IBN_DBLCLK: 
            {
                int index=IbGetCurSel(hwndCtl);
                if ( index!=LB_ERR ){
                    ICONENTRY i;
                    IbGetItem(hwndCtl,index,&i);
                    if ( i.dwData )
                        MessageBox(hwnd,(const char *)i.dwData,"DSource",MB_OK);
                }
                break;
            }
            case IBN_PICKUP: 
            {
                /*  Retrieve all selected icons */
                int selcount=IbGetSelCount(hwndCtl);
                if ( selcount ){
                    int * psel=new int[selcount];
                    if ( psel ){
                        POINT ptPos;
                        GetCursorPos(&ptPos);
                        ScreenToClient(hwndCtl,&ptPos);
                        IbGetSelItems(hwndCtl,selcount,psel);
                        for ( int x=0;x<selcount ;x++ ) {
                            ICONENTRY i;
                            /* Calculate pickup position */
                            IbGetItem(hwndCtl,psel[x],&i);
                            POINT p;
                            p.x=-(ptPos.x-i.ptPos.x);
                            p.y=-(ptPos.y-i.ptPos.y);
                            SetDragItem(x+1,i.achTitle,psel[x],p,i.hicon);
                        }
                        delete [] psel;
                        /* Start dragging */
                        StartDragging(hwnd,0);
                    }
                }                   
                break;
            }
        }
    }
}
//--------------------------------------------------------------------------
void OnClose(HWND hwnd)
//--------------------------------------------------------------------------
//  Terminate the application
{
    PostQuitMessage(0);
}
//--------------------------------------------------------------------------
void OnSize(HWND hwnd, UINT state, int cx, int cy)
//--------------------------------------------------------------------------
//  Resize all the icon boxes to fit the new size
{
    HWND harea=GetDlgItem(hwnd,IDC_AREA);
    HWND hseverity=GetDlgItem(hwnd,IDC_SEVERITY);
    HWND hmanager=GetDlgItem(hwnd,IDC_MANAGER);
    MoveWindow(harea,0,0,cx/2,cy/2,TRUE);
    MoveWindow(hseverity,cx/2,0,cx/2,cy/2,TRUE);
    MoveWindow(hmanager,0,cy/2,cx,cy/2,TRUE);
}
/*-------------------------------------------------------------------------

    Dialog Procedure

---------------------------------------------------------------------------*/
/*---------------------------------------------------------*/
BOOL  CALLBACK DlgProc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
/*---------------------------------------------------------*/
//  Main dialog procedure
{
    switch(msg){
        HANDLE_MSG(hwnd, WM_INITDIALOG, OnInitDialog);
        HANDLE_MSG(hwnd, WM_COMMAND, OnCommand);
        HANDLE_MSG(hwnd, WM_CLOSE, OnClose);
        HANDLE_MSG(hwnd, WM_SIZE, OnSize);
    }
    return FALSE;
}
/*-------------------------------------------------------------------------

    Main Procedure

---------------------------------------------------------------------------*/
/*---------------------------------------------------------*/
int PASCAL WinMain(HINSTANCE hinstCurrent,HINSTANCE hinstPrevious,
                    LPSTR lpszCmdLine,int nCmdShow)
/*---------------------------------------------------------*/
//  Windows Entry Point
{
    hInstance=hinstCurrent;

    
//  Load the control classes

    IconBoxLoad();

//  Create our window (a modeless dialog)
    
    FARPROC pfn=MakeProcInstance((FARPROC)DlgProc,hInstance);
    HWND hwnd=CreateDialog(hInstance,MAKEINTRESOURCE(DSOURCE),0,pfn);
    if ( hwnd ){
        
    //  Go into message loop
        
        MSG msg;
        while (GetMessage(&msg,0,0,0)){
            if ( !IsDialogMessage(hwnd,&msg) ){
                TranslateMessage(&msg);
                DispatchMessage(&msg);
            }
        }       
    }
    FreeProcInstance(pfn);
    return 0;
}

