#ifndef DRAGDROP_H
#define DRAGDROP_H
#ifdef __cplusplus
extern "C"{
#endif
#include <windows.h>
/*-----------------------------------------------------------------

    DRAGDROP.H


    Dragging Functions

    (c) 1994 ToolSoft


-----------------------------------------------------------------*/
/*-----------------------------------------------------------------

    Control Structures

-----------------------------------------------------------------*/

typedef enum _DRAGREPLY 
{ NO_STOPSENDING=0,NO_KEEPSENDING,YES_STOPSENDING,YES_KEEPSENDING } 
DRAGREPLY;
                          
typedef struct _DRAGSTATE           /* Overall State of the drag */
{
    HWND        hSource;            /* Source window handle */
    ATOM        aSource;            /* Source name (Global Atom) */ 
    HWND        hTopTarget;         /* Top-Level Target Window */
    HWND        hTarget;            /* Window under the drag */
    DRAGREPLY   eLastReply;         /* Last reply to WM_DRAGOVER */
    int         iNumItems;          /* Number of items being dragged */
                                    /* 0 - 100 */
    POINT       ptDrop;             /* Position of drag/drop in screen coords */                                
}DRAGSTATE, FAR * LPDRAGSTATE;

typedef struct _DRAGITEM            /* One item being dragged */
{
    ATOM        aName;              /* Item name (Global Atom) */
    DWORD       dwUser;             /* User data */
    POINT       ptPickup;           /* Pos relative to pickup */
    HICON       hIcon;              /* Icon used in drag */
}DRAGITEM, FAR * LPDRAGITEM;

/*-----------------------------------------------------------------

    Drag Messages

-----------------------------------------------------------------*/
    
#define WM_DRAGOVER         WM_USER+500
#define WM_DROP             WM_USER+501

/*-----------------------------------------------------------------

    Drag Functions

-----------------------------------------------------------------*/

/* Functions for Source of Drag  */

HWND _export CALLBACK StartDragging(
                        HWND hSource,       /* source window for drag */
                        LPSTR lpstrSource   /* source name */
                        );

BOOL _export CALLBACK SetDragItem(
                        int iIndex,         /* index of item to set */
                                            /* 1 - 100 */
                        LPSTR lpstrName,    /* item name */
                        DWORD dwUser,       /* user data */
                        POINT ptPickup,     /* offset from pickup */
                        HICON hIcon         /* item icon */
                        );
                        

/* Functions for Target of Drag */

void _export CALLBACK GetDragState(
                        LPDRAGSTATE lpState /* structure to receive state */    
                        );
    
BOOL _export CALLBACK GetDragItem(
                        int iIndex,         /* index of item to access */
                                            /* 1 - 100 */
                        LPDRAGITEM lpItem   /* structure to receive item */
                        );
                        

/*  Macros to give method despatching (see windowsx.h) */

/* void Cls_DragOver(HWND hwnd, LPINT preply) */
#define HANDLE_WM_DRAGOVER(hwnd, wParam, lParam, fn) \
    (LRESULT)(fn)((hwnd), (LPINT)(lParam))

/* void Cls_Drop(HWND hwnd) */
#define HANDLE_WM_DROP(hwnd, wParam, lParam, fn) \
    (LRESULT)(fn)((hwnd))
        
#ifdef __cplusplus
}
#endif
#endif
