unit Resource;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls;

type
  TResourceForm = class(TForm)
    Timer1: TTimer;
    Panel1: TPanel;
    Date: TLabel;
    Time: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    User: TLabel;
    GDI: TLabel;
    Sys: TLabel;
    Mem: TLabel;
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ResourceForm: TResourceForm;

implementation

uses Main;

{$R *.DFM}

procedure TResourceForm.Timer1Timer(Sender: TObject);
const
  MonthName : array[1..12] of String[3] = ('Jan','Feb','Mar','Apr','May','Jun',
                                           'Jul','Aug','Sep','Oct','Nov','Dec');
var
  MyNow   : TDateTime;
  dy, dm,
  dd, dw  : Word;
begin
  MyNow := Now;

  DecodeDate(MyNow,dy,dm,dd);
  dw := DayOfWeek(MyNow);

  User.Caption := Format('%.2d%%',[GetFreeSystemResources(GFSR_UserResources)]);
  GDI.Caption := Format('%.2d%%',[GetFreeSystemResources(GFSR_GDIResources)]);
  Sys.Caption := Format('%.2d%%',[GetFreeSystemResources(GFSR_SystemResources)]);
  Mem.Caption := Format('%dk',[GetFreeSpace(0) div 1024]);
  Date.Caption := Format('%.2d-%s-%.2d',[dd,MonthName[dm],dy mod 100]);
  Time.Caption := TimeToStr(MyNow);
end;

procedure TResourceForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  MainForm.Toggle1.Checked := False;
end;

end.
