unit Childwin;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
  Tablist, ExtCtrls, UnZipFrm, UnZip20, SysUtils, Menus, Zip20,
  Dialogs, ZipFrm, Zipping;

type
  TMDIChild = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    TabList1: TTabList;
    Action: TMainMenu;
    Special1: TMenuItem;
    SelectAllFiles1: TMenuItem;
    Select1: TMenuItem;
    UnselectAllFiles1: TMenuItem;
    UnZip: TUnZip20;
    Zip: TZip20;
    Action1: TMenuItem;
    Fix1: TMenuItem;
    N1: TMenuItem;
    UnZip1: TMenuItem;
    View1: TMenuItem;
    N2: TMenuItem;
    AddToZip1: TMenuItem;
    Deletefiles1: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure SelectAllFiles1Click(Sender: TObject);
    procedure UnselectAllFiles1Click(Sender: TObject);
    procedure DeleteFiles1Click(Sender: TObject);
    procedure Fix1Click(Sender: TObject);
    procedure View1Click(Sender: TObject);
    procedure Select1Click(Sender: TObject);
    procedure UnZip1Click(Sender: TObject);
    procedure UnZipOpenFile(Sender: TObject; FileName: TFileName;
      OK: Boolean);
    procedure UnZipExpanding(Sender: TObject; FileName: TFileName;
      Percentage: Integer);
    procedure UnZipCloseFile(Sender: TObject; FileName: TFileName;
      OK: Boolean);
    procedure AddFilesToZip1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ZipZipping(Sender: TObject; FileName: TFileName;
      Size: Integer);
    procedure ZipFileZipped(Sender: TObject; FileName: TFileName;
      Compression: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure LogZip;
  end;

  TFilePath = class(TObject)
    FilePath: string;
  public
    constructor Create(S: String);
    function GetFilePath: string;
  end;
implementation

{$R *.DFM}

constructor TFilePath.Create(S: string);
begin
 inherited Create;
 FilePath := S;
end;

function TFilePath.GetFilePath: string;
begin
 result := FilePath;
end;

procedure TMDIChild.FormShow(Sender: TObject);
begin
  TabList1.TabStops[1] := 150;
  TabList1.TabStops[2] := 220;
  TabList1.TabStops[3] := 260;
  TabList1.TabStops[4] := 330;
  TabList1.TabStops[5] := 400;

end;

procedure TMDIChild.LogZip;
var
 count: integer;
 ZipItem: tVCLZipItem;
begin
  Zip.FileName := Caption;
  Screen.Cursor := crHourGlass;
  try
  with UnZip do
  begin
   if Active = true then
   Active := false;
   TabList1.Items.Clear;
   FileName := Caption;
   try
   Active := true;
   if Active = true then
    for count := 0 to FilesInZip-1 do
    begin
    GetZipItem(count,@ZipItem);
    if not ZipItem.IsDir then
    TabList1.Items.AddObject(ZipItem.Name+#9+IntToStr(ZipItem.OriginalSize)+
     #9+IntToStr(ZipItem.Rate)+'%'+#9+
     Format('%-2.2d/%-2.2d/%-2.2d',[ZipItem.Day,ZipItem.Month,ZipItem.Year])+
     #9+Format('%-2.2d:%-2.2d',[ZipItem.Hour,ZipItem.Min])+
     #9+ZipItem.Dir,
     TFilePath.Create(ZipItem.Dir+ZipItem.Name))
     else
    TabList1.Items.AddObject('Directory'+#9#9#9+
    Format('%-2.2d/%-2.2d/%-2.2d',[ZipItem.Day,ZipItem.Month,
    ZipItem.Year])+
    #9+Format('%-2.2d:%-2.2d',[ZipItem.Hour,ZipItem.Min])+
    #9+ZipItem.Dir,
     TFilePath.Create(ZipItem.Dir+ZipItem.Name));
    end;
   finally
   Panel2.Caption := IntToStr(FilesInZip)+' Files';
   end;
  end;
  finally
   Screen.Cursor := crDefault;
  end;
end;

procedure TMDIChild.SelectAllFiles1Click(Sender: TObject);
var
 count: integer;
begin
  with TabList1 do
  begin
    visible := false;
    try
    for count := 0 to Items.count-1 do
     Selected[count] := true;
    finally
    visible := true;
    end;
  end;
end;

procedure TMDIChild.UnselectAllFiles1Click(Sender: TObject);
var
 count: integer;
begin
  with TabList1 do
  begin
    visible := false;
    try
    for count := 0 to Items.count-1 do
     Selected[count] := false;
    finally
    visible := true;
    end;
  end;
end;

procedure TMDIChild.DeleteFiles1Click(Sender: TObject);
var
 count: integer;
begin
 if MessageDlg('Delete Selected Items',mtWarning,mbOkCancel,
  0) <> mrOk then
  Exit;
 Screen.Cursor := crHourGlass;
 try
 Zip.FilesToZip.Clear;
 for Count := 0 to TabList1.Items.Count-1 do
 begin
  if TabList1.Selected[Count] = true then
  Zip.FilesToZip.Add(TFilePath(TabList1.Items.Objects[Count]).GetFilePath);
 end;
 Zip.DeleteFiles;
 LogZip;
 finally
 Screen.Cursor := crDefault;
 end;
end;

procedure TMDIChild.Fix1Click(Sender: TObject);
var
 ret: integer;
MessageStr: String;
begin
 ret := Zip.RepareZip;
end;

procedure TMDIChild.View1Click(Sender: TObject);
begin
if TabList1.itemindex <> -1 then
with TabList1 do
  UnZip.ViewFileFromZip(TFilePath(items.objects[itemindex]).
  GetFilePath, true);
end;

procedure TMDIChild.Select1Click(Sender: TObject);
begin
 if TabList1.ItemIndex <> -1 then
  TabList1.Selected[TabList1.itemindex] := true;
end;

procedure TMDIChild.UnZip1Click(Sender: TObject);
var
 count: integer;
begin
  UnZip.FilesToExtract.Clear;
 for Count := 0 to TabList1.Items.Count-1 do
 begin
  if TabList1.Selected[Count] = true then
  UnZip.FilesToExtract.Add(
    TFilePath(TabList1.Items.Objects[Count]).GetFilePath);
 end;
 UnZipForm.Show;
 try
 UnZip.ExtractFiles;
 finally
 UnZipForm.Hide
 end;
end;

procedure TMDIChild.UnZipOpenFile(Sender: TObject; FileName: TFileName;
  OK: Boolean);
begin
  UnZipForm.FileNameLabel.Caption := FileName;
  UnZipForm.Gauge1.Progress := 0;
  UnZipForm.UpDate;
end;

procedure TMDIChild.UnZipExpanding(Sender: TObject; FileName: TFileName;
  Percentage: Integer);
begin
  UnZipForm.FileNameLabel.Caption := FileName;
  UnZipForm.Gauge1.Progress := Percentage;
  UnZipForm.UpDate;
end;

procedure TMDIChild.UnZipCloseFile(Sender: TObject; FileName: TFileName;
  OK: Boolean);
begin
  UnZipForm.FileNameLabel.Caption := FileName;
  UnZipForm.Gauge1.Progress := 100;
  UnZipForm.UpDate;
end;

procedure TMDIChild.AddFilesToZip1Click(Sender: TObject);
begin
  ZipForm.ShowModal;
  if ZipForm.ModalResult = mrOk then
  begin
   Zip.FilesToZip.clear;
   Zip.FilesToZip.AddStrings(ZipForm.ListBox1.Items);
   ZippingForm.Show;
   try
   Zip.AddFiles;
   finally
   ZippingForm.Hide;
   LogZip;
   end;
  end;
end;

procedure TMDIChild.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Action := caFree;
end;

procedure TMDIChild.ZipZipping(Sender: TObject; FileName: TFileName;
  Size: Integer);
begin
 with ZippingForm do
 begin
  CurrentFile.Caption := FileName;
  Processed.Caption := IntToStr(Size)+' KB';
  Update;
 end;
end;

procedure TMDIChild.ZipFileZipped(Sender: TObject; FileName: TFileName;
  Compression: Integer);
begin
 with ZippingForm do
 begin
  CompressedFile.Caption := FileName;
  CompressionRate.Caption := IntToStr(Compression)+'%';
  Update;  
 end;

end;

end.
