(***************************************************************************************************************************)
(*                                                                                                                         *)
(*		Zip Studio 2.57 COPYRIGHT 1993-1995 Hexanet (hnet@dialup.francenet.fr)                                     *)
(*    Source File: ZIP.PAS                                                                                                 *)
(*    Description: Pascal Source file to encapsulate the ZDLL20A.DLL file to provide the functionality to                  *)
(*                 Borland Pascal developers.  This version was written for BP v7.0 but contains nothing that              *)
(*                 would prohibit its adaption to earlier versions of Borland's Pascal for Windows compilers.              *)
(*    Date:        Mon Nov 7 21:21:31 1994                                                                                 *)
(*    Author:      Brad Stowers, CIS: 72733,3374                                                                           *)
(*                               Internet: bstowers@cybernetics.net                                                        *)
(*                                                                                                                         *)
(***************************************************************************************************************************)
(*                                                                                                                         *)
(*		To Zip, Put ZDLL20A.DLL and ZDLL20B.DLL in your applications directory and add this unit to your USES clause.        *)
(*    By using this unit, you are NOT required to use LoadLibrary and FreeLibrary.  Simply call these procedures and       *)
(*    functions as you would any other unit.                                                                               *)
(***************************************************************************************************************************)

unit Zip;

interface

uses WinTypes, Messages;

(***************************************************************************************************************************)
(* The ZIP.INC file contains constants that will be useful when calling these functions.  By including it here, you don't  *)
(* have to include it in your own program.  Do have a look at it so that you will know what is available.                  *)
(***************************************************************************************************************************)

{$I ZIP.INC }

(* Initialization function *)
  procedure ZipInit(YourName, Password: pChar);          { required.  If you aren't a registered user, set         }
                                                         { YourName to 'TEST' and Password to ''                   }

(* Main functions *)
  { Changed for version 2.0 }
  function  AddFileToZip(ZipFile, Mask: pChar;           { Zip a file }
                         OverwriteMode: integer;
                         StorePath, Recurse: WordBool;
                         ParentWnd: hWnd;
                         Password: pChar): integer;      { Password is new.  If specified, it will be used to }
                                                         { encrypt and will be required to Unzip the file.    }
                                                         { It can be up to 80 chars in length.                }

  function  ZipDeleteFiles(ZipFile, Files: pChar;
                           ParentWnd: hWnd): integer;    { Delete files in a Zip }
  function  ZipRepare(ZipFile: pChar;
                      ParentWnd: hWnd): integer;         { Recreate the Zip file }
  function  ZipSetComment(ZipFile, Comment: pChar;
                          ParentWnd: hWnd): integer;     { Set the Zip Comment }
  { New for version 2.0 }
  procedure ZipCancel(Cancel: WordBool);                  { Cancel the current Zip process if Cancel is TRUE }
  { New for version 2.0 }
  function  ZipSplit(ParentWnd: hWnd;
                     ZipName, DestDir: pChar;
                     FirstSize, NextSize: LongInt;
                     DiskettePause: WordBool;
                     Title, Msg: pChar): integer;        { Split a Zip file into multiple files (10 max). }

(* Helpers *)
  function  ZipSetLanguage(ZipLanguage: word): WordBool;  { Set the Language }
  function  ZipGetReplaceFlag: integer;                  { Return the current overwrite mode }
  function  ZipSetReplaceText(DialogTitle,               { Set the replace dialog box labels, used     }
                              DialogText,                { with the LANGUAGE_NONE mode and the         }
                              YesBtn,                    { ZN_REPLACE notification message.. ** NEW! **}
                              NoBtn,
                              AlwaysBtn,
                              NeverBtn: pChar): WordBool;
  { New for version 2.0 }
  function ZipSetMode(Mode: integer): WordBool;           { Set mode of compression. }


implementation

  procedure ZipInit;                                      external 'ZDLL20A';
  function  AddFileToZip;                                 external 'ZDLL20A';
  function  ZipDeleteFiles;                               external 'ZDLL20A';
  function  ZipRepare;                                    external 'ZDLL20A';
  function  ZipSetComment;                                external 'ZDLL20A';
  function  ZipSetLanguage;                               external 'ZDLL20A';
  function  ZipGetReplaceFlag;                            external 'ZDLL20A';
  procedure ZipCancel;                                    external 'ZDLL20A';
  function  ZipSetMode;                                   external 'ZDLL20A';
  function  ZipSplit;                                     external 'ZDLL20A';
  function  ZipSetReplaceText;                            external 'ZDLL20B';
end.
