const
(* Errors constants *)
  ZERROR_OK		      = 0;	{ No error }
  ZERROR_WARNING		= 1; 	{ Just a warning (not an error) }
  ZERROR_DESTFILE		= 2;  { Destfile ( *.ZIP ) error }
  ZERROR_INTERNAL 	= 3;  { Internal error }
  ZERROR_FORMAT		  = 4;  { Not a Zip file }
  ZERROR_NOMEM		  = 5;  { Not enough memory }
  ZERROR_NOFILE		  = 6;  { Nothing to do ( can be just a warning ) }
  ZERROR_NODLL		  = 7;  { Can' t find required DLLs }
  ZERROR_COMMENT		= 8;  { Comment missing or NULL }

(* Overwrite mode *)
  OVERWRITE_ALWAYS	= 0;  { Always overwrite ( always zip files ) (default) }
  OVERWRITE_NEVER		= 1;  { Never overwrite }
  OVERWRITE_PROMPT	= 2;  { Ask the user }
  OVERWRITE_UPDATE	= 3;  { Overwrite if external file is newer }


(* Language mode ( for the replace dialog box ) *)
  LANGUAGE_FRENCH    = 0;	{ French mode }
  LANGUAGE_ENGLISH   = 1;	{ US Mode ( default ) }
  LANGUAGE_GERMAN    = 2;  { German mode ** NEW! ** }
  LANGUAGE_NONE      = 3;  { No language (used with ZN_REPLACE) ** NEW! ** }

(* More easy to use with AddFileToZip *)
  STOREPATH_NO		   = FALSE; { Don' t store paths }
  STOREPATH_YES		   = TRUE;  { Store paths }
  RECURSE_NO		     = FALSE; { Don' t recurse sub dirs }
  RECURSE_YES		     = TRUE;  { Recurse sub dirs }


(* Notification messages from AddFileToZip *)
  ZN_ZIPPING		     = WM_USER + 46;  { Zipping a file, WP = compressed size in K, LP = current file name }
  ZN_FILEZIPPED      = WM_USER + 45;  { File is zipped, WP = compress rate, LP = file name }
  ZN_WRITING		     = WM_USER + 48;  { Replace the Zip file, LP = zip file name }
  ZN_DELETING	       = WM_USER + 47;  { Delete a file , LP = current file name }
  ZN_REPARING		     = WM_USER + 49;  { Repare a Zip file, WP = (int)state }
                                      {   Step =  1 : Read / Write ,  LP = current file name }
                                      {   Step = 3 : Checking zip file, LP = zip file name   }
  ZN_COMPUTE		     = WM_USER + 52;  { Before zip read, WP = zip files ( over 500, computing can be very long ) }
  ZN_REPLACE	 	     = WM_USER + 53;  { The replace dialog box is opened ** NEW! ** }


(* New for version 2.0 *)

(* Storage modes *)
  ZMODE_NORMAL       = 0; { balance of speed and compression }
  ZMODE_FAST         = 1; { least compression, fastest speed }
  ZMODE_SLOW         = 2; { best compression, slowest speed  }
  ZMODE_STORE        = 3; { no compression                   }

(* ZipSplit function results.  The exact definitions of these are unavailable to me at this time, *)
(* but they seem fairly obvious.                                                                  *)
  SPLIT_OK           = 0;
  SPLIT_NOFILE       = 1;
  SPLIT_NOMEM        = 2;
  SPLIT_IOERROR      = 3;
  SPLIT_TOOBIG       = 4; { more than 10 parts }
  SPLIT_ACCESSDENIED = 5;
  SPLIT_USERABORT    = 6;
  SPLIT_FILETOOSMALL = 7; { the ZIP file was small enough to not reqire splitting }

(* Notification messages from ZipSplit *)
  ZN_SPLITTING       = WM_USER + 61; { Splitting in progress, wp = total size (kb), lp = piece name        }
  ZN_SPLITTED        = WM_USER + 62; { A zip part is done, wp = part number,  lp = total size ( in bytes ) }
