(***************************************************************************************************************************)
(*                                                                                                                         *)
(*		Zip Studio 2.57 COPYRIGHT 1993-1995 Hexanet (hnet@dialup.francenet.fr)                                     *)
(*    Source File: UNZIP.PAS                                                                                               *)
(*    Description: Pascal Source file to encapsulate the UZDLL20.DLL file to provide the functionality to                  *)
(*                 Borland Pascal developers.  This version was written for BP v7.0 but contains nothing that              *)
(*                 would prohibit its adaption to earlier versions of Borland's Pascal for Windows compilesr.              *)
(*    Date:        Mon Nov 7 21:45:05 1994                                                                                 *)
(*    Author:      Brad Stowers, CIS: 72733,3374                                                                           *)
(*                               Internet: bstowers@cybernetics.net                                                        *)
(*                                                                                                                         *)
(***************************************************************************************************************************)
(*                                                                                                                         *)
(*		To Zip, Put UZDLL20.DLL in your applications directory and add this unit to your USES clause.                        *)
(*    By using this unit, you are NOT required to use LoadLibrary and FreeLibrary.  Simply call these parameters as you    *)
(*    would any other unit.                                                                                                *)
(***************************************************************************************************************************)

unit UnZip;

interface

uses WinTypes, Messages;

(***************************************************************************************************************************)
(* The UNZIP.INC file contains constants that will be useful when calling these functions.  By including it here, you      *)
(* don't have to include it in your own program.  Do have a look at it so that you will know what is available.            *)
(***************************************************************************************************************************)

{$I UNZIP.INC}

(* Initialization function *)
  procedure UnzipInit(YourName, Password: pChar);              { Required.  If you aren't a registered user, set         }
                                                               { YourName to 'TEST' and Password to ''                   }

(* Interface setting functions *)
  function  UnzipSetMsgBoxTitle(NewTitle: pChar): WordBool;	    { Set the replace dialog box title ( default = "Replace...") }
  procedure UnzipSetLanguage(Language: word);                   { Set the language for the replace dialog box }
  function  UnzipSetReceivingWindow(Wnd: hWnd): WordBool;        { Set the window for notification messages }
  procedure UnzipSetBackgroundMode(BackGroundMode: WordBool);    { if TRUE, activate the multitask mode ( default ) }
  function  UnzipSetReplaceText(DialogTitle,                    { Set the replace dialog box labels, used     }
                                DialogText,                     { with the LANGUAGE_NONE mode and the         }
                                YesBtn,                         { ZN_REPLACE notification message..           }
                                NoBtn,
                                AlwaysBtn,
                                NeverBtn: pChar): WordBool;

(* Information functions ( Zip ) *)
  function  IsFileInZip(ZIPFileName,
                        FileName: pChar): WordBool;              { Return TRUE if the file (wildcards ok) is in the ZIP file }
  function  CountFileInZip(FileName: pChar): integer;           { Return number of files in this Zip File }
  function  GetFileNameFromZip(FileName: pChar;
                               FileNumber: integer): pChar;     { Return the name of the iFileNumber file in this Zip File }
  function  GetZFileOriginalSize(ZIPFilename,
                                 FileName: pChar): LongInt;     { Return the not compressed size of szFileName in octets. }
  function  GetZFileCompressedSize(ZIPFileName,
                                   FileName: pChar): LongInt;   { Return the compressed size of szFileName in octets. }
  function  GetZFileDate(ZIPFileName, FileName: pChar): pChar;  { Return the date of a file in a Zip }
  function  GetZFileTime(ZIPFileName, FileName: pChar): pChar;  { Return the time of a file in a Zip }
  function  GetZCompressedMethod(ZIPFileName,
                                 FileName: pChar): Word;        { Return the Zip method for a file ( ZMETHOD_* ) }
  { Changed for version 2.0 }
  function  IsThisFileAZipFile(FileName: pChar;
                               QuickTest: WordBool): WordBool;    { Return TRUE if this file seems to be a zip file }
  function  IsFileUnzipable(FileName: pChar): WordBool;          { Return TRUE if this file name can be reproduce under DOS }
  function  GetZipCommentLength(FileName: pChar): word;         { Return the size of the zip file comment in octets }
  function  GetZipComment(FileName, Buffer: pChar): WordBool;    { Put the zip comment in buffer }
  { New for version 2.0 }
  function  GetZFileIsEncrypted(ZIPFileName,
                                FileName: pChar): WordBool;      { Checks if <FileName> in <ZIPFileName> }
                                                                { ZIP file is encrypted.                }
  { New for version 2.0 }
  function  GetZFileIsDir(ZIPFileName,                          { Is <FileName> a directory entry in <ZIPFileName>? }
                          FileName: pChar): WordBool;
  { New for version 2.0 }
  function  GetZFileFullInfos(ZIPFileName, FileName,            { Fill <Result> with info for <FileName> in <ZIPFileName> }
                              Result: pChar): WordBool;          { Result must be at least 456 bytes.  ';' is used to      }
                                                                { separate these values:  filename, original size,        }
                                                                { compressed size, file date, file time, and compression  }
                                                                { method.  EX: 'MYFILE.ET;1254;984;01/21/94;04:12pm;8'    }
                                                                { Returns false if couldn't retrieve data.                }
  { New for version 2.0 }
  function  GetZList(ZIPFileName: pChar;
                     ListWnd: hWnd;
                     From: word;
                     SortMode: integer;
                     BackGnd: WordBool): integer;                { Retrieve filenames from ZIP file. }
  { New for version 2.0 }
  function  UnzipSortZList(ListWnd: hWnd;
                           SortMode: integer;
                           BackGnd: WordBool): WordBool;          { Resort the list. }


(* Information functions ( General ) *)
  function  DoesFileExist(FileName: pChar): WordBool;            { True if this file exists }
  function  GetShortFileName(FileName: pChar): pChar;           { Return filename without any path }
  function  GetPathFromFileName(FileName: pChar): pChar;        { Return the path without the file name }
  function  IsFileNameInFilter(FileName, Mask: pChar): WordBool; { Return TRUE if filename is in specified filter }

(* Extraction functions *)
  function  ExtractZipFiles(FileName, Mask,DestDir: pChar;
                           Overwrite: word;
                           CreateDir: WordBool): word;              { Go get them }
  function  GetQueryFlag: integer;                              { Return the overwrite mode the user asked for }
  { New for version 2.0 }
  procedure UnzipCancel(Cancel: WordBool);                       { If <Cancel> is TRUE, the Unzip or View process will  }
                                                                { stop as soon as possible.                            }
                                                                { VERY IMPORTANT:  This function must be called with   }
                                                                { <Cancel> set to FALSE before any Unzip function call }
                                                                { (except for the inforamation functions).             }
  { New for version 2.0 }
  function  GetZipItem(ListWnd: hWnd;
                       Index: integer;
                       Item: pZipItem): WordBool;                { pZipItem declared in UNZIP.INC }
  { New for version 2.0 }
  function  ZipJoin(ParentWnd: hWnd;
                    Name, DestDir: pChar;
                    SendMsg: WordBool;
                    Title, Msg: pChar): integer;                { Rebuild split files into ZIP file }

(* View function *)
  function  ViewFileFromZip(ZipFile, Mask: pChar;
                           TextOnly: WordBool): WordBool;         { View one or several files in a Zip }

(* Encryption functions *)
  { New for version 2.0 }
  function  UnzipSetPassword(Password: pChar): WordBool;         { To set password before Extract or View call }
  { New for version 2.0 }
  procedure SetAskPassword(Ask: WordBool);                       { If <Ask> is FALSE, Zip Studio won' t ask the user for }
                                                                { a password. (Default is TRUE).                        }


implementation

  procedure UnzipInit;                                         external 'UZDLL20';
  function  UnzipSetMsgBoxTitle;                               external 'UZDLL20';
  procedure UnzipSetLanguage;                                  external 'UZDLL20';
  function  UnzipSetReceivingWindow;                           external 'UZDLL20';
  procedure UnzipSetBackgroundMode;                            external 'UZDLL20';
  function  UnzipSetReplaceText;                               external 'UZDLL20';
  function  IsFileInZip;                                       external 'UZDLL20';
  function  CountFileInZip;                                    external 'UZDLL20';
  function  GetFileNameFromZip;                                external 'UZDLL20';
  function  GetZFileOriginalSize;                              external 'UZDLL20';
  function  GetZFileCompressedSize;                            external 'UZDLL20';
  function  GetZFileDate;                                      external 'UZDLL20';
  function  GetZFileTime;                                      external 'UZDLL20';
  function  GetZCompressedMethod;                              external 'UZDLL20';
  function  IsThisFileAZipFile;                                external 'UZDLL20';
  function  IsFileUnzipable;                                   external 'UZDLL20';
  function  GetZipCommentLength;                               external 'UZDLL20';
  function  GetZipComment;                                     external 'UZDLL20';
  function  DoesFileExist;                                     external 'UZDLL20';
  function  GetShortFileName;                                  external 'UZDLL20';
  function  GetPathFromFileName;                               external 'UZDLL20';
  function  IsFileNameInFilter;                                external 'UZDLL20';
  function  ExtractZipFiles;                                   external 'UZDLL20';
  function  GetQueryFlag;                                      external 'UZDLL20';
  function  ViewFileFromZip;                                   external 'UZDLL20';
  function  GetZFileIsEncrypted;                               external 'UZDLL20';
  procedure UnzipCancel;                                       external 'UZDLL20';
  function  GetZList;                                          external 'UZDLL20';
  function  UnzipSortZList;                                    external 'UZDLL20';
  function  GetZipItem;                                        external 'UZDLL20';
  function  ZipJoin;                                           external 'UZDLL20';
  function  UnzipSetPassword;                                  external 'UZDLL20';
  procedure SetAskPassword;                                    external 'UZDLL20';
  function  GetZFileIsDir;                                     external 'UZDLL20';
  function  GetZFileFullInfos;                                 external 'UZDLL20';
end.
