const
(* Language mode ( for the replace dialog box ) *)
  LANGUAGE_FRENCH         = 0;	{ French mode                        }
  LANGUAGE_ENGLISH        = 1;	{ US Mode ( default )                }
  LANGUAGE_GERMAN         = 2;  { German mode                        }
  LANGUAGE_NONE           = 3;  { No language (used with ZN_REPLACE) }

(* Zip method constants *)
  ZMETHOD_STORED          = 0;
  ZMETHOD_SHRUNK          = 1;
  ZMETHOD_REDUCE1         = 2;
  ZMETHOD_REDUCE2	        = 3;
  ZMETHOD_REDUCE3         = 4;
  ZMETHOD_REDUCE4         = 5;
  ZMETHOD_IMPLODE         = 6;
  ZMETHOD_TOKEN           = 7;
  ZMETHOD_DEFLATE         = 8;
  ZMETHOD_UNKNOWN         = 9;
  ZMETHOD_ERROR           = 10;

(* Extraction function result constants *)
  ZEXTRACT_OK			        = 0;
  ZEXTRACT_INTERNALERROR  = 1;
  ZEXTRACT_FILENOTFOUND 	= 2;
  ZEXTRACT_CORRUPTED    	= 3;
  ZEXTRACT_EMPTY			    = 4;
  ZEXTRACT_ERRORINZIPFILE	= 5;
  ZEXTRACT_NOMEM			    = 6;
  ZEXTRACT_DISKFULL		    = 8;
  ZEXTRACT_WARNING		    = 10;


(* Helper constants *)
  OVERWRITE_FALSE         = 0;
  OVERWRITE_TRUE          = 1;
  OVERWRITE_QUERY         = 2;
  CREATEDIR_FALSE         = 0;
  CREATEDIR_TRUE          = 1;

(* Notification messages for UNZIP and VIEW *)
  ZN_OPENFILE             = WM_USER + 38;		{ Open a file, WP = TRUE if Ok, LP = filename             }
  ZN_EXPANDING            = WM_USER + 39;		{ Unzipping a file, WP = file current rate, LP = filename }
  ZN_CLOSEFILE            = WM_USER + 40;		{ Close a file, WP = TRUE if Ok, LP = filename            }
  ZN_REPLACE              = WM_USER + 53;   { The replace dialog box is opened                        }

  ZN_TEST                 = WM_USER + 69;
(* New for version 2.0 *)

(* GetZList sort methods *)
  ZSORT_BYFULLNAME        = 0;
  ZSORT_BYNAME            = 1;
  ZSORT_BYDIR             = 2;
  ZSORT_BYDATE            = 3;
  ZSORT_BYSIZE            = 4;
  ZSORT_BYRATE            = 5;
  ZSORT_NONE              = 6;

(* ZipJoin return values *)
  JOIN_OK                 = 0;
  JOIN_NOFILE             = 1;
  JOIN_NOMEM              = 2;
  JOIN_IOERROR            = 3;
  JOIN_ACCESSDENIED       = 4;
  JOIN_USERABORT          = 5;
  JOIN_NOTASPLITFILE      = 7;
  JOIN_ZIPEXIST           = 8; { nothing performed }

(* Notification message sent as soon as the REPLACE PASSWORD is displayed *)
  ZN_NEWPASSWORD          = WM_USER + 65;   { WPARAM value isn' t used, the LPARAM includes the file name, }
                                            { a tab character and the current password.                    }
(* Notification message sent from ZipJoin *)
  ZN_JOINING              = WM_USER + 41;   { Splitting in progress, wParam = total size in KB., lParam = piece name      }
  ZN_JOINED               = WM_USER + 42;   { A zip part is done, wParam = part number,  lParam = piece size ( in bytes ) }
  ZN_JOINDONESIZE         = WM_USER + 43;   { At the end of the process, lParam is the total length in bytes              }
  ZN_JOINDONENAME         = WM_USER + 44;   { At the end of the process, lParam is the new ZIP file name.                 }

(* Record type for GetZipItem function *)
type
  pZipItem = ^tZipItem;
  tZipItem = record
    Name:         array [0..49]  of char;    { Filename without path.  Empty if directory }
    Dir:          array [0..259] of char;    { Directory                                  }
    IsDir,
    IsEncrypted:  WordBool;
    Method,                                  { A ZMETHOD_* constant                       }
    Day,                                     { 1 - 31                                     }
    Month,                                   { 1 - 12                                     }
    Year,                                    { 0 - 99                                     }
    Hour,                                    { 0 - 23                                     }
    Min:          Integer;                   { 0 - 59                                     }
    OriginalSize: LongInt;
    Rate:         Integer;                   { Compression rate                           }
  end;
