unit bkmkdlg;

interface

uses
  winprocs, wintypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, FileView, JWCtrls;

type
  TAddBookmarkDlg = class(TForm)
    BookmarkList: TComboBox;
    Label1: TLabel;
    OKBtn: TBitBtn;
    CloseBtn: TBitBtn;
    AddBtn: TBitBtn;
    DeleteBtn: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure BookmarkListChange(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Bookmark: longint;
    SeqNo: integer;
    procedure Clear(AViewer: TLinesViewer);
    procedure GotoLastBookmark;
  end;

  {Object to hold Bookmark information}
  TBookmark = class(TObject)
  private
    FBookmark: integer;
    FViewer: TLinesViewer;
  public
    constructor Create(ABookmark: integer; AViewer: TLinesViewer);
    Property Bookmark: integer read FBookmark;
    Property Viewer: TLinesViewer read FViewer;
    procedure GotoBookmark;
  End;

var
  AddBookmarkDlg: TAddBookmarkDlg;

implementation

uses main, Childwin;

{$R *.DFM}

procedure TAddBookmarkDlg.FormShow(Sender: TObject);
begin
     CloseBtn.Kind := bkCancel;
end;

procedure TAddBookmarkDlg.DeleteBtnClick(Sender: TObject);
begin
   With BookMarkList Do
   With MainForm.ActiveMDIChild As TMDIChild Do
   Begin
     If Bookmark = ItemIndex Then
        Bookmark := -1;
     FileEditor1.DeleteBookmark(TBookmark(Items.Objects[ItemIndex]).Bookmark);
     Items.Objects[ItemIndex].free;
     Items.Delete(ItemIndex);
     Text := ''
   End;
   CloseBtn.Kind := bkClose;
   BookmarkListChange(Sender)
end;

procedure TAddBookmarkDlg.BookmarkListChange(Sender: TObject);

begin
  With BookmarkList Do
  Begin
     DeleteBtn.Enabled := ItemIndex >= 0;
     AddBtn.Enabled := ((ItemIndex = -1) And (Length(Text) > 0))
                        Or (Text <> Items.Strings[ItemIndex]);
  End
end;

procedure TAddBookmarkDlg.AddBtnClick(Sender: TObject);

begin
     With BookmarkList Do
     With MainForm.ActiveMDIChild As TMDIChild Do
     Begin
          Bookmark := Items.Add(Text);
          ItemIndex := Bookmark;
          Items.Objects[Bookmark] := TBookmark.create(FileEditor1.AllocBookmark,FileEditor1)
     End;
     Inc(SeqNo);
     BookmarkListChange(Sender);
     CloseBtn.Kind := bkClose
end;

procedure TAddBookmarkDlg.Clear(AViewer: TLinesViewer);

var I: integer;

Begin
     I := 0;
     With Bookmarklist.Items Do
     While I < Count Do
     Begin
          If TBookmark(Objects[I]).Viewer = AViewer Then
          Begin
              If TBookmark(Objects[I]).Bookmark = Bookmark Then
                 Bookmark := -1;
              Objects[I].free;
              Delete(I)
          End
          Else
              Inc(I)
     End;
End;

procedure TAddBookmarkDlg.OKBtnClick(Sender: TObject);
begin
     If CloseBtn.Kind = bkCancel Then
        AddBtnClick(Sender);
     close
end;

procedure TAddBookmarkDlg.FormCreate(Sender: TObject);
begin
     Seqno := 1;
     Bookmark := -1
end;

procedure TAddBookmarkDlg.FormActivate(Sender: TObject);
begin
     Bookmarklist.ItemIndex := -1;
     Bookmarklist.Text := Format('Bookmark%d',[SeqNo]);
     BookmarkListChange(Sender)
end;

procedure TAddBookmarkDlg.GotoLastBookmark;

Begin
     If Bookmark <> -1 Then
        TBookmark(BookmarkList.Items.Objects[Bookmark]).GotoBookmark
End;


constructor TBookmark.Create(ABookmark: integer; AViewer: TLinesViewer);

Begin
     inherited Create;
     FBookmark := ABookmark;
     FViewer := AViewer
End;

procedure TBookmark.GotoBookmark;

Begin
     FViewer.GotoBookmark(FBookmark);
     FViewer.Parent.BringToFront
End;
end.
