/* HASHARRY.CXX */ 
/* Copyright Dave Curtis 1994 */ 
/* dcurtis@hgmp.mrc.ac.uk */ 
/* no warranty or liability of any kind is accepted, expressed or implied */ 
 
#include "hasharry.hpp"

#ifndef using_wx
#define using_wx
#endif

#ifndef using_wx
#define __zGHashTable_Expand_Template_Functions 1
#endif
#include <string.h>

#include "dcutils.hpp"

//void hash_dcarray::clear()
// { dirty=1; dcarray::clear(); hasher::clear(); }
#ifdef using_wx
index_key_t::index_key_t(int i) { index=i; }

#ifndef really_using_wx
#include "dcerror.hpp"
void wxFatalError(const char *msg, const char *title)
{
dcerror.kill();
dcerror(1,"%s: %s", title, msg);
}

char *copystring(const char *s)
{
  int l = strlen(s);
  char *news = new char[l+1];
  strcpy(news, s);
  return news;
}
#endif

#else
static int ik_match(index_key_t *p1,index_key_t *p2)
{
return strcmp(p1->key,p2->key);
}

static unsigned ik_hash(index_key_t *pk,unsigned ts)
{
return zHashTable::default_hash(pk->key,ts);
}

#endif

int hash_dcarray::which(char *lab)
{
int i;
char buff[80];
if (dirty) rehash();
if (!hasher_failed)
  {
#ifdef using_wx
  index_key_t *ik;
  strcpy(buff,lab);
  if (!is_case_sensitive)
     strupr(buff);
//  nik=(index_key_t *)(lab-sizeof(int));
  if ((ik=(index_key_t *)hasher.Get(buff))==NULL) return -1;
  else return ik->index;
#else
  index_key_t *ik,*nik=(index_key_t *)buff;
  strcpy(nik->key,lab);
  if (!is_case_sensitive)
     strupr(nik->key);
//  nik=(index_key_t *)(lab-sizeof(int));
  if ((ik=hasher.lookup(nik))==0) return -1;
  else return ik->index;
#endif
  }
else
  {
  if (is_case_sensitive)
    {  
    for (i=0;i<count;++i)
      if (!strcmp(lab,mem[i]->label())) 
        return i;
    }
  else for (i=0;i<count;++i)
    {
    if (!stricmp(lab,mem[i]->label())) 
        return i;
    }
  return -1;
  }
}

void hash_dcarray::free_hash()
{	
#ifdef using_wx
hasher.BeginFind();
wxNode *togo;
while ((togo=hasher.Next())!=NULL) delete togo->Data();
hasher.Clear();
#else
hasher.clear();
#endif
//if (hasher) delete hasher;
//hasher=0;
dirty=1;
hasher_failed=0;
}

int hash_dcarray::rehash()
{	
index_key_t *ik;
dirty=0;
hasher_failed=1;
//if (hasher) delete hasher;
//hasher=new zGHashTable<index_key_t>(ik_match,256,ik_hash,zPtrColl::active);
//if (hasher==0) return 0;
#ifdef using_wx
hasher.Clear();
for (int i=0;i<count;++i)
  {
  char buff[200];
  ik=new index_key_t(i);
  if (ik==0) { free_hash(); return 0; }
  if (!is_case_sensitive)
    {
    strcpy(buff,mem[i]->label());
    strupr(buff);
    hasher.Put(buff,ik);
    }
  else hasher.Put(mem[i]->label(),ik);
  }
#else
hasher.clear();
for (int i=0;i<count;++i)
  {
  ik=(index_key_t *)new char[sizeof(index_key_t)+strlen(mem[i]->label())];
  if (ik==0) { hasher.clear(); return 0; }
    //{ delete hasher; hasher=0; return 0; }
  ik->index=i;
  strcpy(ik->key,mem[i]->label());
  if (!is_case_sensitive)
    strupr(ik->key);
  if (!hasher.insert(ik)) { hasher.clear(); return 0; }
    // { delete hasher; hasher=0; return 0; }
  }
#endif
hasher_failed=0;
return 1;
}

hash_dcarray::hash_dcarray(int md) : dcarray(md),
#ifdef using_wx
  hasher(wxKEY_STRING)
#else
  hasher(ik_match,256,ik_hash,zPtrColl::active)
#endif
{
//hasher=0;
dirty=1;
hasher_failed=0;
}

hash_dcarray::~hash_dcarray()
{ 
free_hash(); //hasher && delete hasher;
}





