/* HASHARRY.HPP */ 
/* Copyright Dave Curtis 1994 */ 
/* dcurtis@hgmp.mrc.ac.uk */ 
/* no warranty or liability of any kind is accepted, expressed or implied */ 
 
/* HASHARRY.HPP */ 
/* Copyright Dave Curtis 1991 */ 
#ifndef HASHARRAYHPP
#define HASHARRAYHPP 1

#include "dcarray.hpp"

#if 0

#if defined wx_msw || defined wx_xview || defined wx_motif
#include "allwx.hpp"
#include "wx_hash.h"  // not just one file 'cos spoils precompiling (not included by wx.h)
#else
#include "hash.hpp"
#endif

#else

#if defined wx_msw || defined wx_xview || defined wx_motif
#include "allwx.hpp"
#include "wx_hash.h"  // not just one file because spoils precompiling (not included by wx.h)
#define really_using_wx
#else
#define wx_msw
#include "\wxwin16\include\base\wx_hash.h"
#undef wx_msw
#define using_wx
#endif

#endif

#ifdef using_wx
class index_key_t : public wxObject
{
public: 
int index; 
~index_key_t() {;}
index_key_t(int i);
};
#else
class index_key_t
{ 
public:
int index; 
char key[1]; 
};
#endif
//declare(zGHSearch,index_key_t);

class hash_dcarray : public dcarray {
#ifdef using_wx
wxHashTable hasher;
#else
zGHashTable<index_key_t> hasher;
#endif
//zGHSearch(index_key_t) *hasher;
int rehash();
int dirty;
int hasher_failed;
public:
int which(char *name);
void free_hash();
hash_dcarray(int md=100);
~hash_dcarray();
remove(int i) { dirty=1; return dcarray::remove(i); }
move_to_start(int i) { dirty=1; return dcarray::move_to_start(i); }
move_to_end(int i) { dirty=1; return dcarray::move_to_end(i); }
int add_member(data_object *temp) { dirty=1; return dcarray::add_member(temp); }
int edit(int i,db_editor *editing_object) { dirty=1; return dcarray::edit(i,editing_object); }
int load(data_file &file) { dirty=1; return dcarray::load(file); }
void clear() 
{ 
dirty=1; dcarray::clear(); 
#ifdef using_wx
free_hash();
hasher.Clear(); 
#else
hasher.clear(); 
#endif
}
};

#define ghash_dcarray(type) name2(type,ghash_dcarray) 

#if 0
old attempt to try and allow assignment to an array element
 - I do not think it would have worked on any architecture,
and Sun CC complained about it
#define ghash_dcarraydeclare(type) \
class name2(editable_,type);\
extern "C" { int name2(type,_compare)(type **,type **); }\
struct ghash_dcarray(type) : public hash_dcarray { \
void sort() { qsort(mem,count,sizeof(mem[0]),(FCMP_T)name2(type,_compare)); }\
int edit(int i,name2(editable_,type) &editing_object)  \
{ return dcarray::edit(i,(db_editor *) &editing_object) ; } \
ghash_dcarray(type)(int md=100) : hash_dcarray(md) {;} \
protected: \
data_object *new_own_type() { return (data_object *) new type; } \
type *&member(int i) { return (type*)mem[i]; } \
public: \
type *&operator[](int i) { return (type*)mem[i]; } \
};
#else
#define ghash_dcarraydeclare(type) \
class name2(editable_,type);\
extern "C" { int name2(type,_compare)(type **,type **); }\
struct ghash_dcarray(type) : public hash_dcarray { \
void sort() { qsort(mem,count,sizeof(mem[0]),(FCMP_T)name2(type,_compare)); }\
int edit(int i,name2(editable_,type) &editing_object)  \
{ return dcarray::edit(i,(db_editor *) &editing_object) ; } \
ghash_dcarray(type)(int md=100) : hash_dcarray(md) {;} \
protected: \
data_object *new_own_type() { return (data_object *) new type; } \
type *member(int i) { return (type*)mem[i]; } \
public: \
type *operator[](int i) { return (type*)mem[i]; } \
};
#endif

#ifndef really_using_wx
#undef using_wx
#endif
#endif

