/* DBF.HPP */
/* Copyright Dave Curtis 1994 */
/* dcurtis@hgmp.mrc.ac.uk */
/* no warranty or liability of any kind is accepted, expressed or implied */

#ifndef DBFHPP
#define DBFHPP
#include "dbeditor.hpp"
#include "dcarray.hpp"
#include "dcindex.hpp"
#ifndef using_wx
#include "justtext.hpp"
#endif

#ifdef INT4BYTE
#define DCDWORD unsigned
#else
#define DCDWORD unsigned long
#endif

class db3_field_defn : public data_object {
public:
char title[11];
char field_type;
DCDWORD offset;
unsigned char length,decimal;
unsigned short zeros[7];
unsigned short real_length; // used by ALL_FIELDS
virtual char *label();
int input(data_file *f);
int output(data_file *f);
db3_field_defn();
db3_field_defn(db3_field_defn &old);
db3_field_defn(char *t,char f,unsigned short l,DCDWORD o,
  unsigned char d=0,int *z=0);
};
#pragma ZTC align

class db3_field_value
{
public:
char *data,type;
unsigned short len;
db3_field_value(char *d,unsigned short l,char c);
};

class db3_record_buffer;

declare (gdcarray,db3_field_defn);
class field_array : public gdcarray(db3_field_defn)
{
public:
field_array(int dim=128);
~field_array() {;}
#if 0
db3_field_defn *&operator[](int i) { return member(i); }
#else
db3_field_defn *operator[](int i) { return member(i); }
#endif
};

class db3_memo_file;
class winmenu;

#pragma ZTC align 2
class db3_header : public data_object {
friend class db3_record_buffer;
friend class db3_editor;
friend class dc_index;
friend class db_express;
friend class dch;
unsigned char ver; // 0x03 -> no .DBT, 0x83 -> with .DBT
unsigned char date[3]; // ymd
DCDWORD num_recs;
unsigned short data_off,data_len;
char blank[20];  // reserved
field_array flist;
char end_header; //='\0x0d';
data_file *file;
db3_memo_file *memofile;
unsigned short num_fields;
unsigned long this_rec; // record which will be loaded or saved
public:
int which_field(char *f);
unsigned long get_this_rec() { return this_rec; }
unsigned long get_num_recs() { return num_recs; }
int goto_rec(unsigned long r);
int goto_first(dc_index *i=0,int skip_deleted=1);
int goto_last(dc_index *i=0,int skip_deleted=1);
int goto_prev(dc_index *i=0,int skip_deleted=1);
int goto_next(dc_index *i=0,int skip_deleted=1);
int goto_near_match(char *m,dc_index *i=0);
int goto_exact_match(char *m,dc_index *i=0);
int select_from_index(dc_index *i,winmenu &w)
  { unsigned long r; return ((r=i->select(w))!=0 && goto_rec(r)); }
int rec_is_deleted(long r=0L);
void set_date(int d,int m,int y) { date[0]=y; date[1]=m; date[2]=d; }
void set_date();
db3_header(data_file *f,unsigned char v=0x03,db3_memo_file *mf=0);
add_field(char *t,char f,unsigned char l);
save();
load();
make_hdc(char *fn);
void save_num_recs(DCDWORD nr);
int record_save(db3_record_buffer &rb,unsigned long r=0);
int record_load(db3_record_buffer &rb,unsigned long r=0);
//db3_field_defn *operator[](int i) { return flist[i]; }
};
#pragma ZTC align

struct db3_record_buffer {
char deleted;
char *buff;
db3_header *header;
public:
void del() { deleted='*'; } // think this is right
void un_del() { deleted=' '; }
int is_deleted() { return deleted=='*'; }
db3_record_buffer(db3_header *h);
~db3_record_buffer() { delete buff; }
int add_string(int fnum,char *data);
int add_string(char *fname,char *data);
db3_field_value operator[](int ind);
db3_field_value operator()(char *title);
void clear();
make_index(char *fn,char *e);
};

class db3_memo_file {
friend class db3_editor;
FILE *fp;
long mem_offset;
static char zero_buffer[512];
public:
char *read_memo(long l);
db3_memo_file(FILE *f);
long add_memo(char *s);
void save_num_blocks()
{ fseek(fp,0,SEEK_SET); fwrite((char*)&mem_offset,1,sizeof(long),fp); }
};

#endif

