/**************************************************
 * syslib.c : library function substitutes (Posix)  
 *
 * Copyright (C) 1992 Jouni Lepp{j{rvi
 **************************************************/

#include <string.h>
#include <sys/utsname.h>

/* gethostname() appears to be a BSD function.
 * Hence, it is best to realize it with uname().
 */

int gethostname(name,namelen)
char *name;
int namelen;
{
  struct utsname suts;

  if (uname(&suts) < 0)
    return(-1);

  strncpy(name,suts.nodename,namelen);

  return(0);
}

