/*
 * fifo.h : FIFO buffers realized as macros
 *
 * Copyright (C) 1992 Jouni Leppjrvi
 *
 * FIFO_DEF(name,type,size) 
 *    FIFO_DEF() expands to a FIFO data structure definition.
 *    name : name to assign to the defined structure
 *    type : fifo item type (char, int ..)
 *    size : fifo size (items)
 *
 * FIFO_CLR(name)
 *    FIFO_CLR() initializes the FIFO specified by name.
 *    Using an uninitialized fifo = NULL pointer 
 *    assignment.
 *
 * FIFO_PUT(name,item)
 *     FIFO_PUT() puts an item into the FIFO specified by name.
 *     returns : 0 : ok
 *               1 : fifo full
 *
 * FIFO_GET(name,item)
 *    FIFO_GET() gets an item from the FIFO specified by name.
 *    Note that the macro assigns item = fifo value. (item is
 *    not (!) a pointer.
 *
 *    returns : 0 : ok
 *              1 : fifo empty
 * 
 * If the return value of FIFO_PUT() or FIFO_GET() is not used,
 * the compiler generates a warning of the type 'code has no
 * effect'.
 *
 * _FIFO_INC() is an internal help macro.
 */

#define FIFO_DEF(n,t,s) struct {t *f, *l, b[(s) + 1];} n
#define FIFO_CLR(n) (n.f = n.l = n.b)
#define _FIFO_INC(n,i) (&n.i[1] >= &n.b[sizeof(n.b) / sizeof(n.b[0])] ? n.b : &n.i[1])
#define FIFO_GET(n,i) (n.f == n.l ? 1 : !((i = *n.f), (n.f = _FIFO_INC(n,f))))
#define FIFO_PUT(n,i) (_FIFO_INC(n,l) == n.f ? 1 : !((*n.l = i), (n.l = _FIFO_INC(n,l))))
