program BaseCalc;

{************************************************************************
*                                                                       *
*                         Base Calculator Program                       *
*                    Copyright (C) 1996, John Zaitseff                  *
*                                                                       *
************************************************************************}

{ Author:    John Zaitseff <J.Zaitseff@unsw.edu.au>
  Date:      6th November, 1996.
  Version:   1.2

  This file is the main program file for the Base Calculator.  The Base
  Calculator is a base integer calculator (ie, one that operates in
  decimal, hexadecimal, binary or octal), in either 8, 16 or 32 bit size.

  This program is free software, and may be distributed and/or modified
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either Version 2 of the License or any later
  version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program (in the file LICENSE.TXT); if not, write to:
            Free Software Foundation, Inc.,
            675 Mass Ave, Cambridge, MA 02139, USA.

  Please feel free to send any comments, suggestions, corrections and
  enhancements to:

  Postal:   John Zaitseff,
            4 McCabe Close,
            Menai, NSW, 2234,
            Australia.
  Email:    J.Zaitseff@unsw.edu.au

}

uses
  Forms,
  BCalcWin in 'BCalcWin.pas' {BaseCalcWin},
  About in 'About.pas' {AboutWin},
  Value in 'Value.pas' {ValueWin},
  Calc in 'Calc.pas';

{$R *.RES}

begin  { Main }
  Application.Initialize;
  Application.Title := 'Base Calculator';
  Application.HelpFile := 'BASECALC.HLP';
  Application.CreateForm(TBaseCalcWin, BaseCalcWin);
  Application.CreateForm(TAboutWin, AboutWin);
  Application.CreateForm(TValueWin, ValueWin);
  Application.Run;
end.
