;ACONVERT.LSP function to save an AutoCad R13 drawing
;as a R12 drawing

;Intended for use with RUN LISP to automatically batch 
;process multiple drawings.

;In order to avoid overwriting your R13 files you MUST
;create a subdirectory off of the directory containing
;the drawings to be converted named ASAVE12

;You may want to have AutoCad's log file enabled so that
;you can review entity type changes.


(defun aconvert()
	;timing loop to give RUN LISP a chance to send load
	;command for next drawing
	(setq t(getvar "cdate"))
	(while (< (+ t 10000)(getvar "cdate)))
	(setq oflags(getvar "qaflags"))
	(setvar "qaflags" 2)
	;build the save drawing name string
	(setq cname(getvar "dwgname"))
	(setq count 1)
	(repeat (strlen cname)
		(if (= (substr cname count 1) (chr 92))
			(setq mark (1- count))
		);end if
		(setq count (1+ count))
	);end repeat
	(setq nname(strcat (substr cname 1 mark) (chr 92) "ASAVE12" (chr 92) (substr cname (+ 2 mark)) ".DWG"))
	;if drawing exists - overwrite it
	(if (= (findfile nname) nname)
		(command "_saveasr12" nname "y")
		(command "_saveasr12" nname)
	);end if	
	(setvar "qaflags" oflags)
);end defun
(aconvert)