;ATTRSTYL program to change the text style and text height of block 
;attributes

;This is a batch compatible program intended for use with RUN LISP
;or a script file.  RUN LISP is a commericial Windows program 
;by Sierra Hermitage that eliminates the need to prepare script files 
;to do batch processing.  

;Sierra Hermitage - AutoCad automation
;Rod Young, Owner
;140 Mesa Vista Drive
;Bishop, CA  93514
;Phone: 619-387-2479
;Email hermit1@ix.netcom.com

;Since this program is intended to be run in batch mode, the name
;of the block whose attributes are to be changed, the new shx and
;the new text height are all hard coded.  You're free to change 
;those parameters in lines 2, 3 & 4 of the program.  Also,
;inasmuch as the style name. and not the shx name, is what is stored
;in the block association list, this program must create a new style
;if that style does not currently exist - so the name of the new 
;(or existing) style is set in the fifth line.  Change that to suite 
;your needs.

;If the style you hard code currently exists in the drawing, and its
;shx file does not conform to the one you choose, the style will be
;changed to use the new shx.  Please be aware that this will change all
;other text and attributes in the drawings using that style to the new
;shx - their height is unaffected.

;Also, so that you have the option of not changing other attribute that
;have different styles, you must hard code the name of the style to
;change in the sixth line.  You can find out what that style currently
;is by simply listing one of the existing blocks. 



(defun attrstyl()
	(setq blk "BLKNAME")			;change this to the name of your block
	(setq shx "ROMANC")			;change this to the shx of your choice
	(setq ht 0.10)					;change this to the height of your choice
	(setq newstyle "NEWSTYLE")	;change this to suite your needs
	(setq oldstyle "OLDSTYLE")	;change this to suite your needs
	;check for caps
	(setq newstyle(strcase newstyle))	;make it upper case
	(setq oldstyle(strcase oldstyle))
	(setq blk(strcase blk))
	;define the style
	(command "_style" newstyle shx "" "" "" "" "" "")
	;change the block attributes
;	(setq pair(cons 2 blk))
	(setq ss(ssget "X" (list(cons 2 blk))))	;all blocks of that name	
	(setq count 0)	;index counter
	(repeat (sslength ss)
		(princ cout)	;debug
		(setq ent(ssname ss count))	;get the head
		(while(/= (cdr(assoc 0(entget ent))) "SEQEND")	;for each attribute
			(if (= (cdr(assoc 7 (entget ent))) oldstyle)
			 (progn
				;change the style
				(setq elist(entget ent))
				(setq elist
					(subst (cons 7 newstyle)
						(assoc 7 elist)
						elist
					)
				);end setq
				(entmod elist)
				;change the height
				(setq elist(entget ent))
				(setq elist
					(subst (cons 40 ht)
						(assoc 7 elist)
						elist
					)
				);end setq
				(entmod elist)
			 );end progn
			);end if
			(setq ent(entnext ent))
		);end while
		(setq count (1+ count))	;increment index
	);end repeat
	(setq ss nil)	;free the set
	(command "_qsave")
);end defun
(attrstyl)	;make this program 'load & go' - do this for all RUN LISP (batch)
				;compatible programs