/******************************************************************************
 * NOTE: This file has been modified for use with MSDOS and the WATCOM C/386
 * and DJGPP compilers.  Darryl Okahata, June 1993.
 *****************************************************************************/

/* Demacs 1.1.2 91/10/20 Manabu Higashida	*/
/* Demacs 1.1.7 91/11/28 Manabu Higashida : PC-9801 support.		*/
/* Demacs 1.1.8 91/11/29 Manabu Higashida : FEP Control support.	*/
/* Demacs 1.1.9 91/11/30 Manabu Higashida 	*/

/* MS-DOS specific Lisp utilities.  Coded by Manabu Higashida, 1991.

   Updated by Darryl Okahata for OEmacs, March, June, July 1993.
   Derived from the Demacs source code:

   This file is part of Demacs (MS-DOS version of GNU Emacs and Nemacs).

   Demacs is distributed in the forms of patches to GNU
   Emacs under the terms of the GNU EMACS GENERAL PUBLIC
   LICENSE which is distributed along with GNU Emacs by the
   Free Software Foundation.

   Demacs is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the GNU EMACS GENERAL PUBLIC LICENSE for
   more details.

   You should have received a copy of the GNU EMACS GENERAL
   PUBLIC LICENSE along with Demacs; see the file COPYING.
   If not, write to the Free Software Foundation, 675 Mass
   Ave, Cambridge, MA 02139, USA. */

#include "config.h"

#ifdef MSDOS
/* The entire file is within this conditional */

#include <stdio.h>
#include <dos.h>
#ifdef __GO32__
# include <sys/time.h>
#endif
#include <time.h>
#include <string.h>

#if defined(__WATCOMC__) && defined(__FLAT__)

# define __FLAT_WATCOMC__	/* for ease of #ifdef */

# include <malloc.h>
# include "dpmi.h"

#endif

#ifndef __WATCOMC__
# ifdef NULL
#  undef NULL
# endif
#endif
#include "lisp.h"
#include "frame.h"
#include "buffer.h"
#include "termchar.h"
#include "dosfns.h"
#include "pccompat.h"

Lisp_Object Vdos_machine_type;

#ifdef IBMPC
Lisp_Object Qibmpc;
#endif
#ifdef J3100
Lisp_Object Qj3100;
#endif
#ifdef PC9801
Lisp_Object Qpc98;
#endif

int InhibitSetDisk;
#ifdef FEPCTRL /* Demacs 1.1.8 91/11/29 Manabu Higashida */
int InhibitFEPCtrl;
static int FEPstat = 0;
#endif

int emacs_use_dos_input;


#define DEFAULT_BREAK_CHECK	100

/* #undef SET_BREAK_CHECK_COUNT	/* obsolete, not needed */

#if defined(SET_BREAK_CHECK_COUNT) && defined(CTRL_BREAK_INTERRUPTS)
static int	break_check_count = DEFAULT_BREAK_CHECK;
#endif


/*
 * This seems to be missing from DJGPP...
 */
ScreenSetMode(int mode)
{
  REGS_TYPE regs;

  REGISTER_AH(regs) = 0x00;
  REGISTER_AL(regs) = mode & 0xff;
  INT(0x10, &regs, &regs);
}


ScreenFontHeight()
{
  int	lines;

  lines = 0;
  dosmemget(0x00000485, 2, &lines);
  return (lines);
}


#ifdef __WATCOMC__
/*
 * And these are missing from WATCOM C/386 ...
 */

short *ScreenPrimary = 0xb8000;

ScreenSetCursor(row, col)
int	row, col;
{
  REGS_TYPE regs;

  REGISTER_AH(regs) = 0x02;
  REGISTER_BH(regs) = 0;
  REGISTER_DH(regs) = row;
  REGISTER_DL(regs) = col;
  INT(0x10, &regs, &regs);
}

ScreenMode()
{
  return (*(char *)0x00000449);
}

ScreenCols()
{
  return (*(unsigned short int *)0x0000044A);
}

ScreenRows()
{
  return (1 + *(unsigned char *)0x00000484);
}

void dosmemget(int offset, int length, void *buffer)
{
  memcpy(buffer, (void *) offset, (size_t) length);
}

void dosmemput(void *buffer, int length, int offset)
{
  memcpy((void *) offset, buffer, (size_t) length);
}
#endif

/*
 * Sleep for a short period.
 *
 * The following will not work above 21 seconds or so.
 */
u_sleep(long usec)
{
#ifdef __WATCOMC__
  clock_t	tnow, tthen;

  tnow = clock();
  tthen = tnow + (usec * CLOCKS_PER_SEC) / 1000000;
  while (1) {
    tnow = clock();
    if (tnow >= tthen)
      break;
  }
#else	/* not __WATCOMC__ */
# ifdef __GO32__
  struct timeval t1, t2, t3;

  gettimeofday(&t1, (struct timezone *)0);

  while (1) {
    gettimeofday(&t2, (struct timezone *)0);
    timeval_subtract(&t3, t2, t1);
    if (t3.tv_usec >= usec)
      break;
    if (t3.tv_sec >= 1)
      break;	/* just in case. */
  }
# endif	/* __GO32__ */
#endif	/* not __WATCOMC__ */
}

/*
 * Code stolen from `substitute-in-file-name' in fileio.c:
 */
DEFUN ("substitute-environment-vars", Fsubstitute_environment_vars,
       Ssubstitute_environment_vars, 1, 1, 0,
       "Replace all environment variables in STRING.\n\
`$FOO' where FOO is an environment variable name means to substitute\n\
the value of that variable.  The variable name should be terminated\n\
with a character not a letter, digit or underscore; otherwise, enclose\n\
the entire variable name in braces.\n\
")
     (string)
     Lisp_Object string;
{
  unsigned char		*nm, *endp, *p, *o, *s, *target, *xnm, *x;
  int			substituted;
  int			total;

  total = 0;
  substituted = 0;
  CHECK_STRING (string, 0);

  nm = XSTRING (string)->data;
  endp = nm + XSTRING (string)->size;

  /* See if any variables are substituted into the string
     and find the total length of their values in `total' */

  for (p = nm; p != endp;)
    if (*p != '$')
      p++;
    else
      {
	p++;
	if (p == endp)
	  goto badsubst;
	else if (*p == '$')
	  {
	    /* "$$" means a single "$" */
	    p++;
	    total -= 1;
	    substituted = 1;
	    continue;
	  }
	else if (*p == '{')
	  {
	    o = ++p;
	    while (p != endp && *p != '}') p++;
	    if (*p != '}') goto missingclose;
	    s = p;
	  }
	else
	  {
	    o = p;
	    while (p != endp && (isalnum (*p) || *p == '_')) p++;
	    s = p;
	  }

	/* Copy out the variable name */
	target = (unsigned char *) alloca (s - o + 1);
	strncpy (target, o, s - o);
	target[s - o] = 0;

	/* Get variable value */
	if ((o = (unsigned char *) egetenv (target)) != 0)
	  total += strlen (o);
	substituted = 1;
      }

  if (!substituted)
    return string;

  /* If substitution required, recopy the string and do it */
  /* Make space in stack frame for the new copy */
  xnm = (unsigned char *) alloca (XSTRING (string)->size + total + 1);
  x = xnm;

  /* Copy the rest of the name through, replacing $ constructs with values */
  for (p = nm; *p;)
    if (*p != '$')
      *x++ = *p++;
    else
      {
	p++;
	if (p == endp)
	  goto badsubst;
	else if (*p == '$')
	  {
	    *x++ = *p++;
	    continue;
	  }
	else if (*p == '{')
	  {
	    o = ++p;
	    while (p != endp && *p != '}') p++;
	    if (*p != '}') goto missingclose;
	    s = p++;
	  }
	else
	  {
	    o = p;
	    while (p != endp && (isalnum (*p) || *p == '_')) p++;
	    s = p;
	  }

	/* Copy out the variable name */
	target = (unsigned char *) alloca (s - o + 1);
	strncpy (target, o, s - o);
	target[s - o] = 0;

	/* Get variable value */
	if ((o = (unsigned char *) egetenv (target)) != 0)
	  {
	    strcpy (x, o);
	    x += strlen (o);
	  }
      }

  *x = 0;

  return make_string (xnm, x - xnm);

 badsubst:
  error ("Bad format environment-variable substitution");
 missingclose:
  error ("Missing \"}\" in environment-variable substitution");
}

convert_dos_pathnames(paths, len)
     char	*paths;
{
  register char	*cptr;
  int		changed = 0;

  if (len <= 0)
    len = strlen(paths);
  for (cptr = paths; *cptr && len-- > 0 ; ++cptr)
    {
      if (*cptr == '\\') {
	*cptr = '/';
	changed = 1;
      } else if (isupper(*cptr)) {
	*cptr = tolower(*cptr);
	changed = 1;
      }
    }
  return (changed);
}

DEFUN ("make-dos-filename", Fmake_dos_filename, Smake_dos_filename,
       1, 1, 0,
       "Convert FILENAME into a dos filename.\n\
This involves changing backslashes into forward slashes, and downcasing\n\
the entire filename.")
  (filename)
     Lisp_Object filename;
{
  char		*name;
  register char	*cptr, *name_ptr;
  int		changed = 0;

  CHECK_STRING (filename, 0);

  name = (char *) alloca(XSTRING(filename)->size + 1);
  strcpy(name, XSTRING(filename)->data);
  if (convert_dos_pathnames(name, 0))
    {
      return (build_string(name));
    }
  return (filename);
}

DEFUN ("int86", Fint86, Sint86, 2, 2, 0, "")
  (intno, regs)
  Lisp_Object intno, regs;
{
#if defined(__FLAT_WATCOMC__)
  register int i;
  int size;
  DPMIREGS int_regs;
  Lisp_Object val;

  CHECK_NUMBER (intno, 0);
  CHECK_VECTOR (regs, 0);
  if (XVECTOR (regs)-> size != 8)
    return Qnil;
  for (i = 0; i < 8; i++)
    {
      CHECK_NUMBER (XVECTOR (regs)->contents[i], 0);
    }

  memset(&int_regs, 0, sizeof(int_regs));
  int_regs.EAX    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[0]);
  int_regs.EBX    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[1]);
  int_regs.ECX    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[2]);
  int_regs.EDX    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[3]);
  int_regs.ESI    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[4]);
  int_regs.EDI    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[5]);
  int_regs.flags  = (unsigned long) XFASTINT (XVECTOR (regs)->contents[7]);
  if ((unsigned long) XFASTINT (XVECTOR (regs)->contents[6]))
    {
      int_regs.flags |= DPMI_CARRY_FLAG;
    }
  else
    {
      int_regs.flags &= ~DPMI_CARRY_FLAG;
    }


  dpmi_call_int(XFASTINT (intno), &int_regs);

  XVECTOR (regs)->contents[0] = make_number (int_regs.EAX);
  XVECTOR (regs)->contents[1] = make_number (int_regs.EBX);
  XVECTOR (regs)->contents[2] = make_number (int_regs.ECX);
  XVECTOR (regs)->contents[3] = make_number (int_regs.EDX);
  XVECTOR (regs)->contents[4] = make_number (int_regs.ESI);
  XVECTOR (regs)->contents[5] = make_number (int_regs.EDI);
  if (int_regs.flags & DPMI_CARRY_FLAG)
    {
      XVECTOR (regs)->contents[6] = make_number (1);
    }
  else
    {
      XVECTOR (regs)->contents[6] = make_number (0);
    }
  XVECTOR (regs)->contents[7] = make_number (int_regs.flags);
#else	/* not __FLAT_WATCOMC__ */
  register int i;
  int size;
  union REGS inregs, outregs;
  Lisp_Object val;

  CHECK_NUMBER (intno, 0);
  CHECK_VECTOR (regs, 0);
  if (XVECTOR (regs)-> size != 8) return Qnil;
  for (i = 0; i < 8; i++)
    {
      CHECK_NUMBER (XVECTOR (regs)->contents[i], 0);
    }

  inregs.x.ax    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[0]);
  inregs.x.bx    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[1]);
  inregs.x.cx    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[2]);
  inregs.x.dx    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[3]);
  inregs.x.si    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[4]);
  inregs.x.di    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[5]);
  inregs.x.cflag = (unsigned long) XFASTINT (XVECTOR (regs)->contents[6]);
  inregs.x.flags = (unsigned long) XFASTINT (XVECTOR (regs)->contents[7]);

  int86 ((unsigned long) XFASTINT (intno), &inregs, &outregs);

  XVECTOR (regs)->contents[0] = make_number (outregs.x.ax);
  XVECTOR (regs)->contents[1] = make_number (outregs.x.bx);
  XVECTOR (regs)->contents[2] = make_number (outregs.x.cx);
  XVECTOR (regs)->contents[3] = make_number (outregs.x.dx);
  XVECTOR (regs)->contents[4] = make_number (outregs.x.si);
  XVECTOR (regs)->contents[5] = make_number (outregs.x.di);
  XVECTOR (regs)->contents[6] = make_number (outregs.x.cflag);
  XVECTOR (regs)->contents[7] = make_number (outregs.x.flags);
#endif	/* not __FLAT_WATCOMC__ */

  return regs;
}

DEFUN ("emacs-UTC-time", Femacs_UTC_time, Semacs_UTC_time, 0, 0, 0,
       "Get the current GMT time, in seconds since Jan 1, 1970.\n\
A list of two numbers is returned: the first has the high-order 16 bits,\n\
and the second has the lower 16 bits.")
     ()
{
  Lisp_Object	t[2];
  time_t	current_time;

  current_time = time((time_t *) 0);
  t[0] = make_number(((int) current_time >> 16) & 0xffff);
  t[1] = make_number((int) current_time & 0xffff);
  return (Flist(2, t));
}

DEFUN ("emacs-pc-screen-p", Femacs_pc_screen_p, Semacs_pc_screen_p, 0, 0, 0,
       "Return non-nil if Emacs is doing direct screen writes to a PC screen.")
     ()
{
#ifdef PC_FACES
  if (FRAME_PC_SCREEN_P(selected_frame))
    return (Qt);
#endif
  return (Qnil);
}

#define MODE_80_25	0
#define MODE_80_43	1
#define MODE_80_50	2

static void set_base_display_segment()
{
#ifdef __WATCOMC__
  REGS_TYPE	regs;

  memset(&regs, 0, sizeof(regs));
  REGISTER_AX(regs) = 0x1200;
  REGISTER_BL(regs) = 0x10;
  REGISTER_CX(regs) = 0;
  INT(0x10, &regs, &regs);

  if (REGISTER_BH(regs) & 1)
    ScreenPrimary = (short *) 0xb0000;	/* monochrome mode ... */
  else
    ScreenPrimary = (short *) 0xb8000;	/* color mode ... */
#endif
}

static set_pc_display_mode(mode)
int	mode;
{
  REGS_TYPE	regs;
  int		status, mono, page, block_cursor;

  status = 0;

  memset(&regs, 0, sizeof(regs));

  REGISTER_AH(regs) = 0x0F;
  INT(0x10, &regs, &regs);
  page = REGISTER_BH(regs);

  REGISTER_AH(regs) = 0x03;
  /* page is still in BH */
  INT(0x10, &regs,  &regs);
  if (REGISTER_CH(regs) == 0)
    block_cursor = 1;
  else
    block_cursor = 0;

  REGISTER_AX(regs) = 0x0500;
  INT(0x10, &regs, &regs);

  REGISTER_AX(regs) = 0x1200;
  REGISTER_BL(regs) = 0x10;
  REGISTER_CX(regs) = 0;
  INT(0x10, &regs, &regs);
  mono = REGISTER_BH(regs) & 1;

  if (REGISTER_CX(regs) != 0)
    {
      if (mode == MODE_80_43)
	REGISTER_AX(regs) = 0x1201;
      else
	REGISTER_AX(regs) = 0x1202;
      REGISTER_BL(regs) = 0x30;
      INT(0x10, &regs, &regs);

      if (mono)
	REGISTER_AX(regs) = 7;
      else
	REGISTER_AX(regs) = 3;
      INT(0x10, &regs, &regs);

      switch (mode)
	{
	case MODE_80_25:
	  /* do nothing here */
	  break;
	case MODE_80_43:
	case MODE_80_50:
	  REGISTER_AX(regs) = 0x1112;
	  REGISTER_BL(regs) = 0;
	  INT(0x10, &regs, &regs);
	  break;
	default:
	  break;
	}

      REGISTER_AH(regs) = 0x02;
      REGISTER_DL(regs) = ' ';
      INT(0x21, &regs, &regs);

      REGISTER_AH(regs) = 0x0e;
      REGISTER_AL(regs) = '\b';
      REGISTER_BL(regs) = 0;
      INT(0x10, &regs, &regs);

      REGISTER_AH(regs) = 0x08;
      INT(0x10, &regs, &regs);

      REGISTER_BH(regs) = REGISTER_AH(regs);
      REGISTER_AX(regs) = 0x0600;
      REGISTER_CX(regs) = 0;
      REGISTER_DX(regs) = (49 << 8) | 79;
      INT(0x10, &regs, &regs);

      if (block_cursor)
	{
	  /*
	   * Reset the cursor back to a block cursor.
	   */
	  REGISTER_AH(regs) = 0x0F;
	  INT(0x10, &regs, &regs);	/* Get mode, and leave it in AL.
					   This is done to prevent crashes
					   in certain machines (supposedly,
					   AMI 386 BIOS and AST Premier 386
					   BIOS, according to the interrupt
					   list). */

	  REGISTER_AH(regs) = 0x01;
	  REGISTER_CH(regs) = 0;
	  REGISTER_CL(regs) = ScreenFontHeight();
	  INT(0x10, &regs, &regs);
	}

      status = 1;
    }
  return (status);
}


DEFUN ("emacs-pc-25-line-mode", Femacs_pc_25_line_mode,
       Semacs_pc_25_line_mode, 0, 0, "",
       "Set the screen to 25-line mode.")
     ()
{
  REGS_TYPE	regs;

  if (!FRAME_PC_SCREEN_P(selected_frame))
    error ("Setting 25-line mode implemented only when doing direct screen writes.");

  if (set_pc_display_mode(MODE_80_25))
    {
      set_base_display_segment();
      change_frame_size (selected_frame, ScreenRows(), ScreenCols(), 0, 0);
      SET_FRAME_GARBAGED (selected_frame);
      return (Qt);
    }

  return (Qnil);
}


DEFUN ("emacs-pc-43-line-mode", Femacs_pc_43_line_mode,
       Semacs_pc_43_line_mode, 0, 0, "",
       "Set the screen to 43-line mode, if possible.")
     ()
{
  REGS_TYPE	regs;

  if (!FRAME_PC_SCREEN_P(selected_frame))
    error ("Setting 43-line mode implemented only when doing direct screen writes.");

  if (set_pc_display_mode(MODE_80_43))
    {
      set_base_display_segment();
      change_frame_size (selected_frame, ScreenRows(), ScreenCols(), 0, 0);
      SET_FRAME_GARBAGED (selected_frame);
      return (Qt);
    }

  return (Qnil);
}


DEFUN ("emacs-pc-50-line-mode", Femacs_pc_50_line_mode,
       Semacs_pc_50_line_mode, 0, 0, "",
       "Set the screen to 50-line mode, if possible.")
     ()
{
  REGS_TYPE	regs;

  if (!FRAME_PC_SCREEN_P(selected_frame))
    error ("Setting 50-line mode implemented only when doing direct screen writes.");

  if (set_pc_display_mode(MODE_80_50))
    {
      set_base_display_segment();
      change_frame_size (selected_frame, ScreenRows(), ScreenCols(), 0, 0);
      SET_FRAME_GARBAGED (selected_frame);
      return (Qt);
    }

  return (Qnil);
}


DEFUN ("emacs-pc-set-screen-mode", Femacs_pc_set_screen_mode,
       Semacs_pc_set_screen_mode, 1, 3, "nScreen mode: ",
       "Set the screen mode.\n\
This function calls the BIOS to change the screen mode and so allows\n\
any text mode supported by the BIOS to be used.\n\
\n\
WARNING: The mode number for a particular screen size varies depending\n\
upon the manufacturer and so care must be taken not to select an unknown\n\
or graphics mode.")
     (mode, height, width)
	 Lisp_Object mode, height, width;
{
  int rows, cols;

  if (!FRAME_PC_SCREEN_P(selected_frame))
    error ("Implemented only when doing direct screen writes.");

  CHECK_NUMBER(mode, 0);
  if (!NILP(height)) CHECK_NUMBER(height, 0);
  if (!NILP(width)) CHECK_NUMBER(width, 0);

  ScreenSetMode(XFASTINT(mode));
  set_base_display_segment();
  rows = (NILP(height)) ? ScreenRows() : XFASTINT(height);
  cols = (NILP(width)) ? ScreenCols() : XFASTINT(width);
  change_frame_size (selected_frame, rows, cols, 0, 0);
  SET_FRAME_GARBAGED (selected_frame);
  return (Qt);
}


DEFUN ("emacs-pc-get-screen-mode", Femacs_pc_get_screen_mode,
	   Semacs_pc_get_screen_mode, 0, 0, 0,
	   "Return the current screen mode.")
	 ()
{
  Lisp_Object tem;

  if (!FRAME_PC_SCREEN_P(selected_frame))
    error ("Implemented only when doing direct screen writes.");

  XSET (tem, Lisp_Int, ScreenMode());
  return tem;
}

#if defined(SET_BREAK_CHECK_COUNT) && defined(CTRL_BREAK_INTERRUPTS)
DEFUN ("emacs-set-break-checking", Femacs_set_break_checking,
       Semacs_set_break_checking, 1, 1, 0,
       "Set how often Ctrl-Break checking is to be performed.\n\
The smaller the number, the more often Ctrl-Break checking is done,\n\
but at the expense of execution time.")
     (count)
     Lisp_Object count;
{
  int	num;

  CHECK_NUMBER (count, 0);
  num = XFASTINT(count);
  if (num < 1)
    num = DEFAULT_BREAK_CHECK;
  break_check_count = num;
  return (count);
}
#endif


#ifdef __GO32__

print_time()
{
  struct timeval	t;
  struct timezone	dummy;

  gettimeofday (&t, &dummy);
  printf("\ntv_sec = %d\n", t.tv_sec);
  printf("tv_usec = %d\n", t.tv_usec);
  fflush(stdout);
}

/* Subtract the `struct timeval' values X and Y,
   storing the result in RESULT.
   Return 1 if the difference is negative, otherwise 0.  */

int
timeval_subtract (result, x, y)
     struct timeval *result, x, y;
{
  /* Perform the carry for the later subtraction by updating y.
     This is safer because on some systems
     the tv_sec member is unsigned.  */
  if (x.tv_usec < y.tv_usec)
    {
      int nsec = (y.tv_usec - x.tv_usec) / 1000000 + 1;
      y.tv_usec -= 1000000 * nsec;
      y.tv_sec += nsec;
    }
  if (x.tv_usec - y.tv_usec > 1000000)
    {
      int nsec = (y.tv_usec - x.tv_usec) / 1000000;
      y.tv_usec += 1000000 * nsec;
      y.tv_sec -= nsec;
    }

  /* Compute the time remaining to wait.  tv_usec is certainly positive.  */
  result->tv_sec = x.tv_sec - y.tv_sec;
  result->tv_usec = x.tv_usec - y.tv_usec;

  /* Return indication of whether the result should be considered negative.  */
  return x.tv_sec < y.tv_sec;
}


#if defined(CTRL_BREAK_INTERRUPTS)

static int	break_count;

check_go32_break(now)
{
  int	quit = 0;
#ifdef DVX
  extern int	interrupt_input_blocked, waiting_for_input;

  if (interrupt_input_blocked || waiting_for_input)
    return;
#endif	/* DVX */

  /*
   * Checking Ctrl-Break every time is VERY expensive (time consuming).
   * As a compromise, we check only every so often, unless now != 0, in
   * which case we check immediately.
   */
  if (!now)
    {
#if defined(SET_BREAK_CHECK_COUNT)
      if ((++break_count % break_check_count) == 0)
#else
      if ((++break_count % DEFAULT_BREAK_CHECK) == 0)
#endif
	{
	  break_count = 0;
#ifdef DVX
	  read_avail_input (0);
#else
	  check_ctrl_break(&quit);
#endif
	}
    }
  else
    {
#ifdef DVX
      read_avail_input (0);
#else
      check_ctrl_break(&quit);
#endif
      break_count = 0;
    }
#ifndef DVX
  if (quit)
    Vquit_flag = Qt;
#endif	/* not DVX */
}

#endif

#endif	/* __GO32__ */

#if defined(__FLAT_WATCOMC__)

#ifndef GNU_MALLOC
unsigned long	_data_seg_offset;

void initialize_dos_memory()
{
  void	*ptr;

  ptr = sbrk(1);
  _data_seg_offset = (((unsigned long)ptr) & ~VALMASK);
}
#endif	/* not GNU_MALLOC */

void __interrupt hit_ctrl_break()
{
  /*
   * Reset ctrl-break flag
   */
  *((unsigned char *) 0x00000471) = *((unsigned char *) 0x00000471) & 0x7f;
  /*
   * Set quit flag
   */
  Vquit_flag = Qt;
}

void grab_ctrl_break()
{
  union REGS	regs;
  struct SREGS	sregs;
  void far	*farptr;

  memset(&sregs, 0, sizeof(sregs));
  regs.x.eax = 0x251b;
  farptr = (void far *) hit_ctrl_break;
  sregs.ds = FP_SEG(farptr);
  regs.x.edx = FP_OFF(farptr);
  int386x(0x21, &regs, &regs, &sregs);
}


DEFUN ("emacs-stackavail", Femacs_stack_avail, Semacs_stack_avail, 0, 0, 0,
       "Return the amount of currently unused stack space\n\
Note that this function reports the CURRENTLY available stack space.\n\
A more useful function would be to report the maximum amount of stack space\n\
ever used, but this is currently too difficult.")
  ()
{
  size_t	stack_free;

  stack_free = stackavail();
  return (make_number((int) stack_free));
}


DEFUN ("emacs-dpmi-info", Femacs_dpmi_info, Semacs_dpmi_info, 0, 0, 0,
       "Get current DPMI memory status.\n\
A list of values is returned:\n\
    0. The largest available block, in KB (1 KB=1024 bytes).  This number\n\
       is incorrect if Emacs is running within Windows 3.1.\n\
    1. Maximum unlocked page allocation.\n\
    2. Maximum locked page allocation.\n\
    3. Linear address space size in pages.\n\
    4. Total number of unlocked pages.\n\
    5. Number of free pages.\n\
    6. Total number of physical pages.\n\
    7. Free linear address space in pages.\n\
    8. Size of paging file/partition in pages.\n\
On most systems, a page is 4096 bytes.")
     ()
{
  Lisp_Object	dpmi_values[9];
  DPMI_MEMINFO	meminfo;

  dpmi_get_meminfo(&meminfo);
  dpmi_values[0] = make_number((int) (meminfo.largest_avail_block / 1024));
  dpmi_values[1] = make_number((int) meminfo.max_unlocked_page);
  dpmi_values[2] = make_number((int) meminfo.largest_lockable_page);
  dpmi_values[3] = make_number((int) meminfo.linear_addr_space);
  dpmi_values[4] = make_number((int) meminfo.num_free_pages);
  dpmi_values[5] = make_number((int) meminfo.num_physical_free_pages);
  dpmi_values[6] = make_number((int) meminfo.total_physical_pages);
  dpmi_values[7] = make_number((int) meminfo.free_linear_addr_space);
  dpmi_values[8] = make_number((int) meminfo.pagefile_size);
  return (Flist(9, dpmi_values));
}


#ifdef DEBUG_EMACS

Lisp_Object _get_pair(n)
unsigned long	n;
{
  Lisp_Object		a[2];

  a[0] = make_number((int) ((n >> 16) & 0xffff));
  a[1] = make_number((int) (n & 0xffff));
  return (Flist(2, a));
}


DEFUN ("emacs-debug-get-addresses", Femacs_debug_get_addresses,
       Semacs_debug_get_addresses, 0, 0, 0,
       "")
     ()
{
  Lisp_Object		a[4];
  extern char		data_start;
  extern char		my_edata;
  extern char		bss_start;
  extern char		bss_end;

  a[0] = _get_pair((unsigned long) &data_start);
  a[1] = _get_pair((unsigned long) &my_edata);
  a[2] = _get_pair((unsigned long) &bss_start);
  a[3] = _get_pair((unsigned long) &bss_end);
  return (Flist(4, a));
}

#endif	/* DEBUG_EMACS */
#endif	/* __FLAT_WATCOMC__ */

#ifdef FEPCTRL	/* Demacs 1.1.8 91/11/29 Manabu Higashida */
DEFUN ("fep-init", Ffep_init, Sfep_init, 0, 0, 0, "")
  ()
{
  extern int fep_init (void);
  if (!InhibitFEPCtrl)
    {
      FEPstat = 1;
      return make_number (fep_init ());
    }
  else
    return Qnil;
}

DEFUN ("fep-term", Ffep_term, Sfep_term, 0, 0, 0, "")
  ()
{
  extern void fep_term (void);
  if (!InhibitFEPCtrl)
    {
      FEPstat = 0;
      fep_term ();
    }
  return Qnil;
}

DEFUN ("fep-on", Ffep_on, Sfep_on, 0, 0, 0, "")
  ()
{
  extern void fep_on (void);
  if (!InhibitFEPCtrl && !NULL (bf_cur->fep_mode) && !FEPstat)
    {
      FEPstat = 1;
      fep_on ();
    }
  return Qnil;
}

DEFUN ("fep-off", Ffep_off, Sfep_off, 0, 0, 0, "")
  ()
{
  extern void fep_off (void);
  if (!InhibitFEPCtrl && !NULL (bf_cur->fep_mode) && FEPstat)
    {
      FEPstat = 0;
      fep_off ();
    }
  return Qnil;
}

DEFUN ("fep-force-on", Ffep_force_on, Sfep_force_on, 0, 0, "", "")
  ()
{
  extern void fep_force_on (void);
  if (!InhibitFEPCtrl)
    {
      fep_force_on ();
      bf_cur->fep_mode = Qt;
    }
  return Qnil;
}

DEFUN ("fep-force-off", Ffep_force_off, Sfep_force_off, 0, 0, "", "")
  ()
{
  extern void fep_force_off (void);
  if (!InhibitFEPCtrl)
    {
      fep_force_off ();
      bf_cur->fep_mode = Qnil;
    }
  return Qnil;
}
#endif /* FEPCTRL */

#ifdef PC9801
DEFUN ("pc98-assign-special-key", 
  Fpc98_assign_special_key, Spc98_assign_special_key, 0, 0, 0, "")
  ()
{
  extern int set98FunctionKey (void);
  if (EQ (Vdos_machine_type, Qpc98))
    set98FunctionKey ();
  return Qnil;
}

DEFUN ("pc98-cancel-special-key", 
  Fpc98_cancel_special_key, Spc98_cancel_special_key, 0, 0, 0, "")
  ()
{
  extern int restore98FunctionKey (void);
  if (EQ (Vdos_machine_type, Qpc98))
    restore98FunctionKey ();
  return Qnil;
}
#endif /* PC9801

/*
 *	Define everything
 */
syms_of_dosfns()
{
#ifdef IBMPC
  Qibmpc = intern ("ibmpc");
  staticpro (&Qibmpc);
#endif
#ifdef J3100
  Qj3100 = intern ("j3100");
  staticpro (&Qj3100);
#endif
#ifdef PC9801
  Qpc98 = intern ("pc98");
  staticpro (&Qpc98);
#endif

#if defined(SET_BREAK_CHECK_COUNT) && defined(CTRL_BREAK_INTERRUPTS)
  defsubr (&Semacs_set_break_checking);
#endif
  defsubr (&Ssubstitute_environment_vars);
  defsubr (&Smake_dos_filename);
  defsubr (&Sint86);

#ifdef __FLAT_WATCOMC__
  defsubr (&Semacs_stack_avail);
  defsubr (&Semacs_dpmi_info);
#endif	/* __FLAT_WATCOMC__ */
  defsubr (&Semacs_UTC_time);
  defsubr (&Semacs_pc_screen_p);
  defsubr (&Semacs_pc_25_line_mode);
  defsubr (&Semacs_pc_43_line_mode);
  defsubr (&Semacs_pc_50_line_mode);
  defsubr (&Semacs_pc_set_screen_mode);
  defsubr (&Semacs_pc_get_screen_mode);
#if defined(DEBUG_EMACS) && defined(__WATCOMC__)
  defsubr (&Semacs_debug_get_addresses);
#endif	/* DEBUG_EMACS */

#ifdef FEPCTRL	/* Demacs 1.1.8 91/11/29 Manabu Higashida */
  defsubr (&Sfep_init);
  defsubr (&Sfep_term);
  defsubr (&Sfep_on);
  defsubr (&Sfep_off);
  defsubr (&Sfep_force_on);
  defsubr (&Sfep_force_off);
#endif /* FEPCTRL */
#ifdef PC9801
  defsubr (&Spc98_assign_special_key);
  defsubr (&Spc98_cancel_special_key);
#endif

  DEFVAR_LISP ("dos-machine-type", &Vdos_machine_type, 
    "A symbol naming the dos-machine-type under which Emacs is running,\n\
\(such as `ibmpc'), or nil means running on dos generic mode.");
  /* Initialize `dos-machine-type'. */
#ifdef CANNOT_DUMP
  if (noninteractive)
#endif
    Vdos_machine_type = Qnil;

  DEFVAR_BOOL ("dos-inhibit-setdisk", &InhibitSetDisk,
    "*Non-nil means that changing current drive is inhibited.");
  InhibitSetDisk = 0;

#ifdef FEPCTRL /* Demacs 1.1.8 91/11/29 Manabu Higashida */
  DEFVAR_BOOL ("inhibit-fep-control", &InhibitFEPCtrl,
    "*Non-nil means that Kana-Kanji FEP control is inhibited.");
  InhibitFEPCtrl = 1;
#endif

  DEFVAR_BOOL ("emacs-pc-use-dos-input", &emacs_use_dos_input,
	       "*Non-nil means that Emacs will go through DOS to get input.\n\
Going through DOS to get input means that special (non-US) keyboard drivers\n\
may be used for 8-bit input, but it also means that the C-h and backspace\n\
keys perform the same function (typically `backward-delete-char').\n\
Setting this variable to nil tells Emacs to go through BIOS calls to obtain\n\
input.  This allows the use of C-h as the help key, but it may also prevent\n\
DOS keyboard drivers from working with Emacs.");
  emacs_use_dos_input = 0;
  
}


init_dosfns()
{
  set_base_display_segment();
  init_sysdep_dos();
}

#endif /* MSDOS */
