; -*-Emacs-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         ibmpc.el
; RCS:          $Header: $
; Description:  Key definition file for GNU Emacs
; Author:       Darryl Okahata
; Created:      Wed Mar 24 07:40:58 1993
; Modified:     Sat Aug 14 12:34:04 1993 (darrylo@home) darrylo@hostigos
; Language:     Emacs-Lisp
; Package:      N/A
; Status:       Experimental
;
; (C) Copyright 1993, Darryl Okahata, all rights reserved.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Generally, "function" key escape sequences are of the form:
;;
;;	ESC [ <modifier> <scan code>
;;
;; where "<modifier>" is a bitfield from 0-23 formed from the inclusive-OR
;; of:
;;
;;	0x01	- Right shift pressed
;;	0x02	- Left shift pressed
;;	0x04	- Ctrl key pressed
;;	0x08	- NOT USED
;;	0x10	- Alt key pressed
;;

(define-key function-key-map "\C-[[\C-@G" [home])
(define-key function-key-map "\C-[[\C-@O" [end])
(define-key function-key-map "\C-[[\C-@H" [up])
(define-key function-key-map "\C-[[\C-@P" [down])
(define-key function-key-map "\C-[[\C-@K" [left])
(define-key function-key-map "\C-[[\C-@M" [right])
(define-key function-key-map "\C-[[\C-@I" [prior])
(define-key function-key-map "\C-[[\C-@Q" [next])
(define-key function-key-map "\C-[[\C-@R" [insert])
(define-key function-key-map "\C-[[\C-@S" [del])

(define-key function-key-map "\C-[[\C-dw" [C-home])
(define-key function-key-map "\C-[[\C-du" [C-end])
(define-key function-key-map "\C-[[\C-d\C-d" [C-prior])
(define-key function-key-map "\C-[[\C-dv" [C-next])
(define-key function-key-map "\C-[[\C-ds" [C-left])
(define-key function-key-map "\C-[[\C-dt" [C-right])

(define-key function-key-map "\C-[[\C-@;" [f1])
(define-key function-key-map "\C-[[\C-@<" [f2])
(define-key function-key-map "\C-[[\C-@=" [f3])
(define-key function-key-map "\C-[[\C-@>" [f4])
(define-key function-key-map "\C-[[\C-@?" [f5])
(define-key function-key-map "\C-[[\C-@@" [f6])
(define-key function-key-map "\C-[[\C-@A" [f7])
(define-key function-key-map "\C-[[\C-@B" [f8])
(define-key function-key-map "\C-[[\C-@C" [f9])
(define-key function-key-map "\C-[[\C-@D" [f10])

(define-key function-key-map "\C-[[\C-ph" [M-f1])
(define-key function-key-map "\C-[[\C-pi" [M-f2])
(define-key function-key-map "\C-[[\C-pj" [M-f3])
(define-key function-key-map "\C-[[\C-pk" [M-f4])
(define-key function-key-map "\C-[[\C-pl" [M-f5])
(define-key function-key-map "\C-[[\C-pm" [M-f6])
(define-key function-key-map "\C-[[\C-pn" [M-f7])
(define-key function-key-map "\C-[[\C-po" [M-f8])
(define-key function-key-map "\C-[[\C-pp" [M-f9])
(define-key function-key-map "\C-[[\C-pq" [M-f10])

(define-key function-key-map "\C-[[\C-d^" [C-f1])
(define-key function-key-map "\C-[[\C-d_" [C-f2])
(define-key function-key-map "\C-[[\C-d`" [C-f3])
(define-key function-key-map "\C-[[\C-da" [C-f4])
(define-key function-key-map "\C-[[\C-db" [C-f5])
(define-key function-key-map "\C-[[\C-dc" [C-f6])
(define-key function-key-map "\C-[[\C-dd" [C-f7])
(define-key function-key-map "\C-[[\C-de" [C-f8])
(define-key function-key-map "\C-[[\C-df" [C-f9])
(define-key function-key-map "\C-[[\C-dg" [C-f10])

;; right shift keys:
(define-key function-key-map "\C-[[\C-aT" [S-f1])
(define-key function-key-map "\C-[[\C-aU" [S-f2])
(define-key function-key-map "\C-[[\C-aV" [S-f3])
(define-key function-key-map "\C-[[\C-aW" [S-f4])
(define-key function-key-map "\C-[[\C-aX" [S-f5])
(define-key function-key-map "\C-[[\C-aY" [S-f6])
(define-key function-key-map "\C-[[\C-aZ" [S-f7])
(define-key function-key-map "\C-[[\C-a[" [S-f8])
(define-key function-key-map "\C-[[\C-a\\" [S-f9])
(define-key function-key-map "\C-[[\C-a]" [S-f10])

;; left shift keys:
(define-key function-key-map "\C-[[\C-bT" [S-f1])
(define-key function-key-map "\C-[[\C-bU" [S-f2])
(define-key function-key-map "\C-[[\C-bV" [S-f3])
(define-key function-key-map "\C-[[\C-bW" [S-f4])
(define-key function-key-map "\C-[[\C-bX" [S-f5])
(define-key function-key-map "\C-[[\C-bY" [S-f6])
(define-key function-key-map "\C-[[\C-bZ" [S-f7])
(define-key function-key-map "\C-[[\C-b[" [S-f8])
(define-key function-key-map "\C-[[\C-b\\" [S-f9])
(define-key function-key-map "\C-[[\C-b]" [S-f10])

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar ibmpc-extended-map (make-keymap)
  "Keymap for IBM PC extended characters (ones that start with C-@)")

(defun execute-key-sequence (key)
  "Execute the key sequence given by KEY.
The key sequence must be complete, and must not contain multiple key
sequences." 
  (let ( (function (key-binding key)) )
    (if function
	(progn
	  (setq this-command function)
	  (call-interactively function)
	  )
      (progn
	(ding)
	)
      )
    )
  )

(defun pc-key-home ()
  "Execute the function bound to the C-a key."
  (interactive "")
  (execute-key-sequence "\^a")
  )

(defun pc-key-end ()
  "Execute the function bound to the C-e key."
  (interactive "")
  (execute-key-sequence "\^e")
  )

(defun pc-key-left ()
  "Execute the function bound to the C-b key."
  (interactive "")
  (execute-key-sequence "\^b")
  )

(defun pc-key-right ()
  "Execute the function bound to the C-f key."
  (interactive "")
  (execute-key-sequence "\^f")
  )

(defun pc-key-up ()
  "Execute the function bound to the C-p key."
  (interactive "")
  (execute-key-sequence "\^p")
  )

(defun pc-key-down ()
  "Execute the function bound to the C-n key."
  (interactive "")
  (execute-key-sequence "\^n")
  )

(defun pc-key-pgup ()
  "Execute the function bound to the ESC C-v key."
  (interactive "")
  (execute-key-sequence "\ev")
  )

(defun pc-key-pgdn ()
  "Execute the function bound to the C-v key."
  (interactive "")
  (execute-key-sequence "\^v")
  )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Make some minimal key assignments:
;;
(global-set-key [f1] 'help-for-help)		; F1
(global-set-key [home] 'pc-key-home)		; Home
(global-set-key [end] 'pc-key-end)		; End
(global-set-key [up] 'pc-key-up)		; Up arrow
(global-set-key [down] 'pc-key-down)		; Down arrow
(global-set-key [left] 'pc-key-left)		; Left arrow
(global-set-key [right] 'pc-key-right)		; Right arrow
(global-set-key [prior] 'pc-key-pgup)		; PgUp
(global-set-key [next] 'pc-key-pgdn)		; PgDn
(global-set-key [insert] 'overwrite-mode)	; Ins
(global-set-key [del] 'delete-char)		; Del
(global-set-key [C-home] 'beginning-of-buffer)	; Ctrl-Home
(global-set-key [C-end] 'end-of-buffer)		; Ctrl-End

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Make input and display 8bit.
;;

;; Not all keys are assigned in cmds.c, so...
(let ((i 128))
  (while (< i 160)
    (global-set-key (vector i) 'self-insert-command)
    (setq i (1+ i))))

;; Enable 8bit display.
(standard-display-8bit 128 255)

;;;; This really belongs in ~/_emacs
;; Enable 8bit input.
;(set-input-mode (car (current-input-mode))
;		(nth 1 (current-input-mode))
;		0)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Enable automatic horizontal scrolling, if `truncate-lines' is non-nil
;;

(add-hook 'post-command-hook 'auto-hscroll-hook)
