; -*-Emacs-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         ibmfaces.el
; RCS:          $Header: $
; Description:  This file is loaded when PC screen color faces are to be
;		enabled.
; Author:       Darryl Okahata
; Created:      Tue Jul  6 23:01:23 1993
; Modified:     Tue Jul 20 21:44:33 1993 (darrylo@home) darrylo@hostigos
; Language:     Emacs-Lisp
; Package:      N/A
; Status:       Experimental
;
; (C) Copyright 1993, Darryl Okahata, all rights reserved.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require 'faces)

(defun frame-list ()
  '(0))

(face-initialize)
;; (set-face-foreground (internal-get-face 'modeline nil) "black" 0)
;; (set-face-background (internal-get-face 'modeline nil) "white" 0)
(invert-face (internal-get-face 'modeline nil))
(set-face-foreground (internal-get-face 'bold) "brightwhite")
(set-face-foreground (internal-get-face 'bold-italic) "brightwhite")
(set-face-foreground (internal-get-face 'highlight) "brightwhite")
(set-face-background (internal-get-face 'highlight) "green")
(set-face-foreground (internal-get-face 'region) "yellow")
(set-face-background (internal-get-face 'region) "blue")
;(set-face-foreground (internal-get-face 'region) "brightwhite")
;(set-face-background (internal-get-face 'region) "white")
(set-face-foreground (internal-get-face 'underline) "green")
(set-face-foreground (internal-get-face 'secondary-selection) "brightwhite")
(set-face-background (internal-get-face 'secondary-selection) "lightgreen")

;;
(defun x-display-color-p ()
  t)

(defvar emacs-pc-translate-color-table
  '(
    ("DarkGoldenrod" . "brown")
    ("ForestGreen" . "green")
    ("OliveDrab2" . "green")
    ("RoyalBlue" . "blue")
    ("black" . "black")
    ("blue" . "blue")
    ("firebrick" . "red")
    ("grey" . "gray")
    ("grey30" . "gray")
    ("grey40" . "gray")
    ("magenta" . "red")
    ("purple" . "blue")
    ("red" . "red")
    )
  "")

(defun emacs-pc-translate-color (color)
  "Translate COLOR into a legal PC text color.
If COLOR is not recognized, it is returned unchanged; otherwise, the
translated PC text color is returned."
  (let ( (newcolor (assoc color emacs-pc-translate-color-table)) )
    (if newcolor
	(cdr newcolor)
      color)
    ))

(if (not (boundp 'emacs-pc-old-set-face-attribute-internal))
    (fset 'emacs-pc-old-set-face-attribute-internal
	  (symbol-function 'set-face-attribute-internal)))

(defun set-face-attribute-internal (faceID name value frame)
  ""
  (if (or (eq name 'foreground) (eq name 'background))
      (emacs-pc-old-set-face-attribute-internal faceID name
						(emacs-pc-translate-color
						 value)
						frame)
    (emacs-pc-old-set-face-attribute-internal faceID name value frame)
    ))

(provide 'ibmfaces)
