// NTXS.C

// (c) 1995 Microsoft Corporation. All rights reserved. 
// 		Developed by hip communications inc., http://info.hip.com/info/


#include <windows.h>
#define WIN32_LEAN_AND_MEAN

#include "EXTERN.h"
#include "perl.h"
#include "XSub.h"

#define CROAK croak

#define TMPBUFSZ 512

#define SUCCESSRETURNED(x)	(x == ERROR_SUCCESS)
#define REGRETURN(x) XSRETURN_IV(SUCCESSRETURNED(x))

#define SvHKEY(index) (HKEY)((unsigned long) SvIV(index))

#define SETIV(index,value) sv_setiv(ST(index), value)
#define SETPV(index,string) sv_setpv(ST(index), string)
#define SETPVN(index, buffer, length) sv_setpvn(ST(index), (char*)buffer, length)
#define SETHKEY(index, hkey)	SETIV(index,(long)hkey)

static time_t ft2timet(FILETIME *ft)
{
	SYSTEMTIME st;
	struct tm tm;

	FileTimeToSystemTime(ft, &st);
	tm.tm_sec = st.wSecond;
	tm.tm_min = st.wMinute;
	tm.tm_hour = st.wHour;
	tm.tm_mday = st.wDay;
	tm.tm_mon = st.wMonth - 1;
	tm.tm_year = st.wYear - 1900;
	tm.tm_wday = st.wDayOfWeek;
	tm.tm_yday = -1;
	tm.tm_isdst = -1;
	return mktime (&tm);
}

static BOOL GetAccountInfo(char *Account, char *Buf, LPDWORD Len)
{
	char SID[400];
	DWORD SIDLen;
	SID_NAME_USE snu;

	SIDLen = sizeof(SID);
	return(LookupAccountName(NULL,		// System (NULL = local)
							Account,	// Account name
							&SID,		// SID structure
							&SIDLen,	// Size of SID buffer
							Buf,		// Domain buffer
							Len,		// Domain buffer size
							&snu));		// SID name type
}

char *NTLoginNameStr = NULL;
char *NTDomainNameStr = NULL;
char *NTNodeNameStr = NULL;
char NTFsTypeStr[80];

static char thisFile[] = __FILE__;
static char unknown[] = "<Unknown>";

static void GetLoginName(void)
{
	char buffer[TMPBUFSZ];
	long len;
	len = sizeof(buffer);
	if(GetUserName(buffer, &len)) 
	{
		New(1901, NTLoginNameStr, len, char);
		strcpy(NTLoginNameStr, buffer);
	}
	else 
	{
		NTLoginNameStr = unknown;
	}
}

XS(NTPerlVersion)
{
	dSP;
	if(NTLoginNameStr == NULL)
		GetLoginName();

	PUSHMARK(sp);
	XPUSHs(newSVpv(NT_PERL_VERSION_NUMBER, strlen(NT_PERL_VERSION_NUMBER)));
	PUTBACK;

}

XS(NTGetLastError)
{
	dSP;
	DWORD dwError = GetLastError();
	PUSHMARK(sp);
	XPUSHs(newSViv(dwError));
	PUTBACK;

}

XS(NTLoginName)
{
	dSP;
	if(NTLoginNameStr == NULL)
		GetLoginName();

	PUSHMARK(sp);
	XPUSHs(newSVpv(NTLoginNameStr, strlen(NTLoginNameStr)));
	PUTBACK;

}

XS(NTNodeName)
{
	dSP;
	if(NTNodeNameStr == NULL)
	{
		char buffer[TMPBUFSZ];
		long len;
		len = sizeof(buffer);
		if(GetComputerName(buffer, &len)) 
		{
			New(1902, NTNodeNameStr, len, char);
			strcpy(NTNodeNameStr, buffer);
		}
		else 
		{
			NTNodeNameStr = unknown;
		}
	}

	PUSHMARK(sp);
	XPUSHs(newSVpv(NTNodeNameStr, strlen(NTNodeNameStr)));
	PUTBACK;

}

XS(NTDomainName)
{
	dSP;
	if(NTDomainNameStr == NULL)
	{
		char buffer[TMPBUFSZ];
		long len;
		len = sizeof(buffer);

		if(NTLoginNameStr == NULL)
			GetLoginName();

		if(GetAccountInfo(NTLoginNameStr, buffer, &len)) 
		{
			New(1903, NTDomainNameStr, len, char);
			strcpy(NTDomainNameStr, buffer);
		}
		else 
		{
			NTDomainNameStr = unknown;
		}
	}

	PUSHMARK(sp);
	XPUSHs(newSVpv(NTDomainNameStr, strlen(NTDomainNameStr)));
	PUTBACK;

}

XS(NTFsType)
{
	dSP;
	DWORD flags, fsnamelen;

	if(!GetVolumeInformation(NULL, NULL, 0, NULL, &fsnamelen, &flags, NTFsTypeStr, sizeof(NTFsTypeStr)))
		strcpy(NTFsTypeStr, unknown);

	PUSHMARK(sp);
	XPUSHs(newSVpv(NTFsTypeStr, strlen(NTFsTypeStr)));
	PUTBACK;

}

XS(NTRegCloseKey)
{
	dXSARGS;
	SV* sv = ST(0);

	if(items != 1) 
	{
		CROAK("usage: NTRegCloseKey($hkey);\n");
	}

	REGRETURN(RegCloseKey(SvHKEY(sv)));
}

XS(NTRegConnectRegistry)
{
	dXSARGS;
	HKEY handle;
	int length;

	if(items != 3) 
	{
		CROAK("usage: NTRegConnectRegistry($machine, $hkey, $handle);\n");
	}

	if(SUCCESSRETURNED(RegConnectRegistry((char *) SvPV(ST(0), length), SvHKEY(ST(1)), &handle))) 
	{
		SETHKEY(2,handle);
		XSRETURN_YES;
	}
	XSRETURN_NO;
}

XS(NTRegCreateKey)
{
	dXSARGS;
	HKEY handle;
	DWORD disposition;
	int length;
	long retval;

	if(items != 3) 
	{
		CROAK("usage: NTRegCreateKey($hkey, $subkey, $handle);\n");
	}


	retval =  RegCreateKeyEx(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
						NULL, &handle, &disposition);

	if(SUCCESSRETURNED(retval)) 
	{
		SETHKEY(2,handle);
		XSRETURN_YES;
	}
	XSRETURN_NO;
}

XS(NTRegCreateKeyEx)
{
	dXSARGS;

	int length;
	long retval;
	HKEY hkey, handle;
	char *subkey;
	char *class;
	DWORD options, disposition;
	REGSAM sam;
	SECURITY_ATTRIBUTES sa, *psa;

	if(items != 9) 
	{
		CROAK("usage: NTRegCreateKeyEx($hkey, $subkey, $reserved, $class, $options, $sam, "
				"$security, $handle, $disposition);\n");
	}

	hkey = SvHKEY(ST(0));
	subkey = (char *) SvPV(ST(1), length);
	class = (char *) SvPV(ST(3), length);
	options = (DWORD) ((unsigned long) SvIV(ST(4)));
	sam = (REGSAM) ((unsigned long) SvIV(ST(5)));
	psa = (SECURITY_ATTRIBUTES*) SvPV(ST(6), length);
	if(length != sizeof(SECURITY_ATTRIBUTES))
	{
		psa = &sa;
		memset(&sa, 0, sizeof(SECURITY_ATTRIBUTES));
		sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	}

	retval =  RegCreateKeyEx(hkey, subkey, 0, class, options, sam,
						psa, &handle, &disposition);

	if(SUCCESSRETURNED(retval)) 
	{
		if(psa == &sa)
			SETPVN(6, &sa, sizeof(sa));

		SETHKEY(7,handle);
		SETIV(8,disposition);
		XSRETURN_YES;
	}
	XSRETURN_NO;
}

XS(NTRegDeleteKey)
{
	dXSARGS;
	int length;

	if(items != 2) 
	{
		CROAK("usage: NTRegDeleteKey($hkey, $subkey);\n");
	}

	REGRETURN(RegDeleteKey(SvHKEY(ST(0)), (char *) SvPV(ST(1), length)));
}

XS(NTRegDeleteValue)
{
	dXSARGS;
	int length;

	if(items != 2) 
	{
		CROAK("usage: NTRegDeleteValue($hkey, $valname);\n");
	}

	REGRETURN(RegDeleteValue(SvHKEY(ST(0)), (char *) SvPV(ST(1), length)));
}

XS(NTRegEnumKey)
{
	dXSARGS;
	int length;

	char keybuffer[TMPBUFSZ];

	if(items != 3) 
	{
		CROAK("usage: NTRegEnumKey($hkey, $idx, $subkeyname);\n");
	}

	if(SUCCESSRETURNED(RegEnumKey(SvHKEY(ST(0)), SvIV(ST(1)), keybuffer, sizeof(keybuffer)))) 
	{
		SETPV(2, keybuffer);
		XSRETURN_YES;
	}
	XSRETURN_NO;
}

XS(NTRegEnumKeyEx)
{
	dXSARGS;
	int length;

	DWORD keysz, classsz;
	char keybuffer[TMPBUFSZ];
	char classbuffer[TMPBUFSZ];
	long retval;
	FILETIME filetime;

	if(items != 6) 			
	{
		CROAK("usage: NTRegEnumKeyEx($hkey, $idx, $subkeyname, $reserved, $class, $time);\n");
	}

	keysz = sizeof(keybuffer);
	classsz = sizeof(classbuffer);
	retval = RegEnumKeyEx(SvHKEY(ST(0)), SvIV(ST(1)), keybuffer, &keysz, 0,
							classbuffer, &classsz, &filetime);
	if(SUCCESSRETURNED(retval)) 
	{
		SETPV(2, keybuffer);
		SETPV(4, classbuffer);
		SETIV(5, ft2timet(&filetime));
		XSRETURN_YES;
	}
	XSRETURN_NO;
}

XS(NTRegEnumValue)
{
	dXSARGS;
	HKEY hkey;
	DWORD type, namesz, valsz;
	long retval;
	static HKEY last_hkey = INVALID_HANDLE_VALUE;
	static char *valbuf = NULL, *namebuf = NULL;
	static DWORD maxvalsz, maxnamesz;

	if(items != 6) 
	{
		CROAK("usage: NTRegEnumValue($hkey, $i, $name, $reserved, $type, $value);\n");
	}

	hkey = SvHKEY(ST(0));

	// If this is a new key, find out how big the maximum name and value sizes are and
	// allocate space for them. Free any old storage and set the old key value to the
	// current key.

	if(hkey != last_hkey) 
	{
		char class[TMPBUFSZ];
		DWORD classsz, subkeys, maxsubkey, maxclass, values, salen;
		FILETIME ft;
		classsz = sizeof(class);
		retval = RegQueryInfoKey(hkey, class, &classsz, 0, &subkeys, &maxsubkey, &maxclass,
							&values, &maxnamesz, &maxvalsz, &salen, &ft);

		if(!SUCCESSRETURNED(retval)) 
		{
			XSRETURN_NO;
		}
		if(valbuf)
			Safefree(valbuf);

		New(1903, valbuf, ++maxvalsz, char);

		if(namebuf)
			Safefree(namebuf);

		New(1903, namebuf, ++maxnamesz, char);
		last_hkey = hkey;
	}

	namesz = maxnamesz;
	valsz = maxvalsz;
	retval = RegEnumValue(hkey, SvIV(ST(1)), namebuf, &namesz, 0, &type, (LPBYTE) valbuf, &valsz);
	if(!SUCCESSRETURNED(retval)) 
	{
		XSRETURN_NO;
	}
	else 
	{
		// return includes the null terminator so delete it if REG_SZ, REG_MULTI_SZ or REG_EXPAND_SZ
		switch(type)
		{
			case REG_SZ:
			case REG_MULTI_SZ:
			case REG_EXPAND_SZ:
				--valsz;
				break;

			default:
				break;
		}

		SETPV(2, namebuf);
		SETIV(4, type);
		SETPVN(5, valbuf, valsz);
		XSRETURN_YES;
	}
}

XS(NTRegFlushKey)
{
	dXSARGS;

	if(items != 1) 
	{
		CROAK("usage: NTRegFlushKey($hkey);\n");
	}
	REGRETURN(RegFlushKey(SvHKEY(ST(0))));
}

XS(NTRegGetKeySecurity)
{
	dXSARGS;

	SECURITY_DESCRIPTOR sd;
	DWORD sdsz;

	if(items != 3) 
	{
		CROAK("usage: NTRegGetKeySecurity($hkey, $security_info, $security_descriptor);\n");
	}
	if(SUCCESSRETURNED(RegGetKeySecurity(SvHKEY(ST(0)), SvIV(ST(1)), &sd, &sdsz))) 
	{
		SETPVN(2, &sd, sdsz);
		XSRETURN_YES;
	}
	XSRETURN_NO;
}


XS(NTRegLoadKey)
{
	dXSARGS;
	int length;

	if(items != 3) 
	{
		CROAK("usage: NTRegLoadKey($hkey, $subkey, $filename);\n");
	}
	REGRETURN(RegLoadKey(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), (char *) SvPV(ST(2), length)));
}


XS(NTRegNotifyChangeKeyValue)
{
    CROAK("NTRegNotifyChangeKeyValue not yet implemented!\n");
}


XS(NTRegOpenKey)
{
	dXSARGS;
	int length;
	HKEY handle;

	if(items != 3) 
	{
		CROAK("usage: NTRegOpenKey($hkey, $subkey, $handle);\n");
	}

	if(SUCCESSRETURNED(RegOpenKey(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), &handle))) 
	{
		SETHKEY(2,handle);
		XSRETURN_YES;
	}
	XSRETURN_NO;
}

XS(NTRegOpenKeyEx)
{
	dXSARGS;
	int length;
	HKEY handle;

	if(items != 5) 
	{
		CROAK("usage: NTRegOpenKeyEx($hkey, $subkey, $reserved, $sam, $handle);\n");
	}

	if(SUCCESSRETURNED(RegOpenKeyEx(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), 
					0, (REGSAM) ((unsigned long) SvIV(ST(3))), &handle))) 
	{
		SETHKEY(4,handle);
		XSRETURN_YES;
	}
	XSRETURN_NO;
}

XS(NTRegQueryInfoKey)
{
	dXSARGS;
	int length;

	char class[TMPBUFSZ];
	DWORD subkeys, maxsubkey, maxclass, values, maxvalname, maxvaldata;
	DWORD seclen, classsz;
	FILETIME ft;
	long retval;

	if(items != 10) 
	{
		CROAK("usage: NTRegQueryInfoKey($hkey, $class, $numsubkeys, $maxsubkey,"
				"$maxclass, $values, $maxvalname, $maxvaldata, $secdesclen,"
					"$lastwritetime);\n");
	}

	classsz = sizeof(class);
	retval = RegQueryInfoKey(SvHKEY(ST(0)), class, &classsz, 0, &subkeys, &maxsubkey,
								&maxclass, &values, &maxvalname, &maxvaldata,
									&seclen, &ft);
	if(SUCCESSRETURNED(retval)) 
	{
		SETPV(1, class);
		SETIV(2, subkeys);
		SETIV(3, maxsubkey);
		SETIV(4, maxclass);
		SETIV(5, values);
		SETIV(6, maxvalname);
		SETIV(7, maxvaldata);
		SETIV(8, seclen);
		SETIV(9, ft2timet(&ft));
		XSRETURN_YES;
	}
	XSRETURN_NO;
}

XS(NTRegQueryValue)
{
	dXSARGS;
	int length;

	unsigned char databuffer[TMPBUFSZ*2];
	DWORD datasz = sizeof(databuffer);

	if(items != 3) 
	{
		CROAK("usage: NTRegQueryValue($hkey, $valuename, $data);\n");
	}

	if(SUCCESSRETURNED(RegQueryValue(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), databuffer, &datasz))) 
	{
		// return includes the null terminator so delete it
		SETPVN(2, databuffer, --datasz);
		XSRETURN_YES;
	}
	XSRETURN_NO;
}

XS(NTRegQueryValueEx)
{
	dXSARGS;
	int length;

	unsigned char databuffer[TMPBUFSZ*2];
	DWORD datasz = sizeof(databuffer);
	DWORD type;

	if(items != 5) 
	{
		CROAK("usage: NTRegQueryValueEx($hkey, $valuename, $reserved, $type, $data);\n");
	}

	if(SUCCESSRETURNED(RegQueryValueEx(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), 0, &type, databuffer, &datasz))) 
	{
		// return includes the null terminator so delete it if REG_SZ, REG_MULTI_SZ or REG_EXPAND_SZ
		switch(type)
		{
			case REG_SZ:
			case REG_MULTI_SZ:
			case REG_EXPAND_SZ:
				--datasz;
				break;

			default:
				break;
		}

		SETIV(3, type);
		SETPVN(4, databuffer, datasz);
		XSRETURN_YES;
	}
	XSRETURN_NO;
}


XS(NTRegReplaceKey)
{
	dXSARGS;
	int length;

	if(items != 4) 
	{
		CROAK("usage: NTRegReplaceKey($hkey, $subkey, $newfile, $oldfile);\n");
	}
	REGRETURN(RegReplaceKey(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), (char *) SvPV(ST(2), length), (char *) SvPV(ST(3), length)));
}

XS(NTRegRestoreKey)
{
	dXSARGS;
	int length;

	if(items < 2 || items > 3) 
	{
		CROAK("usage:NTRegRestoreKey($hkey, $filename [, $flags]);\n");
	}
	REGRETURN(RegRestoreKey(SvHKEY(ST(0)), (char*)SvPV(ST(1), length), (DWORD)((items == 3) ? SvIV(ST(2)) : 0)));
}

XS(NTRegSaveKey)
{
	dXSARGS;
	int length;

	if(items != 2) 
	{
		CROAK("usage: NTRegSaveKey($hkey, $filename);\n");
	}
	REGRETURN(RegSaveKey(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), NULL));
}

XS(NTRegSetKeySecurity)
{
	dXSARGS;
	int length;

	if(items != 3) 
	{
		CROAK("usage: NTRegSetKeySecurity($hkey, $security_info, $security_descriptor);\n");
	}
	REGRETURN(RegSetKeySecurity(SvHKEY(ST(0)), SvIV(ST(1)), (SECURITY_DESCRIPTOR*)SvPV(ST(2), length)));
}

XS(NTRegSetValue)
{
	dXSARGS;
	int length;

	int size;
	char *buffer;

	if(items != 4) 
	{
		CROAK("usage: NTRegSetValue($hkey, $subKey, $type, $data);\n");
	}
	
	if(SvIV(ST(2)) != REG_SZ)
	{
		CROAK("NTRegSetValue: Type was not REG_SZ, cannot set %s\n", (char *) SvPV(ST(1), length));
	}

	buffer = (char *) SvPV(ST(3), size);
	REGRETURN(RegSetValue(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), REG_SZ, (PBYTE) buffer, size));
}

XS(NTRegSetValueEx)
{
	dXSARGS;
	int length;

	DWORD type;
	DWORD val;
	int size;
	char *buffer;

	if(items != 5) 
	{
		CROAK("usage: NTRegSetValueEx($hkey, $valname, $reserved, $type, $data);\n");
	}
	type = (DWORD) SvIV(ST(3));
	switch (type) 
	{
		case REG_SZ:
		case REG_BINARY:
		case REG_MULTI_SZ:
		case REG_EXPAND_SZ:
			buffer = (char *) SvPV(ST(4), size);
			if(type != REG_BINARY)
				size++; // include null terminator in size

			REGRETURN(RegSetValueEx(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), 0, type, (PBYTE) buffer, size));
			break;

		case REG_DWORD_BIG_ENDIAN:
		case REG_DWORD_LITTLE_ENDIAN: // Same as REG_DWORD
			val = (DWORD) SvIV(ST(4));
			REGRETURN(RegSetValueEx(SvHKEY(ST(0)), (char *) SvPV(ST(1), length), 0, type, (PBYTE) &val, sizeof(DWORD)));
			break;

		default:
			CROAK("NTRegSetValueEx: Type not specified, cannot set %s\n", (char *) SvPV(ST(1), length));
	}
}


XS(NTRegUnloadKey)
{
	dXSARGS;
	int length;

	if(items != 2) 
	{
		CROAK("usage: NTRegUnLoadKey($hkey, $subkey);\n");
	}

	REGRETURN(RegUnLoadKey(SvHKEY(ST(0)), (char *) SvPV(ST(1), length)));
}

typedef struct _EvtLogCtlBuf
{
	DWORD  dwID;					// id for mem block
	HANDLE hLog;					// event log handle
	LPBYTE BufPtr;					// pointer to data buffer
	DWORD  BufLen;					// size of buffer
	DWORD  NumEntries;				// number of entries in buffer
	DWORD  CurEntryNum;				// next entry to return
	EVENTLOGRECORD *CurEntry;		// point to next entry to return
	DWORD  Flags;					// read flags for ReadEventLog
} EvtLogCtlBuf, *lpEvtLogCtlBuf;

#define EVTLOGBUFSIZE 1024
#define EVTLOGID		((DWORD)0x674c7645L)
#define SvEvtLog(x)	(lpEvtLogCtlBuf) ((unsigned long)SvIV(x))

XS(NTOpenEventLog)
{
	dXSARGS;
	int length;
	lpEvtLogCtlBuf lpEvtLog;

	if(items != 3)
	{
		CROAK("usage: NTOpenEventLog($handle, $server, $source);\n");
	}

	New(1908, (char *)lpEvtLog, sizeof(EvtLogCtlBuf), char);
	lpEvtLog->BufLen = EVTLOGBUFSIZE;
	New(1908, lpEvtLog->BufPtr, lpEvtLog->BufLen, char);

	if(lpEvtLog->hLog = OpenEventLog((char *) SvPV(ST(1), length), (char *) SvPV(ST(2), length))) 
	{
		// return info...
		lpEvtLog->dwID			= EVTLOGID;
		lpEvtLog->NumEntries	= 0;
		lpEvtLog->CurEntryNum	= 0;
		lpEvtLog->CurEntry		= NULL;
		lpEvtLog->Flags			= 0;
		SETIV(0, ((unsigned long)lpEvtLog));
		XSRETURN_YES;
	}
	else 
	{
		// Open failed...
		if(lpEvtLog->BufPtr)
			Safefree(lpEvtLog->BufPtr);
		Safefree(lpEvtLog);
		XSRETURN_NO;
	}
}

XS(NTCloseEventLog)
{
	dXSARGS;
	int length;
	lpEvtLogCtlBuf lpEvtLog;

	if(items != 1)
	{
		CROAK("usage: NTCloseEventLog($handle);\n");
	}

	lpEvtLog = SvEvtLog(ST(0));
	if((lpEvtLog != NULL) || (lpEvtLog->dwID == EVTLOGID)) 
	{
		if(CloseEventLog(lpEvtLog->hLog)) 
		{
			if(lpEvtLog->BufPtr)
				Safefree(lpEvtLog->BufPtr);
			Safefree(lpEvtLog);
			XSRETURN_YES;
		}
	}
	XSRETURN_NO;
}

XS(NTGetNumberOfEventLogRecords)
{
	dXSARGS;
	lpEvtLogCtlBuf lpEvtLog;
	DWORD Num;

	if(items != 2)
	{
		CROAK("usage: NTGetNumEventRecords($handle, $number);\n");
	}
	lpEvtLog = SvEvtLog(ST(0));
	if((lpEvtLog != NULL) || (lpEvtLog->dwID == EVTLOGID)) 
	{
		if(GetNumberOfEventLogRecords(lpEvtLog->hLog, &Num)) 
		{
			SETIV(1, Num);
			XSRETURN_YES;
		} 
	}
	XSRETURN_NO;
}

XS(NTReadEventLog)
{
	dXSARGS;
	int length;
	lpEvtLogCtlBuf lpEvtLog;

	if(items != 9)
	{
		CROAK("usage: NTReadEventLog($handle, $flags, $rec, $evtHeader, $SourceName, $ComputerName, $sid, $data, $strings);\n");
	}
	lpEvtLog = SvEvtLog(ST(0));
	if((lpEvtLog != NULL) || (lpEvtLog->dwID == EVTLOGID)) 
	{
		DWORD Flags, Record, NumRead, Required;
		long retval;
		Flags = SvIV(ST(1));
		if(Flags != lpEvtLog->Flags) 
		{
			// Reset to new read mode & force a re-read call
			lpEvtLog->Flags      = Flags;
			lpEvtLog->NumEntries = 0;
		}
		Record = SvIV(ST(2));
		if((lpEvtLog->NumEntries == 0) || (Record != 0)) 
		{
			if(ReadEventLog(lpEvtLog->hLog, Flags, Record, lpEvtLog->BufPtr,
								lpEvtLog->BufLen, &NumRead, &Required)) 
			{
				lpEvtLog->NumEntries = NumRead;
			}
			else 
			{
				lpEvtLog->NumEntries = 0;
				GetLastError();
			}
			lpEvtLog->CurEntryNum = 0;
			lpEvtLog->CurEntry    = (EVENTLOGRECORD*)lpEvtLog->BufPtr;
		}

		if(lpEvtLog->CurEntryNum < lpEvtLog->NumEntries) 
		{
			char *name;
			EVENTLOGRECORD *LogBuf;
			LogBuf = lpEvtLog->CurEntry;        
			SETPVN(3, (char*)LogBuf, LogBuf->Length);
			name = ((LPBYTE)LogBuf)+sizeof(EVENTLOGRECORD);
			SETPV(4, name);
			name += strlen(name)+1; // step over NULL
			SETPV(5, name);
			SETPVN(6, ((LPBYTE)LogBuf)+LogBuf->UserSidOffset, LogBuf->UserSidLength);
			SETPVN(7, ((LPBYTE)LogBuf)+LogBuf->DataOffset, LogBuf->DataLength);
			SETPVN(8, ((LPBYTE)LogBuf)+LogBuf->StringOffset, LogBuf->DataOffset-LogBuf->StringOffset);

			// to next entry in buffer
			lpEvtLog->CurEntryNum += LogBuf->Length;
			lpEvtLog->CurEntry = (EVENTLOGRECORD*)(((LPBYTE)LogBuf) + LogBuf->Length);
			if(lpEvtLog->CurEntryNum == lpEvtLog->NumEntries) 
			{
				lpEvtLog->NumEntries  = 0;
				lpEvtLog->CurEntryNum = 0;
				lpEvtLog->CurEntry    = NULL;
			}
			XSRETURN_YES;
		}
	}
	XSRETURN_NO;
}


XS(NTWriteEventLog)
{
	dXSARGS;
	int bufLength, dataLength, index;
	char *server, *source, *buffer, *data, **array;
	HANDLE hLog;
	BOOL bSuccess = FALSE;

	if(items < 8)
	{
		CROAK("usage: NTWriteEventLog($server, $source, $eventType, $category, $eventID, $reserved, $data, $message1, ...);\n");
	}

	server = SvPV(ST(0), bufLength);
	if(bufLength == 0)
		server = NULL;

	source = SvPV(ST(1), bufLength);
	if((hLog = RegisterEventSource(server, source)) != NULL)
	{
		data = SvPV(ST(6), dataLength);
		New(3101, array, items - 7, char*);
		for(index = 0; index < items - 7; ++index)
		{
			buffer = SvPV(ST(index+7), bufLength);
			array[index] = buffer;
		}
		if(ReportEvent(hLog,		// handle returned by RegisterEventSource
					SvIV(ST(2)),	// event type to log
					SvIV(ST(3)),	// event category
					SvIV(ST(4)),	// event identifier
					NULL,			// user security identifier (optional)
					items - 7,		// number of strings to merge with message
					dataLength,		// size of raw (binary) data (in bytes)
					array,			// array of strings to merge with message 
					data			// address of binary data 
				))
		{
			bSuccess = TRUE;
		}
		Safefree(array);
		DeregisterEventSource(hLog);
	}
	XSRETURN_IV(bSuccess);
}


void NTInit()
{
	// Instantiate our extension subroutines
	newXS("NTGetLastError", NTGetLastError, thisFile);

	newXS("NTPerlVersion", NTPerlVersion, thisFile);

	newXS("NTLoginName", NTLoginName, thisFile);
	newXS("NTNodeName", NTNodeName, thisFile);
	newXS("NTDomainName", NTDomainName, thisFile);
	newXS("NTFsType", NTFsType, thisFile);

	newXS("NTRegCloseKey", NTRegCloseKey, thisFile);
	newXS("NTRegConnectRegistry", NTRegConnectRegistry, thisFile);
	newXS("NTRegCreateKey", NTRegCreateKey, thisFile);
	newXS("NTRegCreateKeyEx", NTRegCreateKeyEx, thisFile);
	newXS("NTRegDeleteKey", NTRegDeleteKey, thisFile);
	newXS("NTRegDeleteValue", NTRegDeleteValue, thisFile);

	newXS("NTRegEnumKey", NTRegEnumKey, thisFile);
	newXS("NTRegEnumKeyEx", NTRegEnumKeyEx, thisFile);
	newXS("NTRegEnumValue", NTRegEnumValue, thisFile);

	newXS("NTRegFlushKey", NTRegFlushKey, thisFile);
	newXS("NTRegGetKeySecurity", NTRegGetKeySecurity, thisFile);

	newXS("NTRegLoadKey", NTRegLoadKey, thisFile);
//	newXS("NTRegNotifyChangeKeyValue", NTRegNotifyChangeKeyValue, thisFile);
	newXS("NTRegOpenKey", NTRegOpenKey, thisFile);
	newXS("NTRegOpenKeyEx", NTRegOpenKeyEx, thisFile);
	newXS("NTRegQueryInfoKey", NTRegQueryInfoKey, thisFile);
	newXS("NTRegQueryValue", NTRegQueryValue, thisFile);
	newXS("NTRegQueryValueEx", NTRegQueryValueEx, thisFile);

	newXS("NTRegReplaceKey", NTRegReplaceKey, thisFile);
	newXS("NTRegRestoreKey", NTRegRestoreKey, thisFile);
	newXS("NTRegSaveKey", NTRegSaveKey, thisFile);
	newXS("NTRegSetKeySecurity", NTRegSetKeySecurity, thisFile);
	newXS("NTRegSetValue", NTRegSetValue, thisFile);
	newXS("NTRegSetValueEx", NTRegSetValueEx, thisFile);
	newXS("NTRegUnloadKey", NTRegUnloadKey, thisFile);

	newXS("NTOpenEventLog", NTOpenEventLog, thisFile);
	newXS("NTCloseEventLog", NTCloseEventLog, thisFile);
	newXS("NTGetNumberOfEventLogRecords", NTGetNumberOfEventLogRecords, thisFile);
	newXS("NTReadEventLog", NTReadEventLog, thisFile);
	newXS("NTWriteEventLog", NTWriteEventLog, thisFile);

}



