// sys/socket.h

// djl
// Provide UNIX compatibility


#ifndef  _INC_SYS_SOCKET
#define  _INC_SYS_SOCKET


#ifndef  _WINDOWS_
#define  _WINDOWS_

#define  FAR
#define  PASCAL     __stdcall
#define  WINAPI     __stdcall

#undef WORD
typedef  int        BOOL;
typedef  unsigned short WORD;
typedef  void*      HANDLE;
typedef  void*      HWND;
typedef  int (FAR WINAPI *FARPROC)();

typedef unsigned long       DWORD;
typedef void *PVOID;

#define IN
#define OUT

typedef struct _OVERLAPPED {
    DWORD   Internal;
    DWORD   InternalHigh;
    DWORD   Offset;
    DWORD   OffsetHigh;
    HANDLE  hEvent;
} OVERLAPPED, *LPOVERLAPPED;

#endif //_WINDOWS_


#include <winsock.h>

#define  ENOTSOCK	WSAENOTSOCK
#undef   HOST_NOT_FOUND


#define socket		nt_socket
#define bind		nt_bind
#define listen		nt_listen
#define accept		nt_accept
#define connect		nt_connect
#define send		nt_send
#define sendto		nt_sendto
#define recv		nt_recv
#define recvfrom	nt_recvfrom
#define shutdown	nt_shutdown
#define ioctlsocket	nt_ioctlsocket
#define setsockopt	nt_setsockopt
#define getsockopt	nt_getsockopt
#define getpeername	nt_getpeername
#define getsockname	nt_getsockname
#define gethostname	nt_gethostname
#define gethostbyname	nt_gethostbyname
#define gethostbyaddr	nt_gethostbyaddr
#define getprotobyname	nt_getprotobyname
#define getprotobynumber nt_getprotobynumber
#define getservbyname	nt_getservbyname
#define getservbyport	nt_getservbyport
#define select		nt_select

#define SOCKET		int
#define SOCKADDR	struct sockaddr
#define HOSTENT		struct hostent
#define PROTOENT	struct protoent
#define SERVENT		struct servent

SOCKET	    nt_socket(		int af, int type, int protocol);
int	    nt_bind(		SOCKET s, SOCKADDR* addr, int addrlen);
int	    nt_listen(		SOCKET s, int backlog);
SOCKET	    nt_accept(		SOCKET s, SOCKADDR* addr, int* addrlen);
int	    nt_connect(		SOCKET s, SOCKADDR* addr, int  addrlen);
int	    nt_send(		SOCKET s, char* buf, int len, int flags);
int	    nt_sendto(		SOCKET s, char* buf, int len, int flags, SOCKADDR* to,   int tolen);
int	    nt_recv (		SOCKET s, char* buf, int len, int flags);
int	    nt_recvfrom(	SOCKET s, char* buf, int len, int flags, SOCKADDR* from, int* fromlen);
int	    nt_shutdown(	SOCKET s, int how);
int	    nt_ioctlsocket(	SOCKET s, long cmd, u_long* argp);
int	    nt_setsockopt(	SOCKET s, int level, int optname, char* optval, int  optlen);
int	    nt_getsockopt(	SOCKET s, int level, int optname, char* optval, int* optlen);
int	    nt_getpeername(	SOCKET s, SOCKADDR* addr, int* addrlen);
int	    nt_getsockname(	SOCKET s, SOCKADDR* addr, int* addrlen);
int	    nt_gethostname (	char* name, int len);
HOSTENT*	nt_gethostbyname(	char* name);
HOSTENT*	nt_gethostbyaddr(	char* addr, int len, int type);
PROTOENT*	nt_getprotobyname(	char* name);
PROTOENT*	nt_getprotobynumber(int num);
SERVENT*	nt_getservbyname(	char* name, char* proto);
SERVENT*	nt_getservbyport(	int port, char* proto);
long		nt_select(		int nfds, fd_set* rd, fd_set* wr, fd_set* ex, struct timeval* timeout);

extern int sys_nerr;
extern char* sys_errlist[];
extern char* nt_strerror(int);

#define strerror(e) nt_strerror(e)

char* nt_strerror(int e);


void endhostent();
void endnetent();
void endprotoent();
void endservent();
struct netent *getnetent (void);
struct netent *getnetbyname(char *name);
struct netent *getnetbyaddr(long net, int type);
struct protoent *getprotoent (void);
struct servent *getservent (void);
void sethostent (int stayopen);
void setnetent (int stayopen);
void setprotoent (int stayopen);
void setservent (int stayopen);


#endif	// _INC_SYS_SOCKET
