@rem = '--*-Perl-*--';
@rem = '
@echo off
perl -s -S %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
@rem ';

# (c) 1995 Microsoft Corporation. All rights reserved.
#         Developed by hip communications inc., http://info.hip.com/info

# WYT 1995-05-15 Wei-Yuen Tan (wyt@hip.com) created

# DCH 1995-05-19 Changed output for unsupported parameter types

# WYT 1995-05-21 100% rewritten.

# WYT 1995-05-24 Added the HTML docs generation.

# WYT 1995-05-25 Dynamically looks up and caches function/variable ID.

# WYT 1995-05-?? - generate txt as well as HTML docs.

# WYT 1995-06-04 - fixed for multiple arguments, modified to cope with
#                multiple CoClasses within an ITypeLib object.

## TODO

# XXX - Auto-generation of Windows Help files.


require 'NT.ph' || die $!;
require 'ctime.pl' || warn $!;

$usage = <<'--end--';
Usage:
    MkOLEx -h              Get this help message

    MkOLEx <typelib file> [ <typelib file> ... ]
                    Generate perl OLE objects from type libraries

    MkOLEx <class name>   [ <class name> ... ]
                    Generate perl OLE objects from object classes
--end--


sub main {
    my $object;
    my $date = ctime( time );
    local( $libdir ) = &getlibdir;

    `mkdir $libdir\\OLE` unless ( -d "$libdir/OLE" );

    &openlogfile( $libdir );

    if ( $h || ! @ARGV ) {
        print $usage;
    } else {
        &log( $date );
        foreach ( @ARGV ) {
            my( $classname, $packagename, $variables, $functions,
	       $funcparams );

            if ( /\.(olb|tlb)$/ && -f $_ ) {

                &log( "Generating module from typelib file $_\n" );

		@modules = &groktypelib( $_ );
		foreach $module ( @modules ) {
		    ( $classname, $variables, $functions, $funcparams )
			= @$module;
		    $packagename
			= &makemodule( $classname, $variables, $functions );
                &makedocs( $packagename, $variables, $funcparams );

		}

            } elsif ( NTOLECreateObject( $_, $object ) ) {
                &log( "Generating module from classname $_\n" );
                ( $classname, $variables, $functions, $funcparams )
                    = &grokappclass( $object, $_ );
                $packagename = &makemodule( $classname, $variables, $functions );
                &makedocs( $packagename, $variables, $funcparams );

            } else {
                &log( "Unrecognized argument \"$_\". Type \"MkOLEx -h\" for help\n" );
            }
        }
    }
}    

sub getlibdir {
    my( $hkey, $type );
    NTRegOpenKey( &HKEY_LOCAL_MACHINE, 'SOFTWARE\Microsoft\Resource Kit\PERL5',
        $hkey ) || return undef;
    NTRegQueryValueEx( $hkey, 'PRIVLIB', &NULL, $type, $libdir ) ||
        return undef;
    return $libdir;
}

sub openlogfile {
    my( $libdir ) = @_;
    open( LOGFILE, ">>$libdir/OLE/MkOLEx.log" )
        || warn "Couldn't open log file!\n";
    print LOGFILE "\n\n";
    print STDERR "Logfile $libdir\\OLE\\MkOLEx.log opened for append\n";
}

sub log {
    my( $message ) = @_;
    print STDERR $message;
    print LOGFILE $message;
}

sub groktypelib {
    my( $typelibfile ) = @_;
    my( $object, $count, $dispString, $funcCount, $varCount );
    my( $i, @modules );


    NTOLECreateTypeLib( $typelibfile, $object, $count );

    for $i ( 0 .. $count - 1 ) {
	if ( NTOLETypeLibGetDispatchIndex( $object, $i, $dispString,
					  $funcCount, $varCount ) ) {
	    
	    &log( "$dispString has $funcCount functions and $varCount variables\n" );
	    push( @modules,
		 [ &enumerateclass( $object, $dispString, $funcCount,
				   $varCount ) ]
		 );
	}
    }
    return @modules;
}

sub grokappclass {
    my( $object, $classname ) = @_;
    my( $funcCount, $varCount );

    NTOLETypeInfo( $object, $funcCount, $varCount );
    &log( "$classname has $funcCount functions and $varCount variables\n" );
    &enumerateclass( $object, $classname, $funcCount, $varCount );
}

sub enumerateclass {
    my( $object, $classname, $funcCount, $varCount ) = @_;
    my( $i, $j, %seen,

        $badvars, $badfuncs,

        %variables,
        $varName, $varMEMBERID, $varType,

        $varDocStr, $varHelpID, $varHelpFile,

        %functions, %funcparams,
        $funcName, $funcDISPID, $funcReturnType, $paraCount, $funcMagic,
        $paraName, $paraType, $funcArray,
        $paramArray,

        $funcDocStr, $funcHelpID, $funcHelpFile,

        );

    $badvars = 0;
    $badfuncs = 0;

    &log( "Creating module for class $classname\n" );

   VARLOOP:
    for( $i = 0; $i < $varCount; $i++ ) {
        NTOLETypeInfoVar( $object, $i, $varName, $varMEMBERID, $varType,
       $varDocStr, $varHelpID, $varHelpFile ) ||
            next VARLOOP;
        unless( NTOLESupportedType( $varType )) {
            &log( "Variable $varName is of unsupported type $varType\n" );
            $badvars++;
            next VARLOOP;
        }
        $variables{ $varName } = [ $varName, $varMEMBERID, $varType ];
    }

   FUNCLOOP:
    for( $i = 0; $i < $funcCount; $i++ ) {
        NTOLETypeInfoFunc( $object, $i, $funcName, $funcDISPID, $funcReturnType,
            $paraCount, $funcMagic, $funcDocStr, $funcHelpID, $funcHelpFile )
                || next FUNCLOOP;

        $funcparams{ $funcName }{ $paraCount } = $paramArray = [];

        for( $j = 0; $j < $paraCount; $j++ ) {
            NTOLETypeInfoFuncInfo( $object, $i, $j, $paraName, $paraType )
                || next FUNCLOOP;
            unless ( NTOLESupportedType( $paraType )) {
                &log( "Function $funcName has unsupported parameter $paraName of type $paraType\n" );
                $badfuncs++;
                next FUNCLOOP;
            }
            push( @$paramArray, $paraName, $paraType );
        }
        $functions{ $funcName } = [ $funcName, $funcDISPID, $funcReturnType ]
            unless ( $seen{ $funcName }++ );
        $funcArray = $functions{ $funcName };
        push( @$funcArray, $paraCount, $funcMagic );
    }
    &log( "$classname has $badvars unsupported Variables and $badfuncs unsupported Functions\n" );
    return( $classname, \%variables, \%functions, \%funcparams );
}


sub makemodule {
    my( $classname, $variables, $functions ) = @_;
    my( %variables, %functions,
        $packagename,
        $varName, $varMEMBERID, $varType, $array,
        $funcName, $funcDISPID, $funcReturnType
       );

    my( $version ) = NTPerlVersion();

    %variables = %$variables;
    %functions = %$functions;

    $packagename = $classname;  
    $packagename =~ s/[^\w\d]/_/g;

    unless( open( OUTPUT, ">$libdir/OLE/$packagename.pm" ) ) {
        warn $!;
        return undef;
    }
    select( OUTPUT );

    print <<"--end--";
#
# Auto-generated OLE Automation module
#
# OLE object type : $packagename
#   
#   Edit at your own risk!!
#

package OLE::$packagename;

%symboltable;

sub CreateObject {
    unless ( main::NTPerlVersion() eq '$version' ) {
        warn \"Module $packagename was generated with obsolete version $version!\";
        \$myversion = main::NTPerlVersion();
        warn \"My Version is \$myversion\";
    }
    my \$o;
    main::NTOLECreateObject( '$classname', \$o )
        || return undef;
    my \$s = {};
    \$s->{ 'o' } = \$o
        || return undef;
    bless \$s;
}

sub DestroyObject {
    my \$s = shift;
    main::NTOLEDestroyObject( \$s->{ 'o' } );
}

sub DESTROY {
    my \$s = shift;
    main::NTOLEDestroyObject( \$s->{ 'o' } );
}

sub gripe {
    warn \"Incorrect number of arguments supplied to function \@_!!\";
}

sub myID {
    my( \$object, \$funcName ) = \@_;
    \$symboltable{ \$funcName } ||
        main::NTOLEGetIDofName( \$object, \"\$funcName\\000\", \$id ) ?
            \$symboltable{ \$funcName } = \$id : undef;
}

sub myID {
    my( \$object, \$funcName ) = \@_;
    if ( defined \$symboltable{ \$funcName } ) {
	return \$symboltable{ \$funcName };
    } else {
      main::NTOLEGetIDofName( \$object, "\$funcName\000", \$id );
	return \$id;
    }
   
}

--end--
    
    foreach( sort( keys( %variables ) ) ) {
        $array = $variables{ $_ };
        ( $varName, $varMEMBERID, $varType ) = @$array;
	print <<"--end--";
sub Get$varName {
    my( \$s ) = shift;
    my( \$vR ) = \@_;
    main::NTOLEPropertyGet( \$s{ 'o' }, &myID( '$varName' ), $varType, \$vR )
        || return undef;
    return \$vR;
}

sub Set$varName {
    my( \$s ) = shift;
    my( \$vV ) = \@_;
    main::NTOLEPropertyPut( \$s{ 'o' }, &myID( '$varName' ), $varType, \$vV );
}

--end--

    }        

    foreach( sort( keys( %functions ) ) ) {

        $array = $functions{ $_ };
        ( $funcName, $funcDISPID, $funcReturnType, @params ) = @$array;

        print "
sub $funcName {
    my( \$s ) = shift;
    my( \$fR, \$fM );";

        ( $paraCount, $funcMagic ) = splice( @params, 0, 2 );

        print "
    if ( \$#_ == $paraCount - 1 ) {
        \$fM = '$funcMagic';
    }";

        while ( ( $paraCount, $funcMagic ) = splice( @params, 0, 2 ) ) {
            print
    " elsif ( \$#_ == $paraCount - 1 ) {
        \$fM = '$funcMagic';
    }";
        }

        print
    " else {
        &gripe( \"$funcName()\" );
        return undef;
    }        
    main::NTOLEMethod( \$s->{ 'o' }, \$fM, &myID( \$s->{ 'o' }, '$funcName' ), \$fR, \@_ ) ?
         \$fR : undef;
}
";
    }    
    print "\n\n1;\n";
    close( OUTPUT );

    &log( "$libdir\\OLE\\$packagename.pm created successfully\n" );

    return $packagename;

}

sub numerically { $a <=> $b };

sub makedocs {

    my( $packagename, $variables, $funcparams ) = @_;
    my( %variables, %funcparams,
        $varArray, %typehash,

	$varName, $varMEMBERID, $varType,
        $hash, %hash, $array, @array,
        $paraname, $paraType,
        
        $docdir, $type

        );

    %variables = %$variables;
    %funcparams = %$funcparams;

    NTRegOpenKey( &HKEY_LOCAL_MACHINE, 'SOFTWARE\Microsoft\Resource Kit\PERL5',
                    $hkey );
    NTRegQueryValueEx( $hkey, 'HTML-DOCS', &NULL, $type, $docdir );

    $docdir || warn "Couldn't open output directory for help document!\n";
    `mkdir $docdir\\OLE` unless ( -d "$docdir/ole" );

    print STDERR "Packagename is: $packagename\n";

    open( HTMLFILE, ">$docdir/ole/$packagename.htm" ) ?
        &insertdoc( $packagename, $docdir ) :
        warn "Couldn't open output file for help document!\n";
    open( TXTFILE, ">$docdir/ole/$packagename.txt" ) ||
        warn "Couldn't open output file for help document!\n";
    
    print HTMLFILE <<"--end--";
<title>NT OLE module : $packagename</title>
<!-- Auto-generated Windows NT Perl OLE Automation module extension -->
<!-- generated by MkOLEx -->

<h2>Windows NT Perl 5, OLE Automation extension module</h2>

<hr>
<h1>$packagename</h1>
<hr>

<h2>Constructors/Destructors</h2>
<ul>
<li> CreateObject
<li> DestroyObject
</ul>

<h2>Instance Variables</h2>

All variables are have a &quot;Get&quot; and &quot;Set&quot; method
associated with them. For example, if we have the variable TimeOfDay,
the two methods used to access and modify the variable are:
<ul>
<li> GetTimeOfDay( \$x )
<li> SetTimeOfDay( \$x )
</ul>
<p>

Listed according to variable <i>Type</i> and <strong>Name</strong>.

<ul>
--end--

    print TXTFILE <<"--end--";
Windows NT Perl 5, OLE Autmation extension module


== $packagename ==


Constructors/Destructors
------------------------

 o CreateObject
 o DestroyObject

Instance Variables
------------------

All variables are have a "Get" and "Set" method
associated with them. For example, if we have the variable TimeOfDay,
the two methods used to access and modify the variable are:

 o GetTimeOfDay( \$x )
 o SetTimeOfDay( \$x )

Listed according to variable Type and Name.

--end--


    %typehash = &grabvartypes;

    foreach( sort( keys( %variables ) ) ) {
        $varArray = $variables{ $_ };
        ( $varName, $varMEMBERID, $varType ) = @$varArray;
        print HTMLFILE "<li> <i>" . $typehash{ $varType } .
            "</i> <strong>$varName</strong>\n";
	print TXTFILE "  o ($typehash{ $varType }) $varName\n";
    }
    
    print HTMLFILE <<"--end--";

</ul>

<h2>Methods</h2>

Listed here are all methods supplied by the $packagename object that
are supported by Windows NT Perl 5. Some methods accept a variable
number of parameters. For example, if we have the method DoSomething()
that accepts either 0, 2 or 5 parameters, the method will be listed in
the following way:
<ul>
<li><strong>DoSomething</strong>
<dl>
<dt>Required parameters: 0
<dt>Required parameters: 2
    <dd><i>type</i> <strong>arg1</strong> <i>type</i> <strong>arg2</strong>
<dt>Required parameters: 5
    <dd><i>type</i> <strong>arg1</strong> <i>type</i> <strong>arg2</strong>
        <i>type</i> <strong>arg3</strong> <i>type</i> <strong>arg4</strong>
        <i>type</i> <strong>arg5</strong>
</dl>
</ul>

Listing of methods follows:

<ul>
--end--

    print TXTFILE <<"--end--";

Methods
-------

Listed here are all methods supplied by the $packagename object that
are supported by Windows NT Perl 5. Some methods accept a variable
number of parameters. For example, if we have the method DoSomething()
that accepts either 0, 2 or 5 parameters, the method will be listed in
the following way:

 o Do Something

   Required parameters: 0
   Required parameters: 2
    (type) arg1
    (type) arg2
   Required parameters: 5
    (type) arg1
    (type) arg2
    (type) arg3
    (type) arg4
    (type) arg5

Listing of methods follows:
   
--end--

    foreach( sort( keys( %funcparams ) ) ) {
        print HTMLFILE "<li><strong>$_</strong>\n";
	print TXTFILE  " o $_\n\n";

        $hash = $funcparams{ $_ };
        %hash = %$hash;

        print HTMLFILE "<dl>";

        foreach ( sort( keys( %hash ) ) ) {

            print HTMLFILE "<dt>Required parameters: $_\n<dd>";
	    print TXTFILE  "   Require parameters: $_\n";

            $array = $hash{ $_ };
            @array = @$array;
            while ( ( $paraName, $paraType ) = splice( @array, 0, 2 ) ) {

                print HTMLFILE "<i>" . $typehash{ $paraType } .
                    "</i> <strong>$paraName</strong>,\n";
		print TXTFILE "    ($typehash{ $paraType }) $paraName\n";

            }    
        }            
        print HTMLFILE "</dl>";
	print TXTFILE  "\n\n";
    }

    print HTMLFILE "</ul><hr>";

    close( HTMLFILE );
    close( TXTFILE );
}

sub insertdoc {
    my( $packagename, $docdir ) = @_;
    &log( "Generating HTML document, placing in $docdir\\ole\n" );

    my( $magicstring );
    
    $magicstring = $packagename;
    $magicstring =~ tr/A-Z/a-z/;
    $magicstring .= " dOn't ToUcH mE 'cOz I'm A tOp SeCrEt MaGiC sTrInG :-P".

    open( OLEDOC, "$docdir/ntole.htm" )
        || do { warn "Couldn't find NTOLE.HTM for insertion!!\n"; return };
    @OLEDOC = <OLEDOC>;
    close( OLEDOC );
    
    @OLEDOC = grep( !/$magicstring/i, @OLEDOC );
    
    open( OLEDOC, ">$docdir/ntole.htm" )
        || do { warn "Couldn't open NTOLE.HTM for writing!!\n"; return };
    print OLEDOC @OLEDOC,
        "<!-- $magicstring --><h2><a href=\"ole/$packagename.htm\">$packagename</a></h2>\n";
    close( OLEDOC );        
}

sub grabvartypes {
    my( $libdir ) = @INC;
    my( %typehash );
    
    open( FILE, "$libdir/NT.ph" ) || warn $!;
    @file = <FILE>;
    close( FILE );
    
    grep(
        do {
            if ( /sub (VT_\w+) {([^;]+);}/ ) {
               $typehash{ $2 } = $1;
            }
        }, @file
    );
    return %typehash;
}

&main();

__END__
:endofperl
