#ifndef __WINDOW_P_H__
#define __WINDOW_P_H__

extern Lisp_Object make_window _P_((void));
extern struct Lisp_Vector * window_display_table _P_((struct window *w));
extern _VOID_ set_window_height _P_((Lisp_Object window, int height,
                                     int nodelete));
extern _VOID_ set_window_width _P_((Lisp_Object window, int width,
                                    int nodelete));
extern _VOID_ temp_output_buffer_show _P_((register Lisp_Object buf));
extern int window_height _P_((Lisp_Object window));
extern int window_width _P_((Lisp_Object window));
extern _VOID_ change_window_height _P_((register int delta, int widthflag));
extern int window_internal_height _P_((struct window *w));
extern int window_internal_width _P_((struct window *w));
extern _VOID_ window_scroll _P_((Lisp_Object window, int n, int noerror));
extern _VOID_ delete_all_subwindows _P_((register struct window *w));
extern _VOID_ init_window_once _P_((void));
extern _VOID_ syms_of_window _P_((void));
extern _VOID_ keys_of_window _P_((void));

DEFUN_P(Fwindowp, (Lisp_Object obj));
DEFUN_P(Fwindow_live_p, (Lisp_Object obj));
DEFUN_P(Fselected_window, (void));
DEFUN_P(Fminibuffer_window, (Lisp_Object frame));
DEFUN_P(Fwindow_minibuffer_p, (Lisp_Object window));
DEFUN_P(Fpos_visible_in_window_p, (Lisp_Object pos, Lisp_Object window));
DEFUN_P(Fwindow_buffer, (Lisp_Object window));
DEFUN_P(Fwindow_height, (Lisp_Object window));
DEFUN_P(Fwindow_width, (Lisp_Object window));
DEFUN_P(Fwindow_hscroll, (Lisp_Object window));
DEFUN_P(Fset_window_hscroll, (register Lisp_Object window,
                              register Lisp_Object ncol));
DEFUN_P(Fwindow_edges, (Lisp_Object window));
DEFUN_P(Fcoordinates_in_window_p, (register Lisp_Object coordinates,
                                   register Lisp_Object window));
DEFUN_P(Fwindow_at, (Lisp_Object x, Lisp_Object y, Lisp_Object frame));
DEFUN_P(Fwindow_point, (Lisp_Object window));
DEFUN_P(Fwindow_start, (Lisp_Object window));
DEFUN_P(Fwindow_end, (Lisp_Object window));
DEFUN_P(Fset_window_point, (Lisp_Object window, Lisp_Object pos));
DEFUN_P(Fset_window_start, (Lisp_Object window, Lisp_Object pos,
                            Lisp_Object noforce));
DEFUN_P(Fwindow_dedicated_p, (Lisp_Object window));
DEFUN_P(Fset_window_dedicated_p, (Lisp_Object window, Lisp_Object arg));
DEFUN_P(Fwindow_display_table, (Lisp_Object window));
DEFUN_P(Fset_window_display_table, (register Lisp_Object window,
                                    register Lisp_Object table));
DEFUN_P(Fdelete_window, (Lisp_Object window));
DEFUN_P(Fnext_window, (register Lisp_Object window,
                       register Lisp_Object minibuf,
                       register Lisp_Object all_frames));
DEFUN_P(Fprevious_window, (register Lisp_Object window,
                           register Lisp_Object minibuf,
                           register Lisp_Object all_frames));
DEFUN_P(Fother_window, (register Lisp_Object n,
                        register Lisp_Object all_frames));
DEFUN_P(Fget_lru_window, (Lisp_Object frames));
DEFUN_P(Fget_largest_window, (Lisp_Object frame));
DEFUN_P(Fget_buffer_window, (Lisp_Object buffer, Lisp_Object frame));
DEFUN_P(Fdelete_other_windows, (Lisp_Object window));
DEFUN_P(Fdelete_windows_on, (Lisp_Object buffer, Lisp_Object frame));
DEFUN_P(Freplace_buffer_in_windows, (Lisp_Object buffer));
DEFUN_P(Fset_window_buffer, (Lisp_Object window, Lisp_Object buffer));
DEFUN_P(Fselect_window, (Lisp_Object window));
DEFUN_P(Fdisplay_buffer, (Lisp_Object buffer, Lisp_Object not_this_window));
DEFUN_P(Fsplit_window, (Lisp_Object window, Lisp_Object chsize,
                        Lisp_Object horflag));
DEFUN_P(Fenlarge_window, (Lisp_Object n, Lisp_Object side));
DEFUN_P(Fshrink_window, (Lisp_Object n, Lisp_Object side));
DEFUN_P(Fscroll_up, (Lisp_Object n));
DEFUN_P(Fscroll_down, (Lisp_Object n));
DEFUN_P(Fscroll_other_window, (Lisp_Object n));
DEFUN_P(Fscroll_left, (Lisp_Object arg));
DEFUN_P(Fscroll_right, (Lisp_Object arg));
DEFUN_P(Frecenter, (Lisp_Object n));
DEFUN_P(Fmove_to_window_line, (register Lisp_Object arg));
DEFUN_P(Fwindow_configuration_p, (Lisp_Object obj));
DEFUN_P(Fset_window_configuration, (Lisp_Object configuration));
DEFUN_P(Fcurrent_window_configuration, (Lisp_Object frame));
DEFUN_P(Fsave_window_excursion, (Lisp_Object args));

#endif
