/* pc_term.h - BIOS video calls for GNU info
   Copyright (C) 1990 Free Software Foundation, Inc.
   Thorsten Ohl <td12@ddagsi3.bitnet>, 1990

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/info/RCS/pc_term.h 0.3 90/10/07 21:35:09 tho Exp $
 */

/* Interfacing info.c and pc_term.c  */

extern void do_term (int command);
extern void opsys_init_terminal (void);
extern void opsys_goto_pos (int x, int y);
extern int pc_getc (void);


/* Command codes.  */

#define terminal_ear_bell		257
#define terminal_clearEOP		258
#define terminal_clearEOL		259
#define terminal_use_begin		260
#define terminal_use_end		261
#define terminal_inverse_begin		262
#define terminal_end_attributes		263

extern int terminal_rows;
extern int terminal_lines;


/* Colors.  */

#define BRIGHT_ATTRIB	0x08

#define RED_ATTRIB	0x04
#define GREEN_ATTRIB	0x02
#define BLUE_ATTRIB	0x01
#define BLACK_ATTRIB	0x00

#define WHITE_ATTRIB	(RED_ATTRIB|GREEN_ATTRIB|BLUE_ATTRIB)

#define FG_BG(f,b)	(((b##_ATTRIB) << 4) | (f##_ATTRIB))


/* Pick your favourite colors here: */

#ifndef NORMAL_ATTRIB
#ifndef MONOCHROME
#define NORMAL_ATTRIB	FG_BG (WHITE, BLACK)
#else
#define NORMAL_ATTRIB	FG_BG (WHITE, BLACK)
#endif
#endif

#ifndef INVERSE_ATTRIB
#ifndef MONOCHROME
#define INVERSE_ATTRIB	FG_BG (BLUE, WHITE)
#else
#define INVERSE_ATTRIB	FG_BG (BLACK, WHITE)
#endif
#endif

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */





