#!/usr/bin/perl -s
eval "exec /usr/bin/perl -s -S $0 $*"
    if $running_under_some_shell;

# Convert `Makefile.in' into a Makefile for MSDOS.
# Copyright (C) 1991, 1993, 1994 Free Software Foundation, Inc.
# Francois Pinard <pinard@iro.umontreal.ca>, 1991

# Usage: $0 [-djgpp|-tcc]

$makefile_out = "makefile." . ($djgpp ? "djg" : $tcc ? "tcc" : "dos");

# $assign{VARIABLE} forces the value of VARIABLE=.
# $substitute{VARIABLE} forces the value of @VARIABLE@.

### Get PRODUCT and VERSION from configure.in.  Preset some others.
### 
### msdos_VARIABLE=VALUE lines in Makefile.in will provide some more.

open (CONFIGURE_IN, "configure.in") || die "Cannot read configure.in\n";
while (<CONFIGURE_IN>)
{
    $substitute{$1} = $2 if /^(PRODUCT|VERSION)=(.*)/;
}
close CONFIGURE_IN;

$assign{"AR"} = $djgpp ? "ar" : $tcc ? "tlib" : "@echo :";
$assign{"DEFS"} = "-DHAVE_CONFIG_H";
$assign{"LINK"} = "\$(CC) \$(LDFLAGS) -e\$@" if $tcc;
$assign{"MAKEINFO"} = "@echo :";
$assign{"TEXI2DVI"} = "@echo :";

$substitute{"ALLOCA"} = "";
$substitute{"ANSI2KNR"} = "";
$substitute{"AWK"} = "@echo :";
$substitute{"CC"} = $djgpp ? "gcc" : $tcc ? "tcc -v -N" : "@echo :";
$substitute{"CFLAGS"} = "";
$substitute{"CPPFLAGS"} = "";
$substitute{"DEFS"} = "";
$substitute{"INSTALL"} = "@echo :";
$substitute{"INSTALL_DATA"} = $djgpp ? "cp" : "copy";
$substitute{"INSTALL_PROGRAM"} = $djgpp ? "cp" : "copy";
$substitute{"LDFLAGS"} = "";
$substitute{"LEX"} = $djgpp ? "flex" : "@echo :";
$substitute{"LIBOBJS"} = "";
$substitute{"LIBS"} = "";
$substitute{"RANLIB"} = $djgpp ? "ranlib" : "@echo :";
$substitute{"U"} = "";
$substitute{"VPATH"} = ".";
$substitute{"YACC"} = $djgpp ? "bison -y" : "@echo :";

$substitute{"exec_prefix"} = "/usr/local";
$substitute{"prefix"} = "/usr/local";
$substitute{"program_transform_name"} = "s,x,x,";
$substitute{"srcdir"} = ".";

### Default file renames for MSDOS.  Macros DISTFILES, *HDRS, *HEADERS,
### *SRCS, *SOURCES, *OBJS, *OBJECTS also introduce file lists.

$dosname{"GNUmakefile"} = "makefile.gnu";

### Transform Makefile.in into $makefile_out.

open (MAKEFILE_IN, "Makefile.in") || die "Cannot read Makefile.in\n";
open (MAKEFILE_OUT, ">$makefile_out") || die "Cannot create $makefile_out\n";
select MAKEFILE_OUT;

print <<EOF;
# $makefile_out.  Generated automatically from Makefile.in by configdos.
EOF

while (<MAKEFILE_IN>)
{
    # Process Makefile.in comments.  A few are special purpose.

    if (/^\#=(msdos|djgpp|tcc)=(.*)/)
    {
	# An =msdos= comment outputs the remainder of the line, verbatim.

	if ($1 eq "msdos" || $1 eq "djgpp" && $djgpp || $1 eq "tcc" && $tcc)
	{
	    print $2, "\n";
	}
	next;
    }

    if (/^\#-(msdos|djgpp|tcc)/)
    {
	# An -msdos comment remove all lines until an +msdos comment.

	if ($1 eq "msdos" || $1 eq "djgpp" && $djgpp || $1 eq "tcc" && $tcc)
	{
	    $flag = $1;
	    while (<MAKEFILE_IN>)
	    {
		last if /^\#\+$flag/;
	    }
	    last if ! $_;
	}
	next;
    }

    if (/^\#/)
    {
	# Copy other comments verbatim.

	print;
	next;
    }

    # Remove some lines.

    next if /^tags: TAGS$/;
    next if /^SHELL\s*=/ && $tcc;
    next if /\`/ && $tcc;

    # Execute @...@ substitutions.

    while (/(.*)\@(\w[\w0-9]*)\@(.*)/)
    {
	if (defined $substitute{$2})
	{
	    $_ = $1 . $substitute{$2} . $3;
	}
	else
	{
	    warn "Makefile.in:$.: @$2@ not substituted\n";
	    last;
	}
    }

    # Save msdos_* definitions for later substitution.

    if (/^(msdos|djgpp|tcc)_PROGRAMS\s*=\s*(.*)/)
    {
	# msdos_PROGRAMS announce file names which should have .exe appended.

	if ($1 eq "msdos" || $1 eq "djgpp" && $djgpp || $1 eq "tcc" && $tcc)
	{
	    foreach $program (split (' ', $2))
	    {
		$dosname{$program} = &dosfn ("$program.exe");
		$program{$program} = 1;
	    }
	}
	next;
    }

    if (/^(msdos|djgpp|tcc)_([^\s]+)\s*=\s*(.*)/)
    {
	if ($1 eq "msdos" || $1 eq "djgpp" && $djgpp || $1 eq "tcc" && $tcc)
	{
	    $assign{$2} = $3;
	    $substitute{$2} = $3;
	}
	next;
    }

    # Some macros annonce list of files.  Study these lines to get a
    # better %dosname cache.

    s/\$O\b/.o/g;

    if (/^(DISTFILES|\w*HDRS|\w*HEADERS)\s*=\s*(.*)/)
    {
	&studylist ($2);
	$studylist = 1;
    }
    elsif (/^(\w*SRCS|\w*SOURCES|\w*OBJS|\w*OBJECTS)\s*=\s*(.*)/)
    {
	&studylist ($2);
	$studylist = 1;
    }
    elsif ($studylist)
    {
	&studylist ($_);
    }

    if ($studylist && ! /\\$/)
    {
	$studylist = 0;
    }

    # Extract each word of the line and process it.

    ($_, $line) = /^(\w[\w0-9]*\s*=\s*)?(.*)/;
    while ($line =~ /[-.\w\/]+/)
    {
	$_ .= $`;
	$line = $';

	if (defined $dosname{$&})
	{
	    # Execute any previously saved substitution.

	    $value = $dosname{$&};
	}
	else
	{
	    $value = $&;
	    if ($value =~ /^[^.]+\.[^.]+$/ || $value =~ /^stamp-/)
	    {
		# Normalize anything resembling a file name.

		$value = &dosfn ($value);
	    }
	}
	$_ .= $value;
    }
    $_ .= $line . "\n";

    # Check for other special modifications.

    if ((/^\.SUFFIXES: / || /^\.c\.o:$/) && $tcc)
    {
	s/\.o/\.obj/;
	print;
	next;
    }

    if (/^\t\$\(LINK\)/ && $djgpp)
    {
	$aout = 1;
	print;
	next;
    }

    if (/^\t\$\(LINK\)/ && $tcc)
    {
	s/\$\(OBJECTS\)/@objects.tcc/;
	print;
	next;
    }

    if (/^\t\$\(AR\)\scru\s/ && $tcc)
    {
	s/\scru//;
	s/\$\(LIBOBJS\)/@libobjs.tcc/;
	print;
	next;
    }

    if (/^\w+\s*=\s*:\b/ || /^\t:\b/)
    {
	s/:/@echo :/;
	print;
	next;
    }

    if ((/^\w+\s*=\s*cp\b/ || /^\tcp\b/) && ! $djgpp)
    {
	s/cp(\s+-\w+)*/copy/;
	print;
	next;
    }

    if (/^\w+\s*=\s*rm\b/ && ! $djgpp)
    {
	s/rm(\s+-\w+)*/erase/;
	print;
	next;
    }

    if (/^\trm(\s+-\w+)*\s+(.*)/ && ! $djgpp)
    {
	foreach (split (' ', $2))
	{
	    print "\terase $_\n";
	}
	next;
    }

    if (/^(\w+)\s*=/ && defined $assign{$1})
    {
	print $1, " = ", $assign{$1}, "\n";
	next;
    }

    if (/^$/ && $aout)
    {
	$aout = 0;
	print "\taout2exe $*\n";
	print "\trm $*\n";
	print "\n";
	next;
    }

    print;
}
select;
close MAKEFILE_IN;
close MAKEFILE_OUT;
exit 0;

### Prepare substitutions for the given list of files.

sub studylist
{
    $list = $_[0];
    $list =~ s/\$\(\w+\)//g;
    $list =~ s/\\$//;
    while ($list =~ /([-.\w\/]+)/)
    {
	$list = $';
	$value = $&;
	$dosname{$value} = &dosfn ($&);
    }
}

### Map a UNIX filename into an MSDOS filename.

# Turn the argument into an MSDOS file name.
# Copyright (C) 1992, 1993, 1994 Free Software Foundation, Inc.
# Francois Pinard <pinard@iro.umontreal.ca>, 1992.

# Predefine $tcc if necessary.

sub dosfn
{
    local ($whole, $prefix, $name, $ext);

    $whole = $_[0];
    $whole =~ y/A-Z/a-z/;

    # Change any beginning period with an underline.

    $whole =~ s/^\./_/;

    # Change all periods except the last with underlines.

    while ($whole =~ /(.*)\.(.*)\.(.*)/)
    {
	$whole = "$1_$2.$3";
    }

    # If no period at all, let flow characters after the 8th into the
    # the extension.

    if ($whole =~ /^(.*\/)?([^.\/]+)$/)
    {
	($prefix, $name, $ext) = ($1, $2, "");
	if (length ($name) > 8)
	{
	    $ext = substr ($name, 8);
	    $name = substr ($name, 0, 8);
	    $ext = substr ($ext, 0, 3) if length ($ext) > 3;
	    return "$prefix$name.$ext";
	}
	return "$prefix$name";
    }

    # There is only one period, truncate to 8 characters before it and
    # to 3 characters after it.

    if ($whole =~ /^(.*\/)?([^.\/]+)\.([^.\/]+)$/)
    {
	($prefix, $name, $ext) = ($1, $2, $3);
	$name = substr ($name, 0, 8) if length ($name) > 8;
	if ($ext eq "a" && $tcc)
	{
	    $ext = "lib";
	}
	elsif ($ext eq "o" && $tcc)
	{
	    $ext = "obj";
	}
	elsif ($ext eq "texi" || $ext eq "texinfo")
	{
	    $ext = "ti";
	}
	elsif (length ($ext) > 3)
	{
	    $ext = substr ($ext, 0, 3);
	}
	return "$prefix$name.$ext";
    }

    # This should not happen.

    warn "Error in dosfn.pl for \`$_[0]'\n";
    return $_[0];
}

