; -----------------------------------------------------------------------------
; Copyright (C) 1993 Morten Welinder
; This file is not part of GNU Make, but part of the MSDOS port of GNU Make.
; This file may be copied under the same conditions as GNU Make:
; 
; GNU Make is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2, or (at your option)
; any later version.
; 
; GNU Make is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with GNU Make; see the file COPYING.  If not, write to
; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
; -----------------------------------------------------------------------------
; Spawn a file using primitive swap to Xms.  This file is placed in the public
; domain.  Nothing too fancy is attempted here -- just move everything after
; this module into Xms and shrink the memory block.  Must be linked in early
; or else little will be swapped out.
;
; Handlers are setup for interrupt 23h, so that Ctrl-Breaks in the child
; process won't cause the calling program's handlers to do funny things and
; crash the system.  Turbo C also takes over Int 02, but I don't know what
; to do about it.
;
; A handler is setup for interrupt 21h to capture the exit code from programs
; run by the shell (command.com) because command.com kills it.
;
; Morten Welinder, November 1993
; -----------------------------------------------------------------------------
ideal
model large,C
public spawn_child
; -----------------------------------------------------------------------------
dataseg
extrn _psp:word
extrn exit_codes:byte
extrn error_if_shell:byte
; -----------------------------------------------------------------------------
codeseg
exec_block	dw	?
		dw	offset cmdlinesafe,@code
		dw	offset fcb1,@code
		dw	offset fcb2,@code

fcb1		db	16 dup (?)
fcb2		db	16 dup (?)
cmdlinesafe	db	128 dup (?)
cmdsafe		db	80 dup (?)
newstack	db	512 dup (?)
oldstack	dd	?
old21		dd	?
old23		dd	?
old24		dd	?
localexitcodes	db	?,?
localexeccount	db	?
localwriteerr	db	?
result		dw	?
swap_size	dd	?
swap_size_k	dw	?
pspcopy		dw	?
envend		dw	?
oldend		dw	?
xmscall		dd	?
xmshandle	dw	?
xmblock		dd	?
		dw	?
		dd	?
		dw	?
		dd	?
err_noxms	db	'gmake.exe: *** No or not enough Xms memory '
		db	'available for swapping.  Stop.',13,10,13,10,'$'
err_badxms	db	'gmake.exe: *** Swapping error.  Stop.',13,10,13,10,'$'
err_badmem	db	'gmake.exe: *** Cannot resize memory block for '
		db	'swapping.   Stop.',13,10,13,10,'$'
; -----------------------------------------------------------------------------
proc spawn_child
arg path:dword,cmdline:dword,envstr:dword,envlen:word

		push	ds si di
		
		mov	ax,offset envplace
		mov	cl,4
		shr	ax,cl
		inc	ax
		add	ax,@code
		mov	[exec_block],ax
		mov	es,[_psp]
		mov	[pspcopy],es
		mov	bx,[word es:2]
		mov	[oldend],bx
		sub	ax,bx
		neg	ax
		xor	bx,bx
		mov	dx,ax
@@2:		shl	ax,1
		rcl	bx,1
		loop	@@2
		mov	[word swap_size],ax		
		mov	[word swap_size+2],bx
		add	dx,63
		mov	cl,6
		shr	dx,cl
		mov	[word swap_size_k],dx		

		call	export_memory

		lds	si,[cmdline]		; Copy command line to safe pl.
		mov	di,offset cmdlinesafe+1
		mov	cl,0
@@5:		mov	al,[si]
		cmp	al,0
		je	@@6
		mov	[cs:di],al
		inc	cl
		inc	si
		inc	di
		jmp	@@5
@@6:		mov	[byte cs:di],13
		mov	[cmdlinesafe],cl
		mov	ax,cs
		mov	ds,ax
		mov	es,ax
		mov	si,offset cmdlinesafe+1
		mov	di,offset fcb1
		mov	ax,2901h
		int	21h
		mov	di,offset fcb2		; Strictly speaking this
		mov	ax,2901h		; is incorrect, but every-
		int	21h			; body does it.

		lds	si,[path]		; Copy command to safe place
		mov	di,offset cmdsafe
		mov	cx,40			; (Dirty, but easy)
		rep	movsw

		mov	es,[exec_block]
		xor	di,di
		lds	si,[envstr]
		mov	cx,[envlen]
		rep	movsb
		add	di,15
		mov	cl,4
		shr	di,cl
		add	di,[exec_block]
		mov	[envend],di

		mov	ax,3521h		; Save old vectors
		int	21h
		mov	[word old21],bx
		mov	[word old21+2],es
		mov	ax,3523h
		int	21h
		mov	[word old23],bx
		mov	[word old23+2],es
		mov	ax,3524h
		int	21h
		mov	[word old24],bx
		mov	[word old24+2],es

		mov	ax,0
		mov	[word localexitcodes],ax
		mov	[word localexeccount],ax

		mov	[word oldstack],sp
		mov	[word oldstack+2],ss
		mov	ax,cs			; Switch to new stack
		mov	ds,ax
		mov	es,ax
		mov	ss,ax
		mov	sp,offset oldstack
assume ds:@code

		call	shrink_memory

		mov	ax,2521h		; Set new 21h, 23h, 24h
		mov	dx,offset new21
		int	21h
		mov	ax,2523h
		mov	dx,offset new23
		int	21h
		mov	ax,2524h
		mov	dx,offset new24
		int	21h

		mov	dx,offset cmdsafe
		mov	bx,offset exec_block
		mov	ax,4b00h
;		int	3
		int	21h
assume ds:nothing
		mov	ax,1
		jc	@@1
		mov	ah,4dh
		int	21h
@@1:		mov	[result],ax

		call	restore_ints
		call	expand_memory
		call	import_memory

		mov	ss,[word oldstack+2]
		mov	sp,[word oldstack]
		pop	di si ds
assume ds:@data
		cmp	[localexeccount],1
		je	@@4
		mov	al,[localexitcodes+1]
		jmp	@@3
@@4:		mov	al,[localwriteerr]
		shl	al,1			; 0 or ENOENT
@@3:		mov	[error_if_shell],al
		mov	ax,[result]
		ret
endp
; -----------------------------------------------------------------------------
assume ds:nothing
proc new21 far
		cmp	ah,4bh
		je	@@exec
		cmp	ah,40h
		je	@@write
		cmp	ah,4ch
		jne	@@0
		push	ax
		mov	ah,[localexitcodes]
		mov	[word localexitcodes],ax
		pop	ax
@@0:		jmp	[old21]
@@exec:		cmp	[localexeccount],2
		je	@@0
		inc	[localexeccount]
		jmp	@@0
@@write:	cmp	bx,2
		jne	@@0
		mov	[localwriteerr],1
		jmp	@@0
endp

proc new23 far
		stc			; Signal error
		ret
endp

proc new24 far
		call	restore_ints
		mov	al,1		; retry
		iret
endp
; -----------------------------------------------------------------------------
proc restore_ints near
		push	ds
		push	ax
		mov	ax,0
		mov	ds,ax
		cli
		mov	ax,[word old21]
		mov	[word ds:21h*4],ax
		mov	ax,[word old21+2]
		mov	[word ds:21h*4+2],ax
		mov	ax,[word old23]
		mov	[word ds:23h*4],ax
		mov	ax,[word old23+2]
		mov	[word ds:23h*4+2],ax
		mov	ax,[word old24]
		mov	[word ds:24h*4],ax
		mov	ax,[word old24+2]
		mov	[word ds:24h*4+2],ax
		sti
		pop	ax
		pop	ds
		ret
endp
; -----------------------------------------------------------------------------
proc export_memory near
		mov	ax,4300h
		int	2fh
		cmp	al,80h
		jne	fatal1
		mov	ax,4310h
		int	2fh
		mov	[word xmscall],bx
		mov	[word xmscall+2],es
		mov	dx,[swap_size_k]
		mov	ah,9
		call	[xmscall]
		cmp	ax,1
		jne	fatal1
		mov	[xmshandle],dx

		mov	ax,[word swap_size]
		mov	[word xmblock],ax
		mov	ax,[word swap_size+2]
		mov	[word xmblock+2],ax
		mov	[word xmblock+4],0
		mov	[word xmblock+6],0
		mov	ax,[word exec_block]
		mov	[word xmblock+8],ax
		mov	[word xmblock+10],dx
		mov	[word xmblock+12],0
		mov	[word xmblock+14],0
		push	ds
		mov	ax,cs
		mov	ds,ax
		mov	si,offset xmblock
		mov	ah,0bh
		call	[xmscall]
		pop	ds
		cmp	ax,1
		mov	dx,offset err_badxms
		jne	fatal
		ret
fatal1:		mov	dx,offset err_noxms
		jmp	fatal
endp
; -----------------------------------------------------------------------------
proc import_memory near

		mov	ax,[word swap_size]
		mov	[word xmblock],ax
		mov	ax,[word swap_size+2]
		mov	[word xmblock+2],ax
		mov	[word xmblock+10],0
		mov	[word xmblock+12],0
		mov	ax,[word exec_block]
		mov	[word xmblock+14],ax
		mov	ax,[xmshandle]
		mov	[word xmblock+4],ax
		mov	[word xmblock+6],0
		mov	[word xmblock+8],0
		push	ds
		mov	ax,cs
		mov	ds,ax
		mov	si,offset xmblock
		mov	ah,0bh
		call	[xmscall]
		pop	ds
		cmp	ax,1
		mov	dx,offset err_badxms
		jne	fatal
		mov	dx,[xmshandle]
		mov	ah,0ah
		call	[xmscall]
		cmp	ax,1
		mov	dx,offset err_badxms
		jne	fatal
		ret
endp
; -----------------------------------------------------------------------------
fatal:		mov	ax,cs
		mov	ds,ax
		mov	ah,9
		int	21h
		mov	ax,4cffh
		int	21h
		int	20h
; -----------------------------------------------------------------------------
proc shrink_memory near
		push	es
		mov	bx,[pspcopy]
		mov	es,bx
		sub	bx,[envend]
		neg	bx
		inc	bx
		mov	ah,4ah
		int	21h
		pop	es
		mov	dx,offset err_badmem
		jc	fatal
		ret
endp
; -----------------------------------------------------------------------------
proc expand_memory near
		mov	es,[pspcopy]
		mov	bx,[oldend]
		sub	bx,[pspcopy]
		mov	ah,4ah
		int	21h
		mov	dx,offset err_badmem
		jc	fatal
		ret
endp
; -----------------------------------------------------------------------------
proc debug_str
		push	ax
		push	dx
		mov	ah,2
		mov	dl,'<'
		int	21h
@@1:		mov	dl,[bx]
		inc	bx
		mov	ah,2
		int	21h
		loop	@@1
		mov	ah,2
		mov	dl,'>'
		int	21h
		mov	ah,2
		mov	dl,13
		int	21h
		mov	ah,2
		mov	dl,10
		int	21h
		pop	dx
		pop	ax
		ret
endp debug_str
; -----------------------------------------------------------------------------
envplace:
; -----------------------------------------------------------------------------
end
