/* CHMOD.C - reimplementation of chmod() for MS-DOS Microsoft C
 ******************************************************************************
 *
 *	int chmod(char *file, int mode)
 *
 ******************************************************************************
 * edit history is at the end of the file
 ******************************************************************************
 * Copyright 1995 by the Summer Institute of Linguistics, Inc.
 *
 * This file is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; see the file COPYING.LIB.  If
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave,
 * Cambridge, MA 02139, USA.
 */
#include <dos.h>		/* For _dos_getfileattr(), ... */

/*****************************************************************************
 * NAME
 *    chmod
 * ARGUMENTS
 *    file - file/directory pathname
 *    mode - Unix-style permission mode bits
 * DESCRIPTION
 *    change the permission mode for the file.  Only the Write bits matters.
 *
 *    The Microsoft C implementation of chmod() does not handle directories.
 *    i don't know if that is a bug or a brain-dead feature!
 * RETURN VALUE
 *    0 if successful, -1 if error
 */
int chmod(char *file, int mode)
{
unsigned attrib;

if (_dos_getfileattr(file, &attrib) != 0)
    return(-1);
if (mode & 0222)			/* write permission? */
    attrib &= ~_A_RDONLY;		/* yes -- turn off read-only */
else
    attrib |= _A_RDONLY;		/* no -- turn on read-only */
attrib &= ~_A_SUBDIR;		/* missing step from Microsoft's chmod() */
if (_dos_setfileattr(file, attrib) != 0)
    return(-1);
return(0);
}

/******************************************************************************
 * EDIT HISTORY
 ******************************************************************************
 * 22-Feb-95	SRMc - write chmod() function for MS-DOS that handles
 *			directories properly
 */
